/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.integrations.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.BlocksRegistry;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipe;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipes;

public class IncineratorCategory
extends BlankRecipeCategory<IncineratorRecipeWrapper> {
    public static final String UID = "Incinerator";
    private IDrawable background = null;
    private IDrawable slotBackground = null;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new IncineratorCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)BlocksRegistry.incinerator), new String[]{UID});
        registry.handleRecipes(IncineratorRecipe.class, IncineratorRecipeWrapper::new, UID);
        registry.addRecipes(IncineratorRecipes.getRecipes(), UID);
    }

    public IncineratorCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TeslaThingiesMod.JEI_TEXTURES, 0, 0, 124, 66);
        this.slotBackground = guiHelper.createDrawable(TeslaThingiesMod.MACHINES_TEXTURES, 6, 6, 18, 18);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return BlocksRegistry.incinerator.func_149732_F();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IncineratorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 6, 6);
        stacks.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        IncineratorRecipe recipe = recipeWrapper.recipe;
        if (recipe.secondaryOutputs != null && recipe.secondaryOutputs.length > 0) {
            int index = 1;
            for (SecondaryOutput so : recipe.secondaryOutputs) {
                stacks.init(index, false, new IIngredientRenderer<ItemStack>(){
                    private SecondaryOutput so;

                    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
                        minecraft.func_175599_af().func_175042_a(ingredient, xPosition, yPosition);
                        minecraft.func_175599_af().func_180453_a(minecraft.field_71466_p, ingredient, xPosition + 1, yPosition + 1, null);
                        String percent = "" + Math.round(this.so.chance * 100.0f) + "%";
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)(xPosition + 8), (float)(yPosition + 20), (float)0.0f);
                        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)1.0f);
                        minecraft.field_71466_p.func_78276_b(percent, -minecraft.field_71466_p.func_78256_a(percent) / 2, 0, 0x424242);
                        GlStateManager.func_179121_F();
                    }

                    public List<String> getTooltip(Minecraft minecraft, ItemStack ingredient) {
                        return ingredient.func_82840_a((EntityPlayer)minecraft.field_71439_g, minecraft.field_71474_y.field_82882_x);
                    }

                    public FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
                        return minecraft.field_71466_p;
                    }

                    IIngredientRenderer<ItemStack> init(SecondaryOutput so) {
                        this.so = so;
                        return this;
                    }
                }.init(so), 6 + (index - 1) * 18, 45, 18, 18, 1, 1);
                stacks.set(index, so.stack);
                stacks.setBackground(index, this.slotBackground);
                ++index;
            }
        }
    }

    public static class IncineratorRecipeWrapper
    extends BlankRecipeWrapper {
        private IncineratorRecipe recipe;

        public IncineratorRecipeWrapper(IncineratorRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.recipe.input);
            if (this.recipe.secondaryOutputs != null && this.recipe.secondaryOutputs.length > 0) {
                ArrayList secondary = Lists.newArrayList();
                for (SecondaryOutput so : this.recipe.secondaryOutputs) {
                    secondary.add(so.stack.func_77946_l());
                }
                ingredients.setOutputs(ItemStack.class, (List)secondary);
            }
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            String power = String.format("%,d T", this.recipe.power);
            minecraft.field_71466_p.func_78276_b(power, 44, 15 - minecraft.field_71466_p.field_78288_b / 2, 32639);
        }
    }
}

