/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.FluidTank;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.FluidUtils;
import net.ndrei.teslapoweredthingies.gui.FluidBurnerTankPiece;
import net.ndrei.teslapoweredthingies.gui.GeneratorBurnPiece;
import net.ndrei.teslapoweredthingies.gui.IDualTankMachine;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolant;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuel;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerRecipes;

public class FluidBurnerEntity
extends ElectricGenerator
implements IDualTankMachine {
    private FluidTank coolantTank;
    private FluidTank fuelTank;
    private ItemStackHandler coolantItems;
    private ItemStackHandler fuelItems;
    private Fluid coolantInUse = null;
    private Fluid fuelInUse = null;

    public FluidBurnerEntity() {
        super(FluidBurnerEntity.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        this.coolantItems = new ItemStackHandler(2);
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.coolantItems, EnumDyeColor.MAGENTA, "Coolant Containers", new BoundingRectangle(61, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return slot == 0 && FluidUtils.canFillFrom((IFluidTank)FluidBurnerEntity.this.coolantTank, stack);
            }

            public boolean canExtractItem(int slot) {
                return slot != 0;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 1, box.getLeft() + 1, box.getTop() + 1 + 36));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    pieces.add(new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 54, TeslaThingiesMod.MACHINES_TEXTURES, 6, 44));
                }
                return pieces;
            }
        });
        super.addInventoryToStorage(this.coolantItems, "inv_coolant");
        this.coolantTank = new FluidTank(5000);
        super.addFluidTank((IFluidTank)new ColoredFluidHandler((IFluidTank)this.coolantTank, EnumDyeColor.BLUE, "Coolant Tank", new BoundingRectangle(79, 25, 18, 54)){

            public boolean acceptsFluid(@Nonnull FluidStack fluid) {
                return FluidBurnerRecipes.isCoolant(fluid);
            }

            public boolean canDrain() {
                return false;
            }
        }, null);
        this.fuelTank = new FluidTank(5000);
        super.addFluidTank((IFluidTank)new ColoredFluidHandler((IFluidTank)this.fuelTank, EnumDyeColor.RED, "Fuel Tank", new BoundingRectangle(97, 25, 18, 54)){

            public boolean acceptsFluid(@Nonnull FluidStack fluid) {
                return FluidBurnerRecipes.isFuel(fluid);
            }

            public boolean canDrain() {
                return false;
            }
        }, null);
        this.fuelItems = new ItemStackHandler(2);
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.fuelItems, EnumDyeColor.PURPLE, "Fuel Containers", new BoundingRectangle(115, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return slot == 0 && FluidUtils.canFillFrom((IFluidTank)FluidBurnerEntity.this.fuelTank, stack);
            }

            public boolean canExtractItem(int slot) {
                return slot != 0;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 1, box.getLeft() + 1, box.getTop() + 1 + 36));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    pieces.add(new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 54, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 78, 189));
                }
                return pieces;
            }
        });
        super.addInventoryToStorage(this.fuelItems, "inv_fuel");
    }

    protected void ensureFluidItems() {
    }

    protected void processImmediateInventories() {
        super.processImmediateInventories();
        this.processFluidItems(this.coolantItems, (IFluidTank)this.coolantTank);
        this.processFluidItems(this.fuelItems, (IFluidTank)this.fuelTank);
    }

    private void processFluidItems(ItemStackHandler handler, IFluidTank tank) {
        ItemStack stack = handler.getStackInSlot(0);
        if (!ItemStackUtil.isEmpty((ItemStack)stack) && FluidUtils.canFillFrom(tank, stack)) {
            ItemStack result = FluidUtils.fillFluidFrom(tank, stack);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)result)) {
                handler.setStackInSlot(0, result);
                this.discardUsedFluidItem(handler);
            }
        } else if (!ItemStackUtil.isEmpty((ItemStack)stack)) {
            this.discardUsedFluidItem(handler);
        }
    }

    private void discardUsedFluidItem(ItemStackHandler handler) {
        ItemStack source = handler.getStackInSlot(0);
        ItemStack result = handler.insertItem(1, source, false);
        handler.setStackInSlot(0, result);
    }

    protected long consumeFuel() {
        FluidBurnerFuel fuel = FluidBurnerRecipes.drainFuel((IFluidTank)this.fuelTank, true);
        if (fuel != null) {
            long power = fuel.recipe.baseTicks;
            this.fuelInUse = fuel.fuel.getFluid();
            FluidBurnerCoolant coolant = FluidBurnerRecipes.drainCoolant((IFluidTank)this.coolantTank, true);
            if (coolant != null) {
                power = (long)((float)power * coolant.recipe.timeMultiplier);
                this.coolantInUse = coolant.coolant.getFluid();
            }
            return power *= this.getEnergyFillRate();
        }
        return 0L;
    }

    protected long getEnergyOutputRate() {
        return 80L;
    }

    protected long getEnergyFillRate() {
        return 80L;
    }

    public Fluid getCoolantInUse() {
        return this.coolantInUse;
    }

    public Fluid getFuelInUse() {
        return this.fuelInUse;
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new GeneratorBurnPiece(144, 63, this));
        pieces.add(new FluidBurnerTankPiece(142, 27, this));
        return pieces;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.fuelInUse != null) {
            compound.func_74778_a("fuelInUse", FluidRegistry.getFluidName((Fluid)this.fuelInUse));
        }
        if (this.coolantInUse != null) {
            compound.func_74778_a("coolantInUse", FluidRegistry.getFluidName((Fluid)this.coolantInUse));
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("fuelInUse")) {
            this.fuelInUse = FluidRegistry.getFluid((String)compound.func_74779_i("fuelInUse"));
        }
        if (compound.func_74764_b("coolantInUse")) {
            this.coolantInUse = FluidRegistry.getFluid((String)compound.func_74779_i("coolantInUse"));
        }
    }

    @Override
    public float getLeftTankPercent() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.coolantTank.getFluidAmount() / (float)this.coolantTank.getCapacity()));
    }

    @Override
    public float getRightTankPercent() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.fuelTank.getFluidAmount() / (float)this.fuelTank.getCapacity()));
    }

    @Override
    public Fluid getLeftTankFluid() {
        FluidStack stack = this.coolantTank.getFluid();
        return stack == null ? null : stack.getFluid();
    }

    @Override
    public Fluid getRightTankFluid() {
        FluidStack stack = this.fuelTank.getFluid();
        return stack == null ? null : stack.getFluid();
    }
}

