/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.tileentities.ElectricMachine;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.gui.IDualTankMachine;
import net.ndrei.teslapoweredthingies.machines.fluidsolidifier.FluidSolidifierResult;

public class FluidSolidifierEntity
extends ElectricMachine
implements IDualTankMachine {
    private IFluidTank waterTank;
    private IFluidTank lavaTank;
    private ItemStackHandler outputs;
    private FluidSolidifierResult resultType = FluidSolidifierResult.COBBLESTONE;
    private FluidSolidifierResult lastWorkResult = null;

    public FluidSolidifierEntity() {
        super(FluidSolidifierEntity.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        super.ensureFluidItems();
        this.waterTank = super.addFluidTank(FluidRegistry.WATER, 5000, EnumDyeColor.BLUE, "Water Tank", new BoundingRectangle(79, 25, 18, 54));
        this.lavaTank = super.addFluidTank(FluidRegistry.LAVA, 5000, EnumDyeColor.RED, "Lava Tank", new BoundingRectangle(97, 25, 18, 54));
        this.outputs = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                FluidSolidifierEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.outputs, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(151, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                for (int y = 0; y < 3; ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, box.getLeft() + 1, box.getTop() + 1 + y * 18));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 3, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.PURPLE));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.outputs, "inv_outputs");
    }

    protected boolean shouldAddFluidItemsInventory() {
        return true;
    }

    protected BoundingRectangle getFluidItemsBoundingBox() {
        return new BoundingRectangle(61, 25, 18, 54);
    }

    protected void addFluidItemsBackground(List<IGuiContainerPiece> pieces, BoundingRectangle box) {
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 54, TeslaThingiesMod.MACHINES_TEXTURES, 6, 44));
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(115, 32, 36, 40, TeslaThingiesMod.MACHINES_TEXTURES, 61, 43));
        pieces.add(new ToggleButtonPiece(125, 44, 16, 16){

            protected int getCurrentState() {
                return 0;
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
                super.renderItemStack(container, ((FluidSolidifierEntity)FluidSolidifierEntity.this).resultType.resultStack, box);
            }

            protected void clicked() {
                FluidSolidifierEntity.this.resultType = FluidSolidifierResult.fromStateIndex((((FluidSolidifierEntity)FluidSolidifierEntity.this).resultType.stateIndex + 1) % FluidSolidifierResult.VALUES.length);
                NBTTagCompound nbt = FluidSolidifierEntity.this.setupSpecialNBTMessage("SET_RESULT_TYPE");
                nbt.func_74768_a("result_type", ((FluidSolidifierEntity)FluidSolidifierEntity.this).resultType.stateIndex);
                TeslaCoreLib.network.sendToServer((IMessage)new SimpleNBTMessage((TileEntity)FluidSolidifierEntity.this, nbt));
            }

            public void drawForegroundTopLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
                if (!BasicContainerGuiPiece.isInside((BasicTeslaGuiContainer)container, (IGuiContainerPiece)this, (int)mouseX, (int)mouseY)) {
                    return;
                }
                ArrayList lines = Lists.newArrayList();
                FluidSolidifierResult result = FluidSolidifierEntity.this.resultType;
                lines.add("Result: " + result.resultStack.func_82833_r());
                lines.add("Water: " + result.waterMbConsumed + " mb (min: " + result.waterMbMin + " mb)");
                lines.add("Lava: " + result.lavaMbConsumed + " mb (min: " + result.lavaMbMin + " mb)");
                lines.add("Time: " + (float)result.ticksRequired / 20.0f + " s (~ " + (long)result.ticksRequired * FluidSolidifierEntity.this.getWorkEnergyTick() + " T)");
                container.drawTooltip((List)lines, mouseX - guiX, mouseY - guiY);
            }
        });
        return pieces;
    }

    @Override
    public float getLeftTankPercent() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.waterTank.getFluidAmount() / (float)this.waterTank.getCapacity()));
    }

    @Override
    public float getRightTankPercent() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.lavaTank.getFluidAmount() / (float)this.lavaTank.getCapacity()));
    }

    @Override
    public Fluid getLeftTankFluid() {
        FluidStack stack = this.waterTank.getFluid();
        return stack == null ? null : stack.getFluid();
    }

    @Override
    public Fluid getRightTankFluid() {
        FluidStack stack = this.lavaTank.getFluid();
        return stack == null ? null : stack.getFluid();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("result_type")) {
            this.resultType = FluidSolidifierResult.fromStateIndex(compound.func_74762_e("result_type"));
        }
        if (compound.func_74764_b("work_result")) {
            this.lastWorkResult = FluidSolidifierResult.fromStateIndex(compound.func_74762_e("work_result"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("result_type", this.resultType.stateIndex);
        if (this.lastWorkResult != null) {
            compound.func_74768_a("work_result", this.lastWorkResult.stateIndex);
        }
        return compound;
    }

    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        if (messageType != null && messageType.equals("SET_RESULT_TYPE")) {
            this.resultType = FluidSolidifierResult.fromStateIndex(compound.func_74762_e("result_type"));
            this.func_70296_d();
        }
        return super.processClientMessage(messageType, compound);
    }

    protected int getEnergyForWork() {
        this.lastWorkResult = this.resultType;
        return this.lastWorkResult.ticksRequired * this.getEnergyForWorkRate();
    }

    protected float performWork() {
        boolean hasWater;
        if (this.lastWorkResult == null) {
            return 0.0f;
        }
        boolean bl = hasWater = this.waterTank.getFluidAmount() >= this.lastWorkResult.waterMbMin;
        if (hasWater) {
            boolean hasLava;
            boolean bl2 = hasLava = this.lavaTank.getFluidAmount() >= this.lastWorkResult.lavaMbMin;
            if (hasLava) {
                FluidStack water;
                boolean waterRequired = this.lastWorkResult.waterMbConsumed > 0;
                FluidStack fluidStack = water = waterRequired ? this.waterTank.drain(this.lastWorkResult.waterMbConsumed, false) : null;
                if (!waterRequired || water != null && water.amount == this.lastWorkResult.waterMbConsumed) {
                    ItemStack remaining;
                    FluidStack lava;
                    boolean lavaRequired = this.lastWorkResult.lavaMbConsumed > 0;
                    FluidStack fluidStack2 = lava = lavaRequired ? this.lavaTank.drain(this.lastWorkResult.lavaMbConsumed, false) : null;
                    if ((!lavaRequired || lava != null && lava.amount == this.lastWorkResult.lavaMbConsumed) && ItemStackUtil.isEmpty((ItemStack)(remaining = ItemHandlerHelper.insertItem((IItemHandler)this.outputs, (ItemStack)this.lastWorkResult.resultStack.func_77946_l(), (boolean)false)))) {
                        if (waterRequired) {
                            this.waterTank.drain(this.lastWorkResult.waterMbConsumed, true);
                        }
                        if (lavaRequired) {
                            this.lavaTank.drain(this.lastWorkResult.lavaMbConsumed, true);
                        }
                        this.lastWorkResult = null;
                        return 1.0f;
                    }
                }
            }
        }
        return 0.0f;
    }
}

