/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.gui.GeneratorBurnPiece;
import net.ndrei.teslapoweredthingies.gui.IWorkItemProvider;
import net.ndrei.teslapoweredthingies.gui.ItemStackPiece;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipes;

public class IncineratorEntity
extends ElectricGenerator
implements IWorkItemProvider {
    private ItemStackHandler inputs;
    private ItemStackHandler outputs;
    private ItemStackHandler currentItem;

    public IncineratorEntity() {
        super(IncineratorEntity.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        this.inputs = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                IncineratorEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inputs, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(61, 43, 18, 18)){

            public boolean canExtractItem(int slot) {
                return false;
            }

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (stack == null || stack.func_190926_b()) {
                    return false;
                }
                return IncineratorRecipes.isFuel(stack);
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 1, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.GREEN));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.inputs, "inv_inputs");
        this.outputs = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                IncineratorEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.outputs, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(133, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                for (int y = 0; y < 3; ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, box.getLeft() + 1, box.getTop() + 1 + y * 18));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 3, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.PURPLE));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.outputs, "inv_outputs");
        this.currentItem = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                IncineratorEntity.this.func_70296_d();
            }
        };
        super.addInventoryToStorage(this.currentItem, "inv_current");
    }

    protected long consumeFuel() {
        long power;
        ItemStack stack;
        if (this.currentItem.getStackInSlot(0).func_190926_b() && !(stack = this.inputs.extractItem(0, 1, true)).func_190926_b() && (power = IncineratorRecipes.getPower(stack)) > 0L && !(stack = this.inputs.extractItem(0, 1, false)).func_190926_b()) {
            this.currentItem.setStackInSlot(0, stack);
            return power;
        }
        return 0L;
    }

    protected void fuelConsumed() {
        SecondaryOutput[] secondary;
        ItemStack stack = this.currentItem.getStackInSlot(0);
        if (!ItemStackUtil.isEmpty((ItemStack)stack) && (secondary = IncineratorRecipes.getSecondaryOutputs(stack.func_77973_b())) != null && secondary.length > 0) {
            for (SecondaryOutput so : secondary) {
                ItemStack thing;
                float chance = this.func_145831_w().field_73012_v.nextFloat();
                if (!(chance <= so.chance) || ItemStackUtil.isEmpty((ItemStack)(thing = so.stack))) continue;
                if (!ItemStackUtil.isEmpty((ItemStack)(thing = ItemHandlerHelper.insertItem((IItemHandler)this.outputs, (ItemStack)thing.func_77946_l(), (boolean)false)))) {
                    BlockPos spawnPos = this.field_174879_c.func_177972_a(super.getFacing());
                    this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), thing));
                }
                super.forceSync();
            }
        }
        this.currentItem.setStackInSlot(0, ItemStack.field_190927_a);
    }

    protected long getEnergyOutputRate() {
        return 40L;
    }

    protected long getEnergyFillRate() {
        return 40L;
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(79, 41, 54, 22, TeslaThingiesMod.MACHINES_TEXTURES, 24, 4));
        pieces.add(new GeneratorBurnPiece(99, 64, this));
        pieces.add(new ItemStackPiece(95, 41, 22, 22, this){

            public void drawForegroundTopLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                List<String> lines = GeneratorBurnPiece.getTooltipLines(IncineratorEntity.this);
                if (lines != null && lines.size() > 0) {
                    container.drawTooltip(lines, mouseX - guiX, mouseY - guiY);
                }
            }
        });
        return pieces;
    }

    @Override
    public ItemStack getWorkItem() {
        return this.currentItem == null ? ItemStack.field_190927_a : this.currentItem.getStackInSlot(0);
    }
}

