/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines;

import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.FluidStorage;
import net.ndrei.teslacorelib.tileentities.ElectricMachine;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.gui.IWorkItemProvider;
import net.ndrei.teslapoweredthingies.gui.ItemStackPiece;
import net.ndrei.teslapoweredthingies.machines.itemliquefier.LiquefierRecipe;
import net.ndrei.teslapoweredthingies.machines.itemliquefier.LiquefierRecipes;

public class ItemLiquefierEntity
extends ElectricMachine
implements IWorkItemProvider {
    private IFluidTank lavaTank;
    private ItemStackHandler inputs;
    private ItemStackHandler fluidOutputs;
    private LiquefierRecipe currentRecipe = null;

    public ItemLiquefierEntity() {
        super(ItemLiquefierEntity.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        super.ensureFluidItems();
        this.lavaTank = super.addFluidTank(FluidRegistry.LAVA, 5000, EnumDyeColor.RED, "Lava Tank", new BoundingRectangle(133, 25, 18, 54));
        this.inputs = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                ItemLiquefierEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inputs, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(61, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return !ItemStackUtil.isEmpty((ItemStack)stack) && LiquefierRecipes.getRecipe(stack.func_77973_b()) != null;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                for (int y = 0; y < 3; ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, box.getLeft() + 1, box.getTop() + 1 + y * 18));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 3, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.PURPLE));
                return pieces;
            }
        });
        super.addInventoryToStorage(this.inputs, "inv_inputs");
        BoundingRectangle box = new BoundingRectangle(151, 25, 18, 54);
        this.fluidOutputs = new ItemStackHandler(2){

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : super.getSlotLimit(slot);
            }

            protected void onContentsChanged(int slot) {
                ItemLiquefierEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.fluidOutputs, EnumDyeColor.SILVER, "Fluid Output", box){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return slot == 0 && ItemLiquefierEntity.this.isValidFluidContainer(stack);
            }

            public boolean canExtractItem(int slot) {
                return slot != 0;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 1, box.getLeft() + 1, box.getTop() + 1 + 36));
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                if (box != null) {
                    pieces.add(new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), box.getWidth(), box.getHeight(), TeslaThingiesMod.MACHINES_TEXTURES, 98, 36));
                }
                return pieces;
            }
        });
        super.addInventoryToStorage(this.fluidOutputs, "inv_fluid_outputs");
    }

    private boolean isValidFluidContainer(ItemStack stack) {
        if (!ItemStackUtil.isEmpty((ItemStack)stack)) {
            IFluidTankProperties[] tanks;
            IFluidHandlerItem handler;
            Item item = stack.func_77973_b();
            if (item == Items.field_151069_bo || item == Items.field_151133_ar) {
                return true;
            }
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (tanks = handler.getTankProperties()) != null && tanks.length > 0) {
                for (IFluidTankProperties tank : tanks) {
                    FluidStack content;
                    if (!tank.canFill() || (content = tank.getContents()) != null && (content.amount >= tank.getCapacity() || content.getFluid() != FluidRegistry.LAVA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(79, 41, 54, 22, TeslaThingiesMod.MACHINES_TEXTURES, 24, 4));
        pieces.add(new BasicRenderedGuiPiece(99, 64, 14, 14, TeslaThingiesMod.MACHINES_TEXTURES, 44, 27));
        pieces.add(new ItemStackPiece(96, 42, 20, 20, this));
        return pieces;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentRecipe = compound.func_74764_b("currentRecipe") ? LiquefierRecipe.deserializeNBT(compound.func_74775_l("currentRecipe")) : null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.currentRecipe != null) {
            compound.func_74782_a("currentRecipe", (NBTBase)this.currentRecipe.serializeNBT());
        }
        return compound;
    }

    @Override
    public ItemStack getWorkItem() {
        if (this.currentRecipe != null) {
            return new ItemStack(this.currentRecipe.input, this.currentRecipe.inputStackSize);
        }
        return ItemStackUtil.getEmptyStack();
    }

    protected int getEnergyForWork() {
        return 6000;
    }

    protected float performWork() {
        FluidStack fluid;
        float result = 0.0f;
        if (this.currentRecipe != null && this.lavaTank.fill(fluid = new FluidStack(this.currentRecipe.output, this.currentRecipe.outputQuantity), false) == this.currentRecipe.outputQuantity) {
            this.lavaTank.fill(fluid, true);
            this.currentRecipe = null;
            result = 1.0f;
        }
        return result;
    }

    protected void processImmediateInventories() {
        super.processImmediateInventories();
        ItemStack stack = this.fluidOutputs.getStackInSlot(0);
        int maxDrain = this.lavaTank.getFluidAmount();
        if (!ItemStackUtil.isEmpty((ItemStack)stack) && maxDrain > 0 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            int toFill = Math.max(maxDrain, 1000);
            FluidStorage dummy = new FluidStorage();
            dummy.addTank(this.lavaTank);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)dummy, (int)toFill, null, (boolean)true);
            if (result.isSuccess()) {
                stack = result.getResult();
                this.fluidOutputs.setStackInSlot(0, stack);
            }
            if (!ItemStackUtil.isEmpty((ItemStack)stack) && !this.isEmptyFluidContainer(stack)) {
                this.fluidOutputs.setStackInSlot(0, this.fluidOutputs.insertItem(1, stack, false));
            }
        }
        if (this.currentRecipe == null) {
            for (ItemStack input : ItemStackUtil.getCombinedInventory((IItemHandler)this.inputs)) {
                FluidStack fluid;
                LiquefierRecipe recipe = LiquefierRecipes.getRecipe(input.func_77973_b());
                if (recipe == null || recipe.inputStackSize > ItemStackUtil.getSize((ItemStack)input) || this.lavaTank.fill(fluid = new FluidStack(recipe.output, recipe.outputQuantity), false) != recipe.outputQuantity) continue;
                ItemStackUtil.extractFromCombinedInventory((IItemHandler)this.inputs, (ItemStack)input, (int)recipe.inputStackSize);
                this.currentRecipe = recipe;
                break;
            }
        }
    }

    private boolean isEmptyFluidContainer(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid == null || fluid.amount == 0;
    }
}

