/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.fluidburner;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolant;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolantRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuel;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuelRecipe;

public final class FluidBurnerRecipes {
    private static List<FluidBurnerCoolantRecipe> coolantRecipes;
    private static List<FluidBurnerFuelRecipe> fuelRecipes;

    public static void registerRecipes() {
        coolantRecipes = Lists.newArrayList();
        fuelRecipes = Lists.newArrayList();
        coolantRecipes.add(new FluidBurnerCoolantRecipe(FluidRegistry.WATER, 100, 1.2f));
        fuelRecipes.add(new FluidBurnerFuelRecipe(FluidRegistry.LAVA, 100, 600));
    }

    public static boolean isCoolant(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.WATER;
    }

    public static boolean isFuel(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.LAVA;
    }

    public static FluidBurnerCoolant drainCoolant(IFluidTank tank, boolean doDrain) {
        FluidStack existing = tank.getFluid();
        if (existing != null && existing.amount > 0) {
            for (FluidBurnerCoolantRecipe recipe : coolantRecipes) {
                if (!recipe.fluid.equals(existing.getFluid()) || recipe.amount > existing.amount) continue;
                return new FluidBurnerCoolant(recipe, tank.drain(recipe.amount, doDrain));
            }
        }
        return null;
    }

    public static FluidBurnerFuel drainFuel(IFluidTank tank, boolean doDrain) {
        FluidStack existing = tank.getFluid();
        if (existing != null && existing.amount > 0) {
            for (FluidBurnerFuelRecipe recipe : fuelRecipes) {
                if (!recipe.fluid.equals(existing.getFluid()) || recipe.amount > existing.amount) continue;
                return new FluidBurnerFuel(recipe, tank.drain(recipe.amount, doDrain));
            }
        }
        return null;
    }

    public static List<FluidBurnerFuelRecipe> getFuels() {
        return fuelRecipes;
    }

    public static List<FluidBurnerCoolantRecipe> getCoolants() {
        return coolantRecipes;
    }
}

