/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.incinerator;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.ndrei.teslapoweredthingies.common.ItemsRegistry;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipe;

public class IncineratorRecipes {
    private static final long VANILLA_BURN_TO_POWER_RATE = 10L;
    private static List<IncineratorRecipe> recipes;

    public static void registerRecipes() {
        recipes = Lists.newArrayList();
        IncineratorRecipes.registerVanillaRecipe(Items.field_151044_h, new SecondaryOutput(0.02f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150402_ci, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150344_f, new SecondaryOutput(0.1f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150364_r, new SecondaryOutput(0.15f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150363_s, new SecondaryOutput(0.15f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150325_L, new SecondaryOutput(0.01f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_150345_g, new SecondaryOutput(0.15f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180405_aT, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180404_aQ, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180403_aR, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180407_aO, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180408_aP, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180406_aS, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180387_bt, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180392_bq, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180386_br, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180390_bo, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180391_bp, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Blocks.field_180385_bs, new SecondaryOutput(0.05f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151055_y, new SecondaryOutput(0.01f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151053_p, new SecondaryOutput(0.03f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151017_I, new SecondaryOutput(0.03f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151039_o, new SecondaryOutput(0.03f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151038_n, new SecondaryOutput(0.03f, (Item)ItemsRegistry.ASH));
        IncineratorRecipes.registerVanillaRecipe(Items.field_151041_m, new SecondaryOutput(0.03f, (Item)ItemsRegistry.ASH));
    }

    private static void registerVanillaRecipe(Block block, SecondaryOutput secondary) {
        IncineratorRecipes.registerVanillaRecipe(Item.func_150898_a((Block)block), secondary);
    }

    private static void registerVanillaRecipe(Item item, SecondaryOutput secondary) {
        IncineratorRecipes.registerVanillaRecipe(new ItemStack(item), secondary);
    }

    private static void registerVanillaRecipe(ItemStack stack, SecondaryOutput secondary) {
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burnTime > 0) {
            long power = (long)burnTime * 10L;
            recipes.add(new IncineratorRecipe(stack, power, secondary));
        }
    }

    public static boolean isFuel(ItemStack input) {
        if (input.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        if (TileEntityFurnace.func_145954_b((ItemStack)new ItemStack(input.func_77973_b()))) {
            return true;
        }
        if (recipes != null) {
            for (IncineratorRecipe recipe : recipes) {
                if (!recipe.input.func_185136_b(input)) continue;
                return true;
            }
        }
        return false;
    }

    public static long getPower(ItemStack input) {
        if (recipes != null) {
            for (IncineratorRecipe recipe : recipes) {
                if (!recipe.input.func_185136_b(input)) continue;
                return recipe.power;
            }
        }
        return IncineratorRecipes.isFuel(input) ? 10L * (long)TileEntityFurnace.func_145952_a((ItemStack)input) : 0L;
    }

    public static SecondaryOutput[] getSecondaryOutputs(Item input) {
        if (recipes != null) {
            ItemStack testStack = new ItemStack(input);
            for (IncineratorRecipe recipe : recipes) {
                if (!recipe.input.func_185136_b(testStack)) continue;
                return recipe.secondaryOutputs;
            }
        }
        return null;
    }

    public static List<IncineratorRecipe> getRecipes() {
        return recipes;
    }
}

