/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.itemliquefier;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;

public class LiquefierRecipe {
    public final Item input;
    public final Fluid output;
    public final int inputStackSize;
    public final int outputQuantity;

    public LiquefierRecipe(Block input, Fluid output, int outputQuantity) {
        this(input, 1, output, outputQuantity);
    }

    public LiquefierRecipe(Block input, int inputStackSize, Fluid output, int outputQuantity) {
        this(Item.func_150898_a((Block)input), inputStackSize, output, outputQuantity);
    }

    public LiquefierRecipe(Item input, Fluid output, int outputQuantity) {
        this(input, 1, output, outputQuantity);
    }

    public LiquefierRecipe(Item input, int inputStackSize, Fluid output, int outputQuantity) {
        this.input = input;
        this.inputStackSize = inputStackSize;
        this.output = output;
        this.outputQuantity = outputQuantity;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)new ItemStack(this.input, this.inputStackSize).serializeNBT());
        nbt.func_74782_a("output", (NBTBase)new FluidStack(this.output, this.outputQuantity).writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static LiquefierRecipe deserializeNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("input", 10) || !nbt.func_150297_b("output", 10)) {
            TeslaThingiesMod.logger.error("Incorrect NBT storage for Liquefier Recipe.", new Object[]{nbt});
            return null;
        }
        ItemStack input = new ItemStack(nbt.func_74775_l("input"));
        FluidStack output = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("output"));
        return new LiquefierRecipe(input.func_77973_b(), ItemStackUtil.getSize((ItemStack)input), output.getFluid(), output.amount);
    }
}

