/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.blocks;

import java.util.Arrays;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.ndrei.teslacorelib.annotations.AutoRegisterBlock;
import net.ndrei.teslacorelib.entities.TeslaLightningBolt;
import net.ndrei.teslacorelib.entities.TeslaLightningStruckEvent;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslacorelib.utils.BlockPosUtils;
import net.ndrei.teslapoweredthingies.items.TeslaPlantSeeds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterBlock(configFlags={})
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J0\u0010\u0019\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\tH\u0002J&\u0010\"\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J6\u0010%\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010 \u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\tH\u0016J$\u0010*\u001a\u00020(2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010+\u001a\u00020,2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010)\u001a\u00020\tH\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\tH\u0016J(\u00100\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0007J\u0012\u00104\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u00010\u001bH\u0016J\u001a\u00106\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u00010\u001bH\u0016J(\u00107\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lnet/ndrei/teslapoweredthingies/blocks/TeslaPlantBlock;", "Lnet/minecraft/block/BlockBush;", "Lnet/minecraft/block/IGrowable;", "()V", "AGE", "Lnet/minecraft/block/properties/PropertyInteger;", "getAGE", "()Lnet/minecraft/block/properties/PropertyInteger;", "MAX_AGE", "", "TESLA_PLANT_AABB", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "[Lnet/minecraft/util/math/AxisAlignedBB;", "_age", "canGrow", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "isClient", "canSustainBush", "canUseBonemeal", "rand", "Ljava/util/Random;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "doGrow", "", "world", "probability", "getBoundingBox", "source", "Lnet/minecraft/world/IBlockAccess;", "getDrops", "drops", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "fortune", "getItem", "getItemDropped", "Lnet/ndrei/teslapoweredthingies/items/TeslaPlantSeeds;", "getMetaFromState", "getStateFromMeta", "meta", "grow", "onEntityEvent", "ev", "Lnet/ndrei/teslacorelib/entities/TeslaLightningStruckEvent;", "quantityDropped", "random", "quantityDroppedWithBonus", "updateTick", "teslathingies_main"})
public final class TeslaPlantBlock
extends BlockBush
implements IGrowable {
    private static PropertyInteger _age;
    private static final int MAX_AGE = 2;
    private static final AxisAlignedBB[] TESLA_PLANT_AABB;
    public static final TeslaPlantBlock INSTANCE;

    @NotNull
    public final PropertyInteger getAGE() {
        if (_age == null) {
            _age = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
        }
        PropertyInteger propertyInteger = _age;
        if (propertyInteger == null) {
            Intrinsics.throwNpe();
        }
        return propertyInteger;
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@Nullable IBlockState state, @Nullable IBlockAccess source, @Nullable BlockPos pos) {
        IBlockState iBlockState = state;
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        Comparable comparable = iBlockState.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        return TESLA_PLANT_AABB[(Integer)comparable];
    }

    protected boolean func_185514_i(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        this.func_176474_b(worldIn, rand, pos, state);
        if (worldIn.func_72912_H().func_76061_m() && rand.nextInt(2) == 1) {
            worldIn.func_72942_c((Entity)new TeslaLightningBolt(worldIn, pos));
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private final void doGrow(World world, BlockPos pos, IBlockState state, Random rand, int probability) {
        Comparable comparable = state.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int i = (Integer)comparable;
        if (i < 2 && probability > 0 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt(probability) == 0 ? 1 : 0) != 0)) {
            IBlockState updatedState = state.func_177226_a((IProperty)this.getAGE(), (Comparable)Integer.valueOf(i + 1));
            world.func_180501_a(pos, updatedState, 2);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
        }
    }

    public boolean func_180670_a(@Nullable World worldIn, @Nullable Random rand, @Nullable BlockPos pos, @Nullable IBlockState state) {
        return false;
    }

    public void func_176474_b(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Comparable comparable = state.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int i = (Integer)comparable;
        int probability = (i + 1) * (worldIn.func_72912_H().func_76061_m() ? 3 : (worldIn.func_72912_H().func_76059_o() ? 20 : 0));
        this.doGrow(worldIn, pos, state, rand, probability);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (isClient) return false;
        Comparable comparable = state.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        if ((Integer)comparable >= 2) return false;
        return true;
    }

    @SubscribeEvent
    public final void onEntityEvent(@NotNull TeslaLightningStruckEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        if (ev.getEntity() instanceof EntityLightningBolt && ev.getEntity().func_180425_c() != null && ev.getEntity().func_130014_f_() != null) {
            BlockPos pos;
            World world = ev.getEntity().func_130014_f_();
            IBlockState centerState = world.func_180495_p(pos = ev.getEntity().func_180425_c());
            if (Intrinsics.areEqual((Object)centerState.func_177230_c(), (Object)((Object)INSTANCE))) {
                World world2 = world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                BlockPos blockPos = pos;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                IBlockState iBlockState = centerState;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"centerState");
                Random random = world.field_73012_v;
                Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"world.rand");
                this.doGrow(world2, blockPos, iBlockState, random, 1);
            }
            BlockPos blockPos = ev.getEntity().func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"ev.entity.position");
            BlockCube cube = BlockPosUtils.INSTANCE.getCube(blockPos, null, 1, 1);
            Iterable $receiver$iv = (Iterable)cube;
            for (Object element$iv : $receiver$iv) {
                BlockPos it = (BlockPos)element$iv;
                IBlockState state = world.func_180495_p(it);
                if (!Intrinsics.areEqual((Object)state.func_177230_c(), (Object)((Object)INSTANCE))) continue;
                World world3 = world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
                BlockPos blockPos2 = pos;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
                IBlockState iBlockState = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                Random random = world.field_73012_v;
                Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"world.rand");
                INSTANCE.doGrow(world3, blockPos2, iBlockState, random, 3);
            }
        }
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)this.getAGE(), (Comparable)Integer.valueOf(meta));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"this.defaultState.withPr\u2026 Integer.valueOf(meta)!!)");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Comparable comparable = state.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)comparable;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer blockStateContainer;
        Object[] objectArray = new IProperty[]{(IProperty)this.getAGE()};
        Block block = (Block)this;
        BlockStateContainer blockStateContainer2 = blockStateContainer;
        BlockStateContainer blockStateContainer3 = blockStateContainer;
        Object[] objectArray2 = objectArray;
        IProperty[] iPropertyArray = (IProperty[])objectArray2;
        blockStateContainer2(block, Arrays.copyOf(iPropertyArray, iPropertyArray.length));
        return blockStateContainer3;
    }

    @NotNull
    public TeslaPlantSeeds getItemDropped(@Nullable IBlockState state, @Nullable Random rand, int fortune) {
        return TeslaPlantSeeds.INSTANCE;
    }

    @NotNull
    public ItemStack func_185473_a(@Nullable World worldIn, @Nullable BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return new ItemStack((Item)TeslaPlantSeeds.INSTANCE);
    }

    public int func_149745_a(@Nullable Random random) {
        return 1;
    }

    public int func_149679_a(int fortune, @Nullable Random random) {
        int n;
        int n2 = this.func_149745_a(random);
        if (fortune > 0) {
            Random random2 = random;
            n = random2 != null ? random2.nextInt(fortune) : 0;
        } else {
            n = 0;
        }
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        int n;
        Intrinsics.checkParameterIsNotNull(drops, (String)"drops");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int count = 1;
        Comparable comparable = state.func_177229_b((IProperty)this.getAGE());
        if (comparable == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        if ((Integer)comparable >= 2) {
            count = 2 + (fortune > 0 ? rand.nextInt(fortune + 1) : 0);
        }
        IntRange intRange = RangesKt.until((int)0, (int)count);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                drops.add((Object)new ItemStack((Item)TeslaPlantSeeds.INSTANCE));
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private TeslaPlantBlock() {
        super(Material.field_151585_k, MapColor.field_151679_y);
        void var1_1;
        INSTANCE = this;
        Object[] elements$iv = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)};
        TESLA_PLANT_AABB = (AxisAlignedBB[])var1_1;
        this.setRegistryName("teslathingies", "tesla_plant");
        this.func_149663_c("teslathingies" + ".tesla_plant");
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAGE(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        new TeslaPlantBlock();
    }
}

