/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.gui;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import net.ndrei.teslapoweredthingies.client.Textures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J<\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J4\u0010\u0012\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/ndrei/teslapoweredthingies/gui/GeneratorBurnPiece;", "Lnet/ndrei/teslacorelib/gui/BasicContainerGuiPiece;", "left", "", "top", "te", "Lnet/ndrei/teslacorelib/tileentities/ElectricGenerator;", "(IILnet/ndrei/teslacorelib/tileentities/ElectricGenerator;)V", "drawBackgroundLayer", "", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "guiX", "guiY", "partialTicks", "", "mouseX", "mouseY", "drawForegroundTopLayer", "Companion", "teslathingies_main"})
public final class GeneratorBurnPiece
extends BasicContainerGuiPiece {
    private final ElectricGenerator te;
    public static final Companion Companion = new Companion(null);

    public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        Textures.MACHINES_TEXTURES.bind(container);
        container.drawTexturedRect(this.getLeft(), this.getTop(), 44, 27, 14, 14);
        long generated = this.te.getGeneratedPowerCapacity();
        long stored = this.te.getGeneratedPowerStored();
        int percent = Math.round((float)14 * Math.min(Math.max((float)(generated - stored) / (float)generated, 0.0f), 1.0f));
        if (percent > 0) {
            container.drawTexturedRect(this.getLeft(), this.getTop() + percent, 8, 27 + percent, 14, 14 - percent);
        }
    }

    public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        if (!this.isInside(container, mouseX, mouseY)) {
            return;
        }
        List<String> lines = Companion.getTooltipLines(this.te);
        if (lines != null && lines.size() > 0) {
            container.drawTooltip(lines, mouseX - guiX, mouseY - guiY);
        }
    }

    public GeneratorBurnPiece(int left, int top, @NotNull ElectricGenerator te) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        super(left, top, 14, 14);
        this.te = te;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/ndrei/teslapoweredthingies/gui/GeneratorBurnPiece$Companion;", "", "()V", "getTooltipLines", "", "", "entity", "Lnet/ndrei/teslacorelib/tileentities/ElectricGenerator;", "teslathingies_main"})
    public static final class Companion {
        @Nullable
        public final List<String> getTooltipLines(@NotNull ElectricGenerator entity) {
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            ArrayList lines = Lists.newArrayList();
            long generated = entity.getGeneratedPowerCapacity();
            if (generated > (long)0 && entity.getGeneratedPowerStored() > (long)0) {
                lines.add(ChatFormatting.GRAY.toString() + "Total for fuel: " + ChatFormatting.AQUA + generated);
                lines.add(ChatFormatting.GRAY.toString() + "Generating " + ChatFormatting.AQUA + entity.getGeneratedPowerReleaseRate() + ChatFormatting.GRAY + " / tick");
                double ticks = (double)entity.getGeneratedPowerStored() / (double)entity.getGeneratedPowerReleaseRate() / 20.0;
                lines.add(ChatFormatting.GRAY.toString() + "~ " + String.format("%.2f", ticks) + "s remaining");
            }
            return lines;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

