/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.ndrei.teslacorelib.annotations.AutoRegisterItem;
import net.ndrei.teslacorelib.items.BaseAddon;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.common.ILiquidXPCollector;
import net.ndrei.teslapoweredthingies.fluids.LiquidXPFluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterItem(configFlags={})
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lnet/ndrei/teslapoweredthingies/items/LiquidXPCollectorItem;", "Lnet/ndrei/teslacorelib/items/BaseAddon;", "()V", "MAX_CAPACITY", "", "workEnergyMultiplier", "", "getWorkEnergyMultiplier", "()F", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "canBeAddedTo", "", "machine", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "getItemStackLimit", "getStoredXP", "initCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onAdded", "addon", "onRemoved", "setStoredXP", "storedXp", "LiquidXPHolderCapability", "teslathingies_main"})
public final class LiquidXPCollectorItem
extends BaseAddon {
    public static final int MAX_CAPACITY = 1000;
    public static final LiquidXPCollectorItem INSTANCE;

    public boolean canBeAddedTo(@NotNull SidedTileEntity machine) {
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        return machine instanceof ILiquidXPCollector && !((ILiquidXPCollector)machine).hasXPCollector();
    }

    public float getWorkEnergyMultiplier() {
        return 1.25f;
    }

    public void onAdded(@NotNull ItemStack addon, @NotNull SidedTileEntity machine) {
        Intrinsics.checkParameterIsNotNull((Object)addon, (String)"addon");
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        super.onAdded(addon, machine);
        if (machine instanceof ILiquidXPCollector) {
            ((ILiquidXPCollector)machine).onLiquidXPAddonAdded(addon);
        }
    }

    public void onRemoved(@NotNull ItemStack addon, @NotNull SidedTileEntity machine) {
        Intrinsics.checkParameterIsNotNull((Object)addon, (String)"addon");
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        super.onRemoved(addon, machine);
        if (machine instanceof ILiquidXPCollector) {
            ((ILiquidXPCollector)machine).onLiquidXPAddonRemoved(addon);
        }
    }

    public void func_77624_a(@Nullable ItemStack stack, @Nullable World worldIn, @Nullable List<String> tooltip, @Nullable ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack != null && tooltip != null) {
            NBTTagCompound nbt;
            NBTTagCompound nBTTagCompound = nbt = stack.func_190926_b() ? null : stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b("StoredLiquidXP", 3)) {
                tooltip.add(ChatFormatting.DARK_GREEN.toString() + "Stored XP: " + ChatFormatting.GREEN + nbt.func_74762_e("StoredLiquidXP"));
            } else {
                tooltip.add(ChatFormatting.DARK_GRAY.toString() + "No XP Stored");
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nullable ItemStack stack, @Nullable NBTTagCompound nbt) {
        return stack != null ? (ICapabilityProvider)new LiquidXPHolderCapability(stack) : null;
    }

    public int getItemStackLimit(@Nullable ItemStack stack) {
        int xp = stack != null ? INSTANCE.getStoredXP(stack) : 0;
        return xp == 0 ? 16 : 4;
    }

    public final int getStoredXP(@NotNull ItemStack stack) {
        NBTTagCompound nbt;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.func_190926_b() && stack.func_77973_b() == INSTANCE && (nbt = stack.func_77978_p()) != null && nbt.func_150297_b("StoredLiquidXP", 3)) {
            return nbt.func_74762_e("StoredLiquidXP");
        }
        return 0;
    }

    public final void setStoredXP(@NotNull ItemStack stack, int storedXp) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.func_190926_b() && stack.func_77973_b() == INSTANCE) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                stack.func_77982_d(new NBTTagCompound());
                nbt = stack.func_77978_p();
            }
            if (storedXp > 0) {
                NBTTagCompound nBTTagCompound = nbt;
                if (nBTTagCompound == null) {
                    Intrinsics.throwNpe();
                }
                nBTTagCompound.func_74768_a("StoredLiquidXP", storedXp);
            } else {
                NBTTagCompound nBTTagCompound = nbt;
                if (nBTTagCompound == null) {
                    Intrinsics.throwNpe();
                }
                if (nBTTagCompound.func_150297_b("StoredLiquidXP", 3)) {
                    nbt.func_82580_o("StoredLiquidXP");
                }
            }
        }
    }

    private LiquidXPCollectorItem() {
        super("teslathingies", TeslaThingiesMod.INSTANCE.getCreativeTab(), "liquidxp_collector");
        INSTANCE = this;
    }

    static {
        new LiquidXPCollectorItem();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J-\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/ndrei/teslapoweredthingies/items/LiquidXPCollectorItem$LiquidXPHolderCapability;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "Lnet/minecraftforge/fluids/capability/IFluidHandlerItem;", "stack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "", "doDrain", "", "resource", "fill", "doFill", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getContainer", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "hasCapability", "teslathingies_main"})
    private static final class LiquidXPHolderCapability
    implements ICapabilityProvider,
    IFluidHandlerItem {
        private final ItemStack stack;

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)capability.cast((Object)this);
            }
            return null;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public IFluidTankProperties[] getTankProperties() {
            void var1_1;
            Object[] elements$iv = new IFluidTankProperties[]{(IFluidTankProperties)new FluidTankProperties(new FluidStack((Fluid)LiquidXPFluid.INSTANCE, INSTANCE.getStoredXP(this.stack)), 1000, true, true)};
            return (IFluidTankProperties[])var1_1;
        }

        public int fill(@Nullable FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount == 0 || resource.getFluid() != LiquidXPFluid.INSTANCE) {
                return 0;
            }
            int existing = INSTANCE.getStoredXP(this.stack);
            int filled = Math.min(1000 - existing, resource.amount);
            if (doFill) {
                INSTANCE.setStoredXP(this.stack, existing + filled);
            }
            return filled;
        }

        @Nullable
        public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
            if (resource == null || resource.getFluid() != LiquidXPFluid.INSTANCE) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            int existing = INSTANCE.getStoredXP(this.stack);
            if (maxDrain == 0 || existing == 0) {
                return null;
            }
            int canDrain = Math.min(existing, maxDrain);
            if (doDrain) {
                INSTANCE.setStoredXP(this.stack, existing - canDrain);
            }
            return new FluidStack((Fluid)LiquidXPFluid.INSTANCE, canDrain);
        }

        public LiquidXPHolderCapability(@NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            this.stack = stack;
        }
    }
}

