/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FilteredFluidTank;
import net.ndrei.teslacorelib.inventory.FluidTank;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslacorelib.utils.BlockPosUtils;
import net.ndrei.teslapoweredthingies.common.ILiquidXPCollector;
import net.ndrei.teslapoweredthingies.fluids.LiquidXPFluid;
import net.ndrei.teslapoweredthingies.items.LiquidXPCollectorItem;
import net.ndrei.teslapoweredthingies.machines.ElectricFarmMachine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH$R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/BaseXPCollectingMachine;", "Lnet/ndrei/teslapoweredthingies/machines/ElectricFarmMachine;", "Lnet/ndrei/teslapoweredthingies/common/ILiquidXPCollector;", "typeId", "", "(I)V", "xpOrbLookupCube", "Lnet/ndrei/teslacorelib/utils/BlockCube;", "getXpOrbLookupCube", "()Lnet/ndrei/teslacorelib/utils/BlockCube;", "xpTank", "Lnet/minecraftforge/fluids/IFluidTank;", "xpTank$annotations", "()V", "getXpTank", "()Lnet/minecraftforge/fluids/IFluidTank;", "setXpTank", "(Lnet/minecraftforge/fluids/IFluidTank;)V", "getInputInventoryBounds", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "columns", "rows", "getOutputInventoryBounds", "hasXPCollector", "", "onLiquidXPAddonAdded", "", "stack", "Lnet/minecraft/item/ItemStack;", "onLiquidXPAddonRemoved", "performWork", "", "performWorkInternal", "teslathingies_main"})
public abstract class BaseXPCollectingMachine
extends ElectricFarmMachine
implements ILiquidXPCollector {
    @Nullable
    private IFluidTank xpTank;

    protected static /* synthetic */ void xpTank$annotations() {
    }

    @Nullable
    protected final IFluidTank getXpTank() {
        return this.xpTank;
    }

    protected final void setXpTank(@Nullable IFluidTank iFluidTank) {
        this.xpTank = iFluidTank;
    }

    @Override
    public boolean hasXPCollector() {
        return this.hasAddon(LiquidXPCollectorItem.class);
    }

    @Override
    public void onLiquidXPAddonAdded(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.xpTank != null) {
            IFluidTank iFluidTank = this.xpTank;
            if (iFluidTank == null) {
                Intrinsics.throwNpe();
            }
            super.removeFluidTank(EnumDyeColor.LIME, iFluidTank);
            this.xpTank = null;
        }
        IFluidTank iFluidTank = this.xpTank = (IFluidTank)new FilteredFluidTank((Fluid)LiquidXPFluid.INSTANCE, (IFluidTank)new FluidTank(this, 1000){
            final /* synthetic */ BaseXPCollectingMachine this$0;

            protected void onContentsChanged() {
                int amount = this.getFluidAmount();
                if (amount > 0) {
                    ItemStack addonStack = BaseXPCollectingMachine.access$getAddonStack(this.this$0, LiquidXPCollectorItem.class);
                    if (!addonStack.func_190926_b()) {
                        addonStack.func_77983_a("StoredLiquidXP", (NBTBase)new NBTTagInt(this.getFluidAmount()));
                    }
                } else {
                    NBTTagCompound nbt;
                    ItemStack addonStack = BaseXPCollectingMachine.access$getAddonStack(this.this$0, LiquidXPCollectorItem.class);
                    if (!addonStack.func_190926_b() && (nbt = addonStack.func_77978_p()) != null && nbt.func_150297_b("StoredLiquidXP", 3)) {
                        nbt.func_82580_o("StoredLiquidXP");
                    }
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
        if (iFluidTank == null) {
            Intrinsics.throwNpe();
        }
        super.addFluidTank(iFluidTank, EnumDyeColor.LIME, "Liquid XP", new BoundingRectangle(151, 25, 18, 54));
        int xp = LiquidXPCollectorItem.INSTANCE.getStoredXP(stack);
        if (xp > 0) {
            IFluidTank iFluidTank2 = this.xpTank;
            if (iFluidTank2 == null) {
                Intrinsics.throwNpe();
            }
            iFluidTank2.fill(new FluidStack((Fluid)LiquidXPFluid.INSTANCE, xp), true);
        }
        BasicTeslaGuiContainer.Companion.refreshParts(this.func_145831_w());
    }

    @Override
    public void onLiquidXPAddonRemoved(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.xpTank != null) {
            IFluidTank iFluidTank = this.xpTank;
            if (iFluidTank == null) {
                Intrinsics.throwNpe();
            }
            super.removeFluidTank(EnumDyeColor.LIME, iFluidTank);
            this.xpTank = null;
            BasicTeslaGuiContainer.Companion.refreshParts(this.func_145831_w());
        }
    }

    protected float performWork() {
        float result = this.performWorkInternal() / 1.25f;
        if ((double)result <= 0.800001 && super.hasAddon(LiquidXPCollectorItem.class) && this.xpTank != null) {
            boolean orbCollected = false;
            BlockCube blockCube = this.getXpOrbLookupCube();
            World world = this.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"this.getWorld()");
            for (EntityXPOrb orb : blockCube.findEntities(EntityXPOrb.class, world)) {
                IFluidTank iFluidTank = this.xpTank;
                if (iFluidTank == null) {
                    Intrinsics.throwNpe();
                }
                int n = iFluidTank.getCapacity();
                IFluidTank iFluidTank2 = this.xpTank;
                if (iFluidTank2 == null) {
                    Intrinsics.throwNpe();
                }
                if (n <= iFluidTank2.getFluidAmount()) break;
                IFluidTank iFluidTank3 = this.xpTank;
                if (iFluidTank3 == null) {
                    Intrinsics.throwNpe();
                }
                if (0 >= iFluidTank3.fill(new FluidStack((Fluid)LiquidXPFluid.INSTANCE, orb.func_70526_d()), true)) continue;
                this.func_145831_w().func_72900_e((Entity)orb);
                orbCollected = true;
            }
            if (orbCollected) {
                result += 0.2f;
            }
        }
        return Math.min(1.0f, result);
    }

    @NotNull
    protected BlockCube getXpOrbLookupCube() {
        BlockPos blockPos = this.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos()");
        return BlockPosUtils.INSTANCE.getCube(blockPos, super.getFacing().func_176734_d(), 4, 1);
    }

    protected abstract float performWorkInternal();

    @Override
    @NotNull
    protected BoundingRectangle getInputInventoryBounds(int columns, int rows) {
        BoundingRectangle area = super.getInputInventoryBounds(columns, rows);
        return new BoundingRectangle(area.getLeft() - 18, area.getTop(), area.getWidth(), area.getHeight());
    }

    @Override
    @NotNull
    protected BoundingRectangle getOutputInventoryBounds(int columns, int rows) {
        BoundingRectangle area = super.getOutputInventoryBounds(columns, rows);
        return new BoundingRectangle(area.getLeft() - 18, area.getTop(), area.getWidth(), area.getHeight());
    }

    public BaseXPCollectingMachine(int typeId) {
        super(typeId);
    }

    @NotNull
    public static final /* synthetic */ ItemStack access$getAddonStack(BaseXPCollectingMachine $this, @Nullable Class addonClass) {
        return $this.getAddonStack(addonClass);
    }
}

