/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.animalfarm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.ndrei.teslapoweredthingies.machines.animalfarm.IAnimalWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\bH\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/animalfarm/VanillaGenericAnimal;", "Lnet/ndrei/teslapoweredthingies/machines/animalfarm/IAnimalWrapper;", "animal", "Lnet/minecraft/entity/passive/EntityAnimal;", "(Lnet/minecraft/entity/passive/EntityAnimal;)V", "getAnimal", "()Lnet/minecraft/entity/passive/EntityAnimal;", "bowl", "Lnet/minecraft/item/ItemStack;", "breedable", "", "canBeBowled", "canBeMilked", "canBeShearedWith", "stack", "canMateWith", "wrapper", "getFoodNeededForMating", "", "isFood", "mate", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "milk", "shear", "", "fortune", "shearable", "Companion", "teslathingies_main"})
public class VanillaGenericAnimal
implements IAnimalWrapper {
    @NotNull
    private final EntityAnimal animal;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean breedable() {
        EntityAnimal animal = this.getAnimal();
        return !animal.func_70880_s() && !animal.func_70631_g_() && animal.func_70874_b() == 0;
    }

    @Override
    public boolean isFood(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.getAnimal().func_70877_b(stack);
    }

    @Override
    public boolean canMateWith(@NotNull IAnimalWrapper wrapper) {
        Intrinsics.checkParameterIsNotNull((Object)wrapper, (String)"wrapper");
        return this.breedable() && wrapper.breedable() && Intrinsics.areEqual(this.getAnimal().getClass(), wrapper.getAnimal().getClass());
    }

    @Override
    public int mate(@NotNull EntityPlayer player, @NotNull ItemStack stack, @NotNull IAnimalWrapper wrapper) {
        int consumedFood;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)wrapper, (String)"wrapper");
        int neededFood = 2 * this.getFoodNeededForMating(stack);
        if (stack.func_190916_E() < neededFood) {
            consumedFood = 0;
        } else if (!this.canMateWith(wrapper) || !this.isFood(stack)) {
            consumedFood = 0;
        } else {
            this.getAnimal().func_146082_f(player);
            wrapper.getAnimal().func_146082_f(player);
            consumedFood = neededFood;
        }
        return consumedFood;
    }

    protected int getFoodNeededForMating(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 1;
    }

    @Override
    public boolean shearable() {
        return !(this.getAnimal() instanceof EntityMooshroom) && this.getAnimal() instanceof IShearable;
    }

    @Override
    public boolean canBeShearedWith(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151097_aZ) {
            return false;
        }
        boolean isShearable = false;
        EntityAnimal animal = this.getAnimal();
        if (this.shearable() && animal instanceof IShearable) {
            IShearable shearable = (IShearable)animal;
            isShearable = shearable.isShearable(stack, (IBlockAccess)animal.func_130014_f_(), animal.func_180425_c());
        }
        return isShearable;
    }

    @Override
    @NotNull
    public List<ItemStack> shear(@NotNull ItemStack stack, int fortune) {
        IShearable shearable;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList<ItemStack>()");
        List result = arrayList;
        EntityAnimal animal = this.getAnimal();
        if (animal instanceof IShearable && (shearable = (IShearable)animal).isShearable(stack, (IBlockAccess)animal.func_130014_f_(), animal.func_180425_c())) {
            List list = shearable.onSheared(stack, (IBlockAccess)animal.func_130014_f_(), animal.func_180425_c(), fortune);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"shearable.onSheared(stac\u2026animal.position, fortune)");
            result = list;
        }
        return result;
    }

    @Override
    public boolean canBeMilked() {
        EntityAnimal animal = this.getAnimal();
        return animal instanceof EntityCow && !((EntityCow)animal).func_70631_g_();
    }

    @Override
    @NotNull
    public ItemStack milk() {
        ItemStack itemStack;
        if (this.canBeMilked()) {
            itemStack = new ItemStack(Items.field_151117_aB, 1);
        } else {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @Override
    public boolean canBeBowled() {
        EntityAnimal animal = this.getAnimal();
        return animal instanceof EntityMooshroom && !((EntityMooshroom)animal).func_70631_g_();
    }

    @Override
    @NotNull
    public ItemStack bowl() {
        ItemStack itemStack;
        if (this.canBeBowled()) {
            itemStack = new ItemStack(Items.field_151009_A, 1);
        } else {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @Override
    @NotNull
    public EntityAnimal getAnimal() {
        return this.animal;
    }

    public VanillaGenericAnimal(@NotNull EntityAnimal animal) {
        Intrinsics.checkParameterIsNotNull((Object)animal, (String)"animal");
        this.animal = animal;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/animalfarm/VanillaGenericAnimal$Companion;", "", "()V", "populateFoodItems", "", "food", "", "Lnet/minecraft/item/Item;", "teslathingies_main"})
    public static final class Companion {
        public final void populateFoodItems(@NotNull List<Item> food) {
            Intrinsics.checkParameterIsNotNull(food, (String)"food");
            Item item2 = Items.field_151015_O;
            Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"Items.WHEAT");
            food.add(item2);
            Item item3 = Items.field_151014_N;
            Intrinsics.checkExpressionValueIsNotNull((Object)item3, (String)"Items.WHEAT_SEEDS");
            food.add(item3);
            Item item4 = Items.field_185163_cU;
            Intrinsics.checkExpressionValueIsNotNull((Object)item4, (String)"Items.BEETROOT_SEEDS");
            food.add(item4);
            Item item5 = Items.field_151080_bb;
            Intrinsics.checkExpressionValueIsNotNull((Object)item5, (String)"Items.PUMPKIN_SEEDS");
            food.add(item5);
            Item item6 = Items.field_151081_bc;
            Intrinsics.checkExpressionValueIsNotNull((Object)item6, (String)"Items.MELON_SEEDS");
            food.add(item6);
            Item item7 = Items.field_151172_bF;
            Intrinsics.checkExpressionValueIsNotNull((Object)item7, (String)"Items.CARROT");
            food.add(item7);
            Item item8 = Items.field_151174_bG;
            Intrinsics.checkExpressionValueIsNotNull((Object)item8, (String)"Items.POTATO");
            food.add(item8);
            Item item9 = Items.field_185164_cV;
            Intrinsics.checkExpressionValueIsNotNull((Object)item9, (String)"Items.BEETROOT");
            food.add(item9);
            Item item10 = Items.field_151150_bK;
            Intrinsics.checkExpressionValueIsNotNull((Object)item10, (String)"Items.GOLDEN_CARROT");
            food.add(item10);
            Item item11 = Item.func_150898_a((Block)Blocks.field_150407_cf);
            Intrinsics.checkExpressionValueIsNotNull((Object)item11, (String)"Item.getItemFromBlock(Blocks.HAY_BLOCK)");
            food.add(item11);
            Item item12 = Items.field_151034_e;
            Intrinsics.checkExpressionValueIsNotNull((Object)item12, (String)"Items.APPLE");
            food.add(item12);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

