/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.animalgym;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.ButtonPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.gui.AnimalGymInfoPiece;
import net.ndrei.teslapoweredthingies.items.AnimalPackageItem;
import net.ndrei.teslapoweredthingies.machines.animalfarm.AnimalFarmEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0015H\u0014J\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016J\b\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020(H\u0002J\u001c\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u00010\r2\u0006\u00109\u001a\u00020\u000bH\u0014J\u0010\u0010:\u001a\u0002042\u0006\u00109\u001a\u00020\u000bH\u0016J\u0010\u0010;\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u000e\u0010 \u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0011\u0010#\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0013R\u000e\u0010%\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/animalgym/AnimalGymEntity;", "Lnet/ndrei/teslacorelib/tileentities/ElectricGenerator;", "()V", "current", "Lnet/minecraft/entity/passive/EntityAnimal;", "getCurrent", "()Lnet/minecraft/entity/passive/EntityAnimal;", "currentAnimal", "currentAnimalClass", "Ljava/lang/Class;", "currentAnimalTag", "Lnet/minecraft/nbt/NBTTagCompound;", "currentAnimalType", "", "getCurrentAnimalType", "()Ljava/lang/String;", "enduranceForCurrent", "", "getEnduranceForCurrent", "()F", "energyFillRate", "", "getEnergyFillRate", "()J", "inStackHandler", "Lnet/minecraftforge/items/ItemStackHandler;", "lifespanForCurrent", "", "getLifespanForCurrent", "()I", "maxPowerForCurrent", "getMaxPowerForCurrent", "outStackHandler", "powerPerTick", "getPowerPerTick", "speedForCurrent", "getSpeedForCurrent", "teslaPerHeart", "teslaSpeedMultiplier", "acceptsInputStack", "", "slot", "stack", "Lnet/minecraft/item/ItemStack;", "consumeFuel", "getCurrentAnimal", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "initializeInventories", "", "packageCurrent", "processClientMessage", "Lnet/ndrei/teslacorelib/netsync/SimpleNBTMessage;", "messageType", "compound", "readFromNBT", "writeToNBT", "teslathingies_main"})
public final class AnimalGymEntity
extends ElectricGenerator {
    private ItemStackHandler inStackHandler;
    private ItemStackHandler outStackHandler;
    private final int teslaPerHeart = 8400;
    private final float teslaSpeedMultiplier = 320.0f;
    private Class<?> currentAnimalClass;
    private NBTTagCompound currentAnimalTag;
    private EntityAnimal currentAnimal;

    protected void initializeInventories() {
        super.initializeInventories();
        ItemStackHandler itemStackHandler = this.inStackHandler = (ItemStackHandler)new ItemStackHandler(this, 3){
            final /* synthetic */ AnimalGymEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inStackHandler");
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(61, 25, 18, 54)){
            final /* synthetic */ AnimalGymEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return this.this$0.acceptsInputStack(slot, stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler2 = this.inStackHandler;
        if (itemStackHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inStackHandler");
        }
        super.addInventoryToStorage(itemStackHandler2, "gym_inputs");
        ItemStackHandler itemStackHandler3 = this.outStackHandler = (ItemStackHandler)new ItemStackHandler(this, 3){
            final /* synthetic */ AnimalGymEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outStackHandler");
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler3, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(151, 25, 18, 54)){
            final /* synthetic */ AnimalGymEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler4 = this.outStackHandler;
        if (itemStackHandler4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outStackHandler");
        }
        super.addInventoryToStorage(itemStackHandler4, "gym_outputs");
    }

    public final boolean acceptsInputStack(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return !stack.func_190926_b() && stack.func_77973_b() == AnimalPackageItem.INSTANCE && AnimalPackageItem.INSTANCE.hasAnimal(stack);
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        if (compound.func_150297_b("athlete", 10) && compound.func_150297_b("athleteType", 8)) {
            String animalType = compound.func_74779_i("athleteType");
            try {
                this.currentAnimalClass = Class.forName(animalType);
                this.currentAnimalTag = compound.func_74775_l("athlete");
            }
            catch (Throwable t) {
                TeslaThingiesMod.INSTANCE.getLogger().error("Error deserializing animal gym athlete.", t);
                this.currentAnimal = null;
                this.currentAnimalClass = null;
                this.currentAnimalTag = null;
            }
        } else {
            this.currentAnimal = null;
            this.currentAnimalClass = null;
            this.currentAnimalTag = null;
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound animalCompound;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound nbt = super.func_189515_b(compound);
        EntityAnimal current = this.getCurrent();
        if (current != null && (animalCompound = current.func_189511_e(new NBTTagCompound())) != null) {
            nbt.func_74778_a("athleteType", current.getClass().getName());
            nbt.func_74782_a("athlete", (NBTBase)animalCompound);
        }
        return nbt;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List list = super.getGuiContainerPieces(container);
        list.add(new AnimalGymInfoPiece(this, 88, 25));
        list.add(new ButtonPiece(this, 132, 29, 8, 7){
            final /* synthetic */ AnimalGymEntity this$0;

            protected void renderState(@NotNull BasicTeslaGuiContainer<?> container, boolean over, @NotNull BoundingRectangle box) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
                if (AnimalGymEntity.access$getCurrent$p(this.this$0) == null) {
                    return;
                }
                container.field_146297_k.func_110434_K().func_110577_a(Textures.FARM_TEXTURES.getResource());
                container.drawTexturedRect(box.getLeft() - container.getGuiLeft(), box.getTop() - container.getGuiTop(), 56, over ? 9 : 1, 8, 7);
            }

            protected void clicked() {
                if (AnimalGymEntity.access$getCurrent$p(this.this$0) == null) {
                    return;
                }
                NBTTagCompound nbt = this.this$0.setupSpecialNBTMessage("PACKAGE_ITEM");
                TeslaCoreLib.INSTANCE.getNetwork().sendToServer((IMessage)new SimpleNBTMessage((TileEntity)this.this$0, nbt));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        return list;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        if (messageType != null && Intrinsics.areEqual((Object)messageType, (Object)"PACKAGE_ITEM")) {
            this.packageCurrent();
        }
        return super.processClientMessage(messageType, compound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final EntityAnimal getCurrent() {
        if (this.currentAnimalClass != null && this.currentAnimalTag != null) {
            try {
                Object thing;
                Class<?> clazz = this.currentAnimalClass;
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                if ((thing = clazz.getConstructor(World.class).newInstance(this.func_145831_w())) instanceof EntityAnimal) {
                    NBTTagCompound animalCompound;
                    NBTTagCompound nBTTagCompound = animalCompound = this.currentAnimalTag;
                    if (nBTTagCompound == null) {
                        Intrinsics.throwNpe();
                    }
                    if (nBTTagCompound.func_150297_b("Attributes", 9) && this.func_145831_w().field_72995_K) {
                        SharedMonsterAttributes.func_151475_a((AbstractAttributeMap)((EntityAnimal)thing).func_110140_aT(), (NBTTagList)animalCompound.func_150295_c("Attributes", 10));
                    }
                    ((EntityAnimal)thing).deserializeNBT(animalCompound);
                    this.currentAnimal = (EntityAnimal)thing;
                    this.func_70296_d();
                }
            }
            catch (Throwable t) {
                TeslaThingiesMod.INSTANCE.getLogger().error("Error deserializing animal gym athlete.", t);
                this.currentAnimal = null;
                this.func_70296_d();
            }
            finally {
                this.currentAnimalClass = null;
                this.currentAnimalTag = null;
                this.func_70296_d();
            }
        }
        if (this.currentAnimal == null) {
            int n;
            int t = 0;
            ItemStackHandler itemStackHandler = this.inStackHandler;
            if (itemStackHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inStackHandler");
            }
            if (t <= (n = itemStackHandler.getSlots() - 1)) {
                while (true) {
                    void index;
                    ItemStack stack;
                    ItemStackHandler itemStackHandler2 = this.inStackHandler;
                    if (itemStackHandler2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"inStackHandler");
                    }
                    if (!(stack = itemStackHandler2.getStackInSlot((int)index)).func_190926_b() && stack.func_77973_b() == AnimalPackageItem.INSTANCE) {
                        ItemStack itemStack = stack;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                        if (AnimalPackageItem.INSTANCE.hasAnimal(itemStack)) {
                            ItemStackHandler itemStackHandler3 = this.inStackHandler;
                            if (itemStackHandler3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"inStackHandler");
                            }
                            itemStackHandler3.setStackInSlot((int)index, ItemStack.field_190927_a);
                            World world = this.func_145831_w();
                            ItemStack itemStack2 = stack;
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
                            this.currentAnimal = AnimalPackageItem.INSTANCE.unpackage(world, itemStack2);
                            this.forceSync();
                            return this.currentAnimal == null ? null : this.getCurrent();
                        }
                    }
                    if (index == n) break;
                    ++index;
                }
            }
            return null;
        }
        return this.currentAnimal;
    }

    private final boolean packageCurrent() {
        ItemStack remaining;
        EntityAnimal entityAnimal = this.getCurrent();
        if (entityAnimal == null) {
            return false;
        }
        EntityAnimal ea = entityAnimal;
        ItemStackHandler itemStackHandler = this.outStackHandler;
        if (itemStackHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outStackHandler");
        }
        if ((remaining = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)itemStackHandler), (ItemStack)AnimalFarmEntity.Companion.packageAnimal$teslathingies_main(null, ea), (boolean)false)).func_190926_b()) {
            this.currentAnimal = null;
            this.forceSync();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    protected long consumeFuel() {
        EntityAnimal entityAnimal = this.getCurrent();
        if (entityAnimal == null) {
            return 0L;
        }
        EntityAnimal ea = entityAnimal;
        if ((double)ea.func_110143_aJ() <= 2.0 && (double)this.func_145831_w().field_73012_v.nextFloat() > 0.2 && this.packageCurrent()) {
            EntityAnimal entityAnimal2 = this.getCurrent();
            if (entityAnimal2 == null) {
                return 0L;
            }
            ea = entityAnimal2;
        }
        ea.func_70606_j(ea.func_110143_aJ() - 1.0f);
        if (ea.func_110143_aJ() < 0.001f) {
            this.currentAnimal = null;
            this.forceSync();
            this.func_70296_d();
            return 0L;
        }
        return this.teslaPerHeart;
    }

    protected long getEnergyFillRate() {
        return Math.round(this.teslaSpeedMultiplier * this.getSpeedForCurrent());
    }

    @NotNull
    public final String getCurrentAnimalType() {
        String string;
        EntityAnimal a = this.getCurrent();
        if (a == null) {
            string = "n/a";
        } else {
            String string2 = a.func_70005_c_();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"a.name");
        }
        return string;
    }

    @Nullable
    public final EntityAnimal getCurrentAnimal() {
        return this.getCurrent();
    }

    public final float getSpeedForCurrent() {
        EntityAnimal a = this.getCurrent();
        EntityAnimal entityAnimal = a;
        return entityAnimal != null && (entityAnimal = entityAnimal.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null ? (float)entityAnimal.func_111125_b() : 0.0f;
    }

    public final float getPowerPerTick() {
        return this.teslaSpeedMultiplier * this.getSpeedForCurrent();
    }

    public final float getEnduranceForCurrent() {
        EntityAnimal a;
        EntityAnimal entityAnimal = a = this.getCurrent();
        return entityAnimal != null ? entityAnimal.func_110143_aJ() : 0.0f;
    }

    public final int getLifespanForCurrent() {
        return Math.round(this.getEnduranceForCurrent() * 60.0f * 20.0f);
    }

    public final int getMaxPowerForCurrent() {
        return Math.round((float)this.teslaPerHeart * this.getEnduranceForCurrent());
    }

    public AnimalGymEntity() {
        super(AnimalGymEntity.class.getName().hashCode());
    }

    @Nullable
    public static final /* synthetic */ EntityAnimal access$getCurrent$p(AnimalGymEntity $this) {
        return $this.getCurrent();
    }
}

