/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.animalreleaser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslacorelib.utils.BlockPosUtils;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.items.AnimalPackageItem;
import net.ndrei.teslapoweredthingies.machines.ElectricFarmMachine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u0004H\u0014\u00a8\u0006\r"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/animalreleaser/AnimalReleaserEntity;", "Lnet/ndrei/teslapoweredthingies/machines/ElectricFarmMachine;", "()V", "acceptsInputStack", "", "slot", "", "stack", "Lnet/minecraft/item/ItemStack;", "getWorkAreaColor", "performWork", "", "supportsAddons", "teslathingies_main"})
public final class AnimalReleaserEntity
extends ElectricFarmMachine {
    @Override
    protected boolean acceptsInputStack(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)stack.func_77973_b().getRegistryName(), (Object)AnimalPackageItem.INSTANCE.getRegistryName())) {
            return AnimalPackageItem.INSTANCE.hasAnimal(stack);
        }
        return false;
    }

    protected boolean supportsAddons() {
        return false;
    }

    @Override
    public int getWorkAreaColor() {
        return 16766976;
    }

    protected float performWork() {
        ItemStack stackCopy;
        ItemStack stack = ItemStack.field_190927_a;
        int stackIndex = 0;
        while (true) {
            ItemStackHandler itemStackHandler = this.getInStackHandler();
            if (itemStackHandler == null) {
                Intrinsics.throwNpe();
            }
            if (stackIndex >= itemStackHandler.getSlots()) break;
            ItemStackHandler itemStackHandler2 = this.getInStackHandler();
            if (itemStackHandler2 == null) {
                Intrinsics.throwNpe();
            }
            if (!(stack = itemStackHandler2.extractItem(stackIndex, 1, true)).func_190926_b()) break;
            ++stackIndex;
        }
        if (!stack.func_190926_b() && (stackCopy = stack.func_77946_l()).func_77973_b() instanceof AnimalPackageItem && stackCopy.func_77942_o()) {
            NBTTagCompound compound;
            NBTTagCompound nBTTagCompound = compound = stackCopy.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o("hasAnimal");
            if (compound.func_74764_b("animal") && compound.func_74764_b("animalClass")) {
                NBTTagCompound animal = compound.func_74775_l("animal");
                String animalClass = compound.func_74779_i("animalClass");
                try {
                    Class<?> cea = Class.forName(animalClass);
                    Object thing = cea.getConstructor(World.class).newInstance(this.func_145831_w());
                    if (thing instanceof EntityAnimal) {
                        Object ea = thing;
                        ((EntityAnimal)ea).func_70037_a(animal);
                        EnumFacing facing = super.getFacing().func_176734_d();
                        BlockPos blockPos = this.func_174877_v().func_177967_a(facing, 1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos().offset(facing, 1)");
                        BlockCube cube = BlockPosUtils.INSTANCE.getCube(blockPos, facing, this.getRange() - 1, 1);
                        BlockPos pos = cube.getRandomInside(this.func_145831_w().field_73012_v);
                        ((EntityAnimal)ea).func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        stackCopy.func_77982_d((NBTTagCompound)null);
                        ItemStack itemStack = stackCopy;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stackCopy");
                        if (super.outputItems(itemStack)) {
                            ItemStackHandler itemStackHandler = this.getInStackHandler();
                            if (itemStackHandler == null) {
                                Intrinsics.throwNpe();
                            }
                            itemStackHandler.extractItem(stackIndex, 1, false);
                            this.func_145831_w().func_72838_d((Entity)ea);
                            return 1.0f;
                        }
                    }
                }
                catch (Throwable e) {
                    TeslaThingiesMod.INSTANCE.getLogger().warn("Error creating animal '" + animalClass + "'.", e);
                }
            }
        }
        return 0.0f;
    }

    public AnimalReleaserEntity() {
        super(AnimalReleaserEntity.class.getName().hashCode());
    }
}

