/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.cropcloner;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.render.HudInfoLine;
import net.ndrei.teslapoweredthingies.machines.ElectricFarmMachine;
import net.ndrei.teslapoweredthingies.machines.cropcloner.CropClonerBlock;
import net.ndrei.teslapoweredthingies.machines.cropcloner.CropClonerPlantFactory;
import net.ndrei.teslapoweredthingies.machines.cropcloner.ICropClonerPlant;
import net.ndrei.teslapoweredthingies.render.CropClonerSpecialRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0016\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u001e0\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020!H\u0014J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0004H\u0014J\b\u0010*\u001a\u00020\u0004H\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/cropcloner/CropClonerEntity;", "Lnet/ndrei/teslapoweredthingies/machines/ElectricFarmMachine;", "()V", "hasWorkArea", "", "getHasWorkArea", "()Z", "hudLines", "", "Lnet/ndrei/teslacorelib/render/HudInfoLine;", "getHudLines", "()Ljava/util/List;", "lockableInputInventory", "getLockableInputInventory", "<set-?>", "Lnet/minecraft/block/state/IBlockState;", "plantedThing", "getPlantedThing", "()Lnet/minecraft/block/state/IBlockState;", "setPlantedThing", "(Lnet/minecraft/block/state/IBlockState;)V", "waterTank", "Lnet/minecraftforge/fluids/IFluidTank;", "acceptsInputStack", "slot", "", "stack", "Lnet/minecraft/item/ItemStack;", "getRenderers", "", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lnet/minecraft/tileentity/TileEntity;", "initializeInputInventory", "", "initializeInventories", "onPlantedThingChanged", "performWork", "", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "supportsAddons", "supportsRangeAddons", "writeToNBT", "teslathingies_main"})
public final class CropClonerEntity
extends ElectricFarmMachine {
    @Nullable
    private IBlockState plantedThing;
    private IFluidTank waterTank;

    @Nullable
    public final IBlockState getPlantedThing() {
        return this.plantedThing;
    }

    private final void setPlantedThing(IBlockState iBlockState) {
        this.plantedThing = iBlockState;
    }

    @Override
    public boolean supportsRangeAddons() {
        return false;
    }

    protected boolean supportsAddons() {
        return false;
    }

    @Override
    public boolean getHasWorkArea() {
        return false;
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        Fluid fluid = FluidRegistry.WATER;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"FluidRegistry.WATER");
        this.waterTank = super.addFluidTank(fluid, 5000, EnumDyeColor.BLUE, "Water Tank", new BoundingRectangle(43, 25, 18, 54));
    }

    @Override
    protected void initializeInputInventory() {
        this.setInStackHandler(new ItemStackHandler(this, 1){
            final /* synthetic */ CropClonerEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return 1;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
        ItemStackHandler itemStackHandler = this.getInStackHandler();
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        this.setFilteredInStackHandler(new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(133, 25, 18, 18)){
            final /* synthetic */ CropClonerEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return super.canInsertItem(slot, stack) && this.this$0.acceptsInputStack(slot, stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        super.addInventory((IItemHandler)this.getFilteredInStackHandler());
        ItemStackHandler itemStackHandler2 = this.getInStackHandler();
        if (itemStackHandler2 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler2, "inputs");
    }

    @Override
    protected boolean getLockableInputInventory() {
        return false;
    }

    @Override
    protected boolean acceptsInputStack(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IPlantable) {
            Item item2 = stack.func_77973_b();
            if (item2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.common.IPlantable");
            }
            IPlantable plant = (IPlantable)item2;
            if (Intrinsics.areEqual((Object)plant.getPlantType((IBlockAccess)this.func_145831_w(), this.func_174877_v()), (Object)EnumPlantType.Crop)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected List<HudInfoLine> getHudLines() {
        List list = CollectionsKt.toMutableList((Collection)super.getHudLines());
        if (this.plantedThing == null) {
            list.add(new HudInfoLine(new Color(255, 159, 51), new Color(255, 159, 51, 42), "no seed").setTextAlignment(HudInfoLine.TextAlignment.CENTER));
        } else {
            PropertyInteger age;
            Color color = Color.WHITE;
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
            IBlockState iBlockState = this.plantedThing;
            if (iBlockState == null) {
                Intrinsics.throwNpe();
            }
            String string = iBlockState.func_177230_c().func_149732_F();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.plantedThing!!.block.localizedName");
            list.add(new HudInfoLine(color, string).setTextAlignment(HudInfoLine.TextAlignment.CENTER));
            IBlockState iBlockState2 = this.plantedThing;
            if (iBlockState2 == null) {
                Intrinsics.throwNpe();
            }
            ICropClonerPlant iCropClonerPlant = CropClonerPlantFactory.INSTANCE.getPlant(iBlockState2);
            IBlockState iBlockState3 = this.plantedThing;
            if (iBlockState3 == null) {
                Intrinsics.throwNpe();
            }
            if ((age = iCropClonerPlant.getAgeProperty(iBlockState3)) != null) {
                IBlockState iBlockState4 = this.plantedThing;
                if (iBlockState4 == null) {
                    Intrinsics.throwNpe();
                }
                int percent = ((Number)((Object)iBlockState4.func_177229_b((IProperty)age))).intValue() * 100 / age.func_177700_c().size();
                list.add(new HudInfoLine(Color.CYAN, new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 192), new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), 192), "growth: " + percent + "%").setProgress((float)percent / 100.0f, new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), 50)));
            }
        }
        return CollectionsKt.toList((Iterable)list);
    }

    @Override
    @NotNull
    public List<TileEntitySpecialRenderer<? super TileEntity>> getRenderers() {
        List<TileEntitySpecialRenderer<? super TileEntity>> list = super.getRenderers();
        list.add(CropClonerSpecialRenderer.INSTANCE);
        return list;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        ResourceLocation location;
        Block block;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        if (compound.func_74764_b("plantDomain") && compound.func_74764_b("plantPath") && (block = (Block)Block.field_149771_c.func_82594_a((Object)(location = new ResourceLocation(compound.func_74779_i("plantDomain"), compound.func_74779_i("plantPath"))))) != null) {
            this.plantedThing = block.func_176223_P();
            this.onPlantedThingChanged();
        }
        if (compound.func_74764_b("plantAge") && this.plantedThing != null) {
            PropertyInteger ageProperty;
            int age = compound.func_74762_e("plantAge");
            IBlockState iBlockState = this.plantedThing;
            if (iBlockState == null) {
                Intrinsics.throwNpe();
            }
            ICropClonerPlant iCropClonerPlant = CropClonerPlantFactory.INSTANCE.getPlant(iBlockState);
            IBlockState iBlockState2 = this.plantedThing;
            if (iBlockState2 == null) {
                Intrinsics.throwNpe();
            }
            if ((ageProperty = iCropClonerPlant.getAgeProperty(iBlockState2)) != null) {
                IBlockState iBlockState3 = this.plantedThing;
                if (iBlockState3 == null) {
                    Intrinsics.throwNpe();
                }
                this.plantedThing = iBlockState3.func_177226_a((IProperty)ageProperty, (Comparable)Integer.valueOf(age));
                this.onPlantedThingChanged();
            }
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound compound2 = compound;
        compound2 = super.func_189515_b(compound2);
        if (this.plantedThing != null) {
            PropertyInteger ageProperty;
            ResourceLocation resource;
            IBlockState iBlockState = this.plantedThing;
            if (iBlockState == null) {
                Intrinsics.throwNpe();
            }
            ResourceLocation resourceLocation = resource = iBlockState.func_177230_c().getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            compound2.func_74778_a("plantDomain", resourceLocation.func_110624_b());
            compound2.func_74778_a("plantPath", resource.func_110623_a());
            IBlockState iBlockState2 = this.plantedThing;
            if (iBlockState2 == null) {
                Intrinsics.throwNpe();
            }
            ICropClonerPlant iCropClonerPlant = CropClonerPlantFactory.INSTANCE.getPlant(iBlockState2);
            IBlockState iBlockState3 = this.plantedThing;
            if (iBlockState3 == null) {
                Intrinsics.throwNpe();
            }
            if ((ageProperty = iCropClonerPlant.getAgeProperty(iBlockState3)) != null) {
                IBlockState iBlockState4 = this.plantedThing;
                if (iBlockState4 == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = iBlockState4.func_177229_b((IProperty)ageProperty);
                Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"this.plantedThing!!.getValue(ageProperty)");
                compound2.func_74768_a("plantAge", ((Number)((Object)comparable)).intValue());
            }
        }
        return compound2;
    }

    protected float performWork() {
        ICropClonerPlant wrapper;
        PropertyInteger ageProperty;
        float result = 0.0f;
        IBlockState planted = this.plantedThing;
        if (planted != null && (ageProperty = (wrapper = CropClonerPlantFactory.INSTANCE.getPlant(planted)).getAgeProperty(planted)) != null) {
            Collection $receiver$iv;
            Integer age = (Integer)planted.func_177229_b((IProperty)ageProperty);
            Collection collection = $receiver$iv = ageProperty.func_177700_c();
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
            if (integerArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Integer[] ages = integerArray;
            if (Intrinsics.areEqual((Object)age, (Object)ages[((Object[])ages).length - 1])) {
                World world = this.func_145831_w();
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"this.getWorld()");
                BlockPos blockPos = this.func_174877_v();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos()");
                List<ItemStack> stacks = wrapper.getDrops(world, blockPos, planted);
                if (super.outputItems(stacks)) {
                    this.plantedThing = null;
                    result += 0.85f;
                }
            } else {
                Random random = this.func_145831_w().field_73012_v;
                Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"this.getWorld().rand");
                this.plantedThing = wrapper.grow(planted, ageProperty, random);
                result += 0.75f;
            }
            this.onPlantedThingChanged();
        }
        if (this.plantedThing == null) {
            IFluidTank iFluidTank = this.waterTank;
            if (iFluidTank == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
            }
            if (iFluidTank.getFluidAmount() >= 250) {
                ItemStack stack;
                ItemStackHandler itemStackHandler = this.getInStackHandler();
                if (itemStackHandler == null) {
                    Intrinsics.throwNpe();
                }
                if (!(stack = itemStackHandler.getStackInSlot(0)).func_190926_b() && stack.func_77973_b() instanceof IPlantable) {
                    Item item2 = stack.func_77973_b();
                    if (item2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.common.IPlantable");
                    }
                    IPlantable plantable = (IPlantable)item2;
                    if (Intrinsics.areEqual((Object)plantable.getPlantType((IBlockAccess)this.func_145831_w(), this.func_174877_v()), (Object)EnumPlantType.Crop)) {
                        this.plantedThing = plantable.getPlant((IBlockAccess)this.func_145831_w(), this.func_174877_v());
                        IFluidTank iFluidTank2 = this.waterTank;
                        if (iFluidTank2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
                        }
                        iFluidTank2.drain(250, true);
                        this.onPlantedThingChanged();
                    }
                }
                result += 0.15f;
            }
        }
        return result;
    }

    private final void onPlantedThingChanged() {
        if (this.func_145831_w() != null && this.func_174877_v() != null) {
            int state = this.plantedThing == null ? 0 : 1;
            IBlockState block = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (Intrinsics.areEqual((Object)((Integer)block.func_177229_b((IProperty)CropClonerBlock.INSTANCE.getSTATE())), (Object)state) ^ true) {
                IBlockState iBlockState = block.func_177226_a((IProperty)CropClonerBlock.INSTANCE.getSTATE(), (Comparable)Integer.valueOf(state));
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"block.withProperty(CropClonerBlock.STATE, state)");
                World world = this.func_145831_w();
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"this.getWorld()");
                BlockPos blockPos = this.func_174877_v();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos()");
                CropClonerBlock.INSTANCE.setState(iBlockState, world, blockPos);
            }
        }
        this.func_70296_d();
        this.forceSync();
    }

    public CropClonerEntity() {
        super(CropClonerEntity.class.getName().hashCode());
    }
}

