/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.cropfarm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.ndrei.teslapoweredthingies.machines.cropfarm.AgricraftPlantWrapper;
import net.ndrei.teslapoweredthingies.machines.cropfarm.IPlantWrapper;
import net.ndrei.teslapoweredthingies.machines.cropfarm.ISeedWrapper;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaCactusPlant;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaCactusSeed;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaGenericPlant;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaGenericSeed;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaMelonPlant;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaMelonSeed;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaNetherWartPlant;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaNetherWartSeed;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaReedsSeed;
import net.ndrei.teslapoweredthingies.machines.cropfarm.VanillaTallPlant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/cropfarm/PlantWrapperFactory;", "", "()V", "getPlantWrapper", "Lnet/ndrei/teslapoweredthingies/machines/cropfarm/IPlantWrapper;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getSeedWrapper", "Lnet/ndrei/teslapoweredthingies/machines/cropfarm/ISeedWrapper;", "seeds", "Lnet/minecraft/item/ItemStack;", "isFertilizer", "", "stack", "isSeed", "teslathingies_main"})
public final class PlantWrapperFactory {
    public static final PlantWrapperFactory INSTANCE;

    @Nullable
    public final ISeedWrapper getSeedWrapper(@NotNull ItemStack seeds) {
        Intrinsics.checkParameterIsNotNull((Object)seeds, (String)"seeds");
        if (seeds.func_190926_b()) {
            return null;
        }
        Item seed = seeds.func_77973_b();
        if (seed == Items.field_151081_bc || seed == Items.field_151080_bb) {
            ItemStack itemStack = seeds.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"seeds.copy()");
            return new VanillaMelonSeed(itemStack);
        }
        if (seed == Items.field_151120_aE) {
            ItemStack itemStack = seeds.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"seeds.copy()");
            return new VanillaReedsSeed(itemStack);
        }
        if (seed == Item.func_150898_a((Block)((Block)Blocks.field_150434_aF))) {
            ItemStack itemStack = seeds.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"seeds.copy()");
            return new VanillaCactusSeed(itemStack);
        }
        if (VanillaNetherWartSeed.Companion.isSeed(seeds)) {
            ItemStack itemStack = seeds.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"seeds.copy()");
            return new VanillaNetherWartSeed(itemStack);
        }
        if (seed instanceof IPlantable) {
            ItemStack itemStack = seeds.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"seeds.copy()");
            return new VanillaGenericSeed(itemStack);
        }
        return null;
    }

    public final boolean isSeed(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return VanillaGenericSeed.Companion.isSeed(stack) || VanillaCactusSeed.Companion.isSeed(stack) || VanillaMelonSeed.Companion.isSeed(stack) || VanillaReedsSeed.Companion.isSeed(stack) || VanillaNetherWartSeed.Companion.isSeed(stack);
    }

    @Nullable
    public final IPlantWrapper getPlantWrapper(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (StringsKt.startsWith$default((String)block.getClass().getName(), (String)"com.infinityraider.agricraft.blocks", (boolean)false, (int)2, null)) {
            Block block2 = block;
            Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new AgricraftPlantWrapper(block2, iBlockState, world, pos);
        }
        if (block == Blocks.field_150394_bc || block == Blocks.field_150393_bb) {
            Block block3 = block;
            Intrinsics.checkExpressionValueIsNotNull((Object)block3, (String)"block");
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new VanillaMelonPlant(block3, iBlockState, world, pos);
        }
        if (block == Blocks.field_150436_aH) {
            Block block4 = block;
            Intrinsics.checkExpressionValueIsNotNull((Object)block4, (String)"block");
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new VanillaTallPlant(block4, iBlockState, world, pos);
        }
        if (block == Blocks.field_150434_aF) {
            Block block5 = block;
            Intrinsics.checkExpressionValueIsNotNull((Object)block5, (String)"block");
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new VanillaCactusPlant(block5, iBlockState, world, pos);
        }
        if (block == Blocks.field_150388_bm) {
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new VanillaNetherWartPlant(iBlockState, world, pos);
        }
        if (block instanceof IGrowable) {
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return new VanillaGenericPlant(block, iBlockState, world, pos);
        }
        return null;
    }

    public final boolean isFertilizer(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15;
    }

    private PlantWrapperFactory() {
        INSTANCE = this;
    }

    static {
        new PlantWrapperFactory();
    }
}

