/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.fluidburner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.integrations.jei.BaseCategory;
import net.ndrei.teslapoweredthingies.integrations.jei.TeslaThingyJeiCategory;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerBlock;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolantRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuelRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerRecipes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TeslaThingyJeiCategory
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCategory;", "Lnet/ndrei/teslapoweredthingies/integrations/jei/BaseCategory;", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCategory$FluidBurnerRecipeWrapper;", "()V", "coolantOverlay", "Lmezz/jei/api/gui/IDrawable;", "fuelOverlay", "register", "", "registry", "Lmezz/jei/api/IModRegistry;", "Lmezz/jei/api/recipe/IRecipeCategoryRegistration;", "setRecipe", "recipeLayout", "Lmezz/jei/api/gui/IRecipeLayout;", "recipeWrapper", "ingredients", "Lmezz/jei/api/ingredients/IIngredients;", "FluidBurnerRecipeWrapper", "teslathingies_main"})
public final class FluidBurnerCategory
extends BaseCategory<FluidBurnerRecipeWrapper> {
    private static IDrawable fuelOverlay;
    private static IDrawable coolantOverlay;
    public static final FluidBurnerCategory INSTANCE;

    public void setRecipe(@NotNull IRecipeLayout recipeLayout, @NotNull FluidBurnerRecipeWrapper recipeWrapper, @NotNull IIngredients ingredients) {
        Intrinsics.checkParameterIsNotNull((Object)recipeLayout, (String)"recipeLayout");
        Intrinsics.checkParameterIsNotNull((Object)recipeWrapper, (String)"recipeWrapper");
        Intrinsics.checkParameterIsNotNull((Object)ingredients, (String)"ingredients");
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        int capacity = recipeWrapper.getCoolant() != null ? Math.max(recipeWrapper.getFuel().getAmount(), recipeWrapper.getCoolant().getAmount()) : recipeWrapper.getFuel().getAmount();
        IDrawable iDrawable = fuelOverlay;
        if (iDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fuelOverlay");
        }
        fluids.init(0, true, 8, 8, 8, 27, capacity, false, iDrawable);
        fluids.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        if (ingredients.getInputs(FluidStack.class).size() == 2) {
            IDrawable iDrawable2 = coolantOverlay;
            if (iDrawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"coolantOverlay");
            }
            fluids.init(1, true, 20, 8, 8, 27, capacity, false, iDrawable2);
            fluids.set(1, (List)ingredients.getInputs(FluidStack.class).get(1));
        }
    }

    @Override
    public void register(@NotNull IRecipeCategoryRegistration registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        super.register(registry);
        IDrawableStatic iDrawableStatic = this.getGuiHelper().createDrawable(Textures.JEI_TEXTURES.getResource(), 0, 66, 124, 66);
        Intrinsics.checkExpressionValueIsNotNull((Object)iDrawableStatic, (String)"this.guiHelper.createDra\u2026resource, 0, 66, 124, 66)");
        this.setRecipeBackground((IDrawable)iDrawableStatic);
        IDrawableStatic iDrawableStatic2 = this.getGuiHelper().createDrawable(Textures.JEI_TEXTURES.getResource(), 8, 74, 8, 27);
        Intrinsics.checkExpressionValueIsNotNull((Object)iDrawableStatic2, (String)"this.guiHelper.createDra\u2026S.resource, 8, 74, 8, 27)");
        fuelOverlay = (IDrawable)iDrawableStatic2;
        IDrawableStatic iDrawableStatic3 = this.getGuiHelper().createDrawable(Textures.JEI_TEXTURES.getResource(), 20, 74, 8, 27);
        Intrinsics.checkExpressionValueIsNotNull((Object)iDrawableStatic3, (String)"this.guiHelper.createDra\u2026.resource, 20, 74, 8, 27)");
        coolantOverlay = (IDrawable)iDrawableStatic3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void register(@NotNull IModRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        super.register(registry);
        ArrayList recipes = Lists.newArrayList();
        for (FluidBurnerFuelRecipe fuel : FluidBurnerRecipes.INSTANCE.getFuels()) {
            recipes.add(new FluidBurnerRecipeWrapper(fuel, null));
            Iterable $receiver$iv = FluidBurnerRecipes.INSTANCE.getCoolants();
            for (Object item$iv : $receiver$iv) {
                void it;
                FluidBurnerCoolantRecipe fluidBurnerCoolantRecipe = (FluidBurnerCoolantRecipe)item$iv;
                Collection collection = recipes;
                FluidBurnerRecipeWrapper fluidBurnerRecipeWrapper = new FluidBurnerRecipeWrapper(fuel, (FluidBurnerCoolantRecipe)it);
                collection.add(fluidBurnerRecipeWrapper);
            }
        }
        registry.addRecipes((Collection)recipes, this.getUid());
    }

    private FluidBurnerCategory() {
        super((Block)FluidBurnerBlock.INSTANCE);
        INSTANCE = this;
    }

    static {
        new FluidBurnerCategory();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0017J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCategory$FluidBurnerRecipeWrapper;", "Lmezz/jei/api/recipe/IRecipeWrapper;", "fuel", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerFuelRecipe;", "coolant", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCoolantRecipe;", "(Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerFuelRecipe;Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCoolantRecipe;)V", "getCoolant", "()Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCoolantRecipe;", "getFuel", "()Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerFuelRecipe;", "drawInfo", "", "minecraft", "Lnet/minecraft/client/Minecraft;", "recipeWidth", "", "recipeHeight", "mouseX", "mouseY", "getIngredients", "ingredients", "Lmezz/jei/api/ingredients/IIngredients;", "teslathingies_main"})
    public static final class FluidBurnerRecipeWrapper
    implements IRecipeWrapper {
        @NotNull
        private final FluidBurnerFuelRecipe fuel;
        @Nullable
        private final FluidBurnerCoolantRecipe coolant;

        public void getIngredients(@NotNull IIngredients ingredients) {
            Intrinsics.checkParameterIsNotNull((Object)ingredients, (String)"ingredients");
            if (this.coolant == null) {
                ingredients.setInput(FluidStack.class, (Object)new FluidStack(this.fuel.getFluid(), this.fuel.getAmount()));
            } else {
                ingredients.setInputs(FluidStack.class, (List)Lists.newArrayList((Object[])new FluidStack[]{new FluidStack(this.fuel.getFluid(), this.fuel.getAmount()), new FluidStack(this.coolant.getFluid(), this.coolant.getAmount())}));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void drawInfo(@NotNull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            Intrinsics.checkParameterIsNotNull((Object)minecraft, (String)"minecraft");
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            int ticks = this.fuel.getBaseTicks();
            if (this.coolant != null) {
                ticks = Math.round((float)ticks * this.coolant.getTimeMultiplier());
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%,d ticks";
            Object object = new Object[]{ticks};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String duration = string2;
            string = StringCompanionObject.INSTANCE;
            object = "%,d T";
            Object[] objectArray = new Object[]{ticks * 80};
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String power = string3;
            minecraft.field_71466_p.func_78276_b(duration, 36, 12, 32639);
            minecraft.field_71466_p.func_78276_b(power, 36, 12 + minecraft.field_71466_p.field_78288_b, 32639);
        }

        @NotNull
        public final FluidBurnerFuelRecipe getFuel() {
            return this.fuel;
        }

        @Nullable
        public final FluidBurnerCoolantRecipe getCoolant() {
            return this.coolant;
        }

        public FluidBurnerRecipeWrapper(@NotNull FluidBurnerFuelRecipe fuel, @Nullable FluidBurnerCoolantRecipe coolant) {
            Intrinsics.checkParameterIsNotNull((Object)fuel, (String)"fuel");
            this.fuel = fuel;
            this.coolant = coolant;
        }
    }
}

