/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.fluidburner;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolant;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerCoolantRecipe;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuel;
import net.ndrei.teslapoweredthingies.machines.fluidburner.FluidBurnerFuelRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerRecipes;", "", "()V", "coolantRecipes", "", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCoolantRecipe;", "coolants", "", "getCoolants", "()Ljava/util/List;", "fuelRecipes", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerFuelRecipe;", "fuels", "getFuels", "drainCoolant", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerCoolant;", "tank", "Lnet/minecraftforge/fluids/IFluidTank;", "doDrain", "", "drainFuel", "Lnet/ndrei/teslapoweredthingies/machines/fluidburner/FluidBurnerFuel;", "isCoolant", "stack", "Lnet/minecraftforge/fluids/FluidStack;", "isFuel", "registerRecipes", "", "teslathingies_main"})
public final class FluidBurnerRecipes {
    private static final List<FluidBurnerCoolantRecipe> coolantRecipes;
    private static final List<FluidBurnerFuelRecipe> fuelRecipes;
    public static final FluidBurnerRecipes INSTANCE;

    public final void registerRecipes() {
        coolantRecipes.clear();
        fuelRecipes.clear();
        Fluid fluid = FluidRegistry.WATER;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"FluidRegistry.WATER");
        coolantRecipes.add(new FluidBurnerCoolantRecipe(fluid, 100, 1.2f));
        Fluid fluid2 = FluidRegistry.LAVA;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"FluidRegistry.LAVA");
        fuelRecipes.add(new FluidBurnerFuelRecipe(fluid2, 100, 600));
    }

    public final boolean isCoolant(@NotNull FluidStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.getFluid() == FluidRegistry.WATER;
    }

    public final boolean isFuel(@NotNull FluidStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.getFluid() == FluidRegistry.LAVA;
    }

    @Nullable
    public final FluidBurnerCoolant drainCoolant(@NotNull IFluidTank tank, boolean doDrain) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        FluidStack existing = tank.getFluid();
        if (existing != null && existing.amount > 0) {
            for (FluidBurnerCoolantRecipe recipe : coolantRecipes) {
                if (!Intrinsics.areEqual((Object)recipe.getFluid(), (Object)existing.getFluid()) || recipe.getAmount() > existing.amount) continue;
                FluidStack fluidStack = tank.drain(recipe.getAmount(), doDrain);
                if (fluidStack == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"tank.drain(recipe.amount, doDrain)!!");
                return new FluidBurnerCoolant(recipe, fluidStack);
            }
        }
        return null;
    }

    @Nullable
    public final FluidBurnerFuel drainFuel(@NotNull IFluidTank tank, boolean doDrain) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        FluidStack existing = tank.getFluid();
        if (existing != null && existing.amount > 0) {
            for (FluidBurnerFuelRecipe recipe : fuelRecipes) {
                if (!Intrinsics.areEqual((Object)recipe.getFluid(), (Object)existing.getFluid()) || recipe.getAmount() > existing.amount) continue;
                FluidStack fluidStack = tank.drain(recipe.getAmount(), doDrain);
                if (fluidStack == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"tank.drain(recipe.amount, doDrain)!!");
                return new FluidBurnerFuel(recipe, fluidStack);
            }
        }
        return null;
    }

    @NotNull
    public final List<FluidBurnerFuelRecipe> getFuels() {
        return CollectionsKt.toList((Iterable)fuelRecipes);
    }

    @NotNull
    public final List<FluidBurnerCoolantRecipe> getCoolants() {
        return CollectionsKt.toList((Iterable)coolantRecipes);
    }

    private FluidBurnerRecipes() {
        INSTANCE = this;
        coolantRecipes = new ArrayList();
        fuelRecipes = new ArrayList();
    }

    static {
        new FluidBurnerRecipes();
    }
}

