/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.fluidsolidifier;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.FluidTankPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.gui.IMultiTankMachine;
import net.ndrei.teslapoweredthingies.gui.TankInfo;
import net.ndrei.teslapoweredthingies.machines.BaseThingyMachine;
import net.ndrei.teslapoweredthingies.machines.fluidsolidifier.FluidSolidifierResult;
import net.ndrei.teslapoweredthingies.render.DualTankEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0014J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J\u0016\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u001e0\u0017H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\b\u0010#\u001a\u00020\u0015H\u0014J\b\u0010$\u001a\u00020%H\u0014J\u001c\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020+2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/fluidsolidifier/FluidSolidifierEntity;", "Lnet/ndrei/teslapoweredthingies/machines/BaseThingyMachine;", "Lnet/ndrei/teslapoweredthingies/gui/IMultiTankMachine;", "()V", "energyForWork", "", "getEnergyForWork", "()I", "fluidItemsBoundingBox", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "getFluidItemsBoundingBox", "()Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "lastWorkResult", "Lnet/ndrei/teslapoweredthingies/machines/fluidsolidifier/FluidSolidifierResult;", "lavaTank", "Lnet/minecraftforge/fluids/IFluidTank;", "outputs", "Lnet/minecraftforge/items/ItemStackHandler;", "resultType", "waterTank", "addFluidItemsBackground", "", "pieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "box", "getGuiContainerPieces", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "getRenderers", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lnet/minecraft/tileentity/TileEntity;", "getTanks", "", "Lnet/ndrei/teslapoweredthingies/gui/TankInfo;", "initializeInventories", "performWork", "", "processClientMessage", "Lnet/ndrei/teslacorelib/netsync/SimpleNBTMessage;", "messageType", "", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromNBT", "shouldAddFluidItemsInventory", "", "writeToNBT", "teslathingies_main"})
public final class FluidSolidifierEntity
extends BaseThingyMachine
implements IMultiTankMachine {
    private IFluidTank waterTank;
    private IFluidTank lavaTank;
    private ItemStackHandler outputs;
    private FluidSolidifierResult resultType = FluidSolidifierResult.COBBLESTONE;
    private FluidSolidifierResult lastWorkResult;

    protected void initializeInventories() {
        super.initializeInventories();
        super.ensureFluidItems();
        Fluid fluid = FluidRegistry.WATER;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"FluidRegistry.WATER");
        this.waterTank = super.addFluidTank(fluid, 5000, EnumDyeColor.BLUE, "Water Tank", new BoundingRectangle(79, 25, FluidTankPiece.Companion.getWIDTH(), FluidTankPiece.Companion.getHEIGHT()));
        Fluid fluid2 = FluidRegistry.LAVA;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"FluidRegistry.LAVA");
        this.lavaTank = super.addFluidTank(fluid2, 5000, EnumDyeColor.RED, "Lava Tank", new BoundingRectangle(97, 25, FluidTankPiece.Companion.getWIDTH(), FluidTankPiece.Companion.getHEIGHT()));
        ItemStackHandler itemStackHandler = this.outputs = (ItemStackHandler)new ItemStackHandler(this, 3){
            final /* synthetic */ FluidSolidifierEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputs");
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(151, 25, 18, 54)){
            final /* synthetic */ FluidSolidifierEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return false;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler2 = this.outputs;
        if (itemStackHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputs");
        }
        super.addInventoryToStorage(itemStackHandler2, "inv_outputs");
    }

    protected boolean shouldAddFluidItemsInventory() {
        return true;
    }

    @NotNull
    protected BoundingRectangle getFluidItemsBoundingBox() {
        return new BoundingRectangle(61, 25, FluidTankPiece.Companion.getWIDTH(), FluidTankPiece.Companion.getHEIGHT());
    }

    protected void addFluidItemsBackground(@NotNull List<IGuiContainerPiece> pieces, @NotNull BoundingRectangle box) {
        Intrinsics.checkParameterIsNotNull(pieces, (String)"pieces");
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 54, Textures.MACHINES_TEXTURES.getResource(), 6, 44));
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(115, 32, 36, 40, Textures.MACHINES_TEXTURES.getResource(), 61, 43));
        pieces.add((IGuiContainerPiece)new ToggleButtonPiece(this, 125, 44, 16, 16){
            final /* synthetic */ FluidSolidifierEntity this$0;

            protected int getCurrentState() {
                return 0;
            }

            protected void renderState(@NotNull BasicTeslaGuiContainer<?> container, int state, @NotNull BoundingRectangle box) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
                super.renderItemStack(container, FluidSolidifierEntity.access$getResultType$p(this.this$0).getResultStack(), box);
            }

            protected void clicked() {
                FluidSolidifierEntity.access$setResultType$p(this.this$0, FluidSolidifierResult.Companion.fromStateIndex((FluidSolidifierEntity.access$getResultType$p(this.this$0).getStateIndex() + 1) % ((Object[])FluidSolidifierResult.values()).length));
                NBTTagCompound nbt = this.this$0.setupSpecialNBTMessage("SET_RESULT_TYPE");
                nbt.func_74768_a("result_type", FluidSolidifierEntity.access$getResultType$p(this.this$0).getStateIndex());
                TeslaCoreLib.INSTANCE.getNetwork().sendToServer((IMessage)new SimpleNBTMessage((TileEntity)this.this$0, nbt));
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                if (!BasicContainerGuiPiece.Companion.isInside(container, (IGuiContainerPiece)this, mouseX, mouseY)) {
                    return;
                }
                ArrayList lines = Lists.newArrayList();
                FluidSolidifierResult result = FluidSolidifierEntity.access$getResultType$p(this.this$0);
                lines.add("Result: " + result.getResultStack().func_82833_r());
                lines.add("Water: " + result.getWaterMbConsumed() + " mb (min: " + result.getWaterMbMin() + " mb)");
                lines.add("Lava: " + result.getLavaMbConsumed() + " mb (min: " + result.getLavaMbMin() + " mb)");
                lines.add("Time: " + (float)result.getTicksRequired() / 20.0f + " s (~ " + (long)result.getTicksRequired() * this.this$0.getWorkEnergyTick() + " T)");
                ArrayList arrayList = lines;
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"lines");
                container.drawTooltip((List)arrayList, mouseX - guiX, mouseY - guiY);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        return pieces;
    }

    @NotNull
    public List<TileEntitySpecialRenderer<? super TileEntity>> getRenderers() {
        List list = super.getRenderers();
        list.add(DualTankEntityRenderer.INSTANCE);
        return list;
    }

    @Override
    @NotNull
    public List<TankInfo> getTanks() {
        Object[] objectArray = new TankInfo[2];
        IFluidTank iFluidTank = this.waterTank;
        if (iFluidTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
        }
        FluidStack fluidStack = iFluidTank.getFluid();
        IFluidTank iFluidTank2 = this.waterTank;
        if (iFluidTank2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
        }
        objectArray[0] = new TankInfo(6.0, 6.0, fluidStack, iFluidTank2.getCapacity());
        IFluidTank iFluidTank3 = this.lavaTank;
        if (iFluidTank3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lavaTank");
        }
        FluidStack fluidStack2 = iFluidTank3.getFluid();
        IFluidTank iFluidTank4 = this.lavaTank;
        if (iFluidTank4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lavaTank");
        }
        objectArray[1] = new TankInfo(20.0, 6.0, fluidStack2, iFluidTank4.getCapacity());
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        if (compound.func_74764_b("result_type")) {
            this.resultType = FluidSolidifierResult.Companion.fromStateIndex(compound.func_74762_e("result_type"));
        }
        if (compound.func_74764_b("work_result")) {
            this.lastWorkResult = FluidSolidifierResult.Companion.fromStateIndex(compound.func_74762_e("work_result"));
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74768_a("result_type", this.resultType.getStateIndex());
        if (this.lastWorkResult != null) {
            FluidSolidifierResult fluidSolidifierResult = this.lastWorkResult;
            if (fluidSolidifierResult == null) {
                Intrinsics.throwNpe();
            }
            nbt.func_74768_a("work_result", fluidSolidifierResult.getStateIndex());
        }
        return nbt;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        if (messageType != null && Intrinsics.areEqual((Object)messageType, (Object)"SET_RESULT_TYPE")) {
            this.resultType = FluidSolidifierResult.Companion.fromStateIndex(compound.func_74762_e("result_type"));
            this.func_70296_d();
        }
        return super.processClientMessage(messageType, compound);
    }

    protected int getEnergyForWork() {
        FluidSolidifierResult fluidSolidifierResult = this.lastWorkResult = this.resultType;
        if (fluidSolidifierResult == null) {
            Intrinsics.throwNpe();
        }
        return fluidSolidifierResult.getTicksRequired() * this.getEnergyForWorkRate();
    }

    protected float performWork() {
        block29: {
            ItemStack remaining;
            boolean lavaRequired;
            boolean waterRequired;
            block31: {
                FluidStack lava;
                FluidStack fluidStack;
                block30: {
                    FluidStack water;
                    FluidStack fluidStack2;
                    boolean hasLava;
                    boolean hasWater;
                    if (this.lastWorkResult == null) {
                        return 0.0f;
                    }
                    IFluidTank iFluidTank = this.waterTank;
                    if (iFluidTank == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
                    }
                    int n = iFluidTank.getFluidAmount();
                    FluidSolidifierResult fluidSolidifierResult = this.lastWorkResult;
                    if (fluidSolidifierResult == null) {
                        Intrinsics.throwNpe();
                    }
                    boolean bl = hasWater = n >= fluidSolidifierResult.getWaterMbMin();
                    if (!hasWater) break block29;
                    IFluidTank iFluidTank2 = this.lavaTank;
                    if (iFluidTank2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lavaTank");
                    }
                    int n2 = iFluidTank2.getFluidAmount();
                    FluidSolidifierResult fluidSolidifierResult2 = this.lastWorkResult;
                    if (fluidSolidifierResult2 == null) {
                        Intrinsics.throwNpe();
                    }
                    boolean bl2 = hasLava = n2 >= fluidSolidifierResult2.getLavaMbMin();
                    if (!hasLava) break block29;
                    FluidSolidifierResult fluidSolidifierResult3 = this.lastWorkResult;
                    if (fluidSolidifierResult3 == null) {
                        Intrinsics.throwNpe();
                    }
                    boolean bl3 = waterRequired = fluidSolidifierResult3.getWaterMbConsumed() > 0;
                    if (waterRequired) {
                        IFluidTank iFluidTank3 = this.waterTank;
                        if (iFluidTank3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
                        }
                        FluidSolidifierResult fluidSolidifierResult4 = this.lastWorkResult;
                        if (fluidSolidifierResult4 == null) {
                            Intrinsics.throwNpe();
                        }
                        fluidStack2 = iFluidTank3.drain(fluidSolidifierResult4.getWaterMbConsumed(), false);
                    } else {
                        fluidStack2 = water = null;
                    }
                    if (!waterRequired) break block30;
                    if (water == null) break block29;
                    int n3 = water.amount;
                    FluidSolidifierResult fluidSolidifierResult5 = this.lastWorkResult;
                    if (fluidSolidifierResult5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n3 != fluidSolidifierResult5.getWaterMbConsumed()) break block29;
                }
                FluidSolidifierResult fluidSolidifierResult = this.lastWorkResult;
                if (fluidSolidifierResult == null) {
                    Intrinsics.throwNpe();
                }
                boolean bl = lavaRequired = fluidSolidifierResult.getLavaMbConsumed() > 0;
                if (lavaRequired) {
                    IFluidTank iFluidTank = this.lavaTank;
                    if (iFluidTank == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lavaTank");
                    }
                    FluidSolidifierResult fluidSolidifierResult6 = this.lastWorkResult;
                    if (fluidSolidifierResult6 == null) {
                        Intrinsics.throwNpe();
                    }
                    fluidStack = iFluidTank.drain(fluidSolidifierResult6.getLavaMbConsumed(), false);
                } else {
                    fluidStack = lava = null;
                }
                if (!lavaRequired) break block31;
                if (lava == null) break block29;
                int n = lava.amount;
                FluidSolidifierResult fluidSolidifierResult7 = this.lastWorkResult;
                if (fluidSolidifierResult7 == null) {
                    Intrinsics.throwNpe();
                }
                if (n != fluidSolidifierResult7.getLavaMbConsumed()) break block29;
            }
            ItemStackHandler itemStackHandler = this.outputs;
            if (itemStackHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputs");
            }
            IItemHandler iItemHandler = (IItemHandler)itemStackHandler;
            FluidSolidifierResult fluidSolidifierResult = this.lastWorkResult;
            if (fluidSolidifierResult == null) {
                Intrinsics.throwNpe();
            }
            if ((remaining = ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)fluidSolidifierResult.getResultStack().func_77946_l(), (boolean)false)).func_190926_b()) {
                if (waterRequired) {
                    IFluidTank iFluidTank = this.waterTank;
                    if (iFluidTank == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"waterTank");
                    }
                    FluidSolidifierResult fluidSolidifierResult8 = this.lastWorkResult;
                    if (fluidSolidifierResult8 == null) {
                        Intrinsics.throwNpe();
                    }
                    iFluidTank.drain(fluidSolidifierResult8.getWaterMbConsumed(), true);
                }
                if (lavaRequired) {
                    IFluidTank iFluidTank = this.lavaTank;
                    if (iFluidTank == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lavaTank");
                    }
                    FluidSolidifierResult fluidSolidifierResult9 = this.lastWorkResult;
                    if (fluidSolidifierResult9 == null) {
                        Intrinsics.throwNpe();
                    }
                    iFluidTank.drain(fluidSolidifierResult9.getLavaMbConsumed(), true);
                }
                this.lastWorkResult = null;
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public FluidSolidifierEntity() {
        super(FluidSolidifierEntity.class.getName().hashCode());
    }

    @NotNull
    public static final /* synthetic */ FluidSolidifierResult access$getResultType$p(FluidSolidifierEntity $this) {
        return $this.resultType;
    }

    public static final /* synthetic */ void access$setResultType$p(FluidSolidifierEntity $this, @NotNull FluidSolidifierResult fluidSolidifierResult) {
        $this.resultType = fluidSolidifierResult;
    }
}

