/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.incinerator;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.gui.GeneratorBurnPiece;
import net.ndrei.teslapoweredthingies.gui.IWorkItemProvider;
import net.ndrei.teslapoweredthingies.gui.ItemStackPiece;
import net.ndrei.teslapoweredthingies.machines.BaseThingyGenerator;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/incinerator/IncineratorEntity;", "Lnet/ndrei/teslapoweredthingies/machines/BaseThingyGenerator;", "Lnet/ndrei/teslapoweredthingies/gui/IWorkItemProvider;", "()V", "currentItem", "Lnet/minecraftforge/items/ItemStackHandler;", "energyFillRate", "", "getEnergyFillRate", "()J", "energyOutputRate", "getEnergyOutputRate", "inputs", "outputs", "workItem", "Lnet/minecraft/item/ItemStack;", "getWorkItem", "()Lnet/minecraft/item/ItemStack;", "consumeFuel", "fuelConsumed", "", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "initializeInventories", "teslathingies_main"})
public final class IncineratorEntity
extends BaseThingyGenerator
implements IWorkItemProvider {
    private ItemStackHandler inputs;
    private ItemStackHandler outputs;
    private ItemStackHandler currentItem;

    protected void initializeInventories() {
        super.initializeInventories();
        ItemStackHandler itemStackHandler = this.inputs = (ItemStackHandler)new ItemStackHandler(this, 1){
            final /* synthetic */ IncineratorEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(61, 43, 18, 18)){
            final /* synthetic */ IncineratorEntity this$0;

            public boolean canExtractItem(int slot) {
                return false;
            }

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                if (stack.func_190926_b()) {
                    return false;
                }
                return IncineratorRecipes.INSTANCE.isFuel(stack);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler2 = this.inputs;
        if (itemStackHandler2 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler2, "inv_inputs");
        ItemStackHandler itemStackHandler3 = this.outputs = (ItemStackHandler)new ItemStackHandler(this, 3){
            final /* synthetic */ IncineratorEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler3 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler3, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(133, 25, 18, 54)){
            final /* synthetic */ IncineratorEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return false;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler4 = this.outputs;
        if (itemStackHandler4 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler4, "inv_outputs");
        ItemStackHandler itemStackHandler5 = this.currentItem = (ItemStackHandler)new ItemStackHandler(this, 1){
            final /* synthetic */ IncineratorEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler5 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler5, "inv_current");
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(79, 41, 54, 22, Textures.MACHINES_TEXTURES.getResource(), 24, 4));
        pieces.add((IGuiContainerPiece)new GeneratorBurnPiece(99, 64, this));
        pieces.add((IGuiContainerPiece)new ItemStackPiece(this, 95, 41, 22, 22, this){
            final /* synthetic */ IncineratorEntity this$0;

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                List<String> lines = GeneratorBurnPiece.Companion.getTooltipLines(this.this$0);
                if (lines != null && lines.size() > 0) {
                    container.drawTooltip(lines, mouseX - guiX, mouseY - guiY);
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, 0.0f, 32, null);
            }
        });
        return pieces;
    }

    @Override
    @NotNull
    public ItemStack getWorkItem() {
        ItemStack itemStack;
        if (this.currentItem == null) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
        } else {
            ItemStackHandler itemStackHandler = this.currentItem;
            if (itemStackHandler == null) {
                Intrinsics.throwNpe();
            }
            ItemStack itemStack3 = itemStackHandler.getStackInSlot(0);
            itemStack = itemStack3;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"this.currentItem!!.getStackInSlot(0)");
        }
        return itemStack;
    }

    protected long consumeFuel() {
        ItemStackHandler itemStackHandler = this.currentItem;
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        if (itemStackHandler.getStackInSlot(0).func_190926_b()) {
            ItemStack stack;
            ItemStackHandler itemStackHandler2 = this.inputs;
            if (itemStackHandler2 == null) {
                Intrinsics.throwNpe();
            }
            if (!(stack = itemStackHandler2.extractItem(0, 1, true)).func_190926_b()) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                long power = IncineratorRecipes.INSTANCE.getPower(itemStack);
                if (power > (long)0) {
                    ItemStackHandler itemStackHandler3 = this.inputs;
                    if (itemStackHandler3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(stack = itemStackHandler3.extractItem(0, 1, false)).func_190926_b()) {
                        ItemStackHandler itemStackHandler4 = this.currentItem;
                        if (itemStackHandler4 == null) {
                            Intrinsics.throwNpe();
                        }
                        itemStackHandler4.setStackInSlot(0, stack);
                        return power;
                    }
                }
            }
        }
        return 0L;
    }

    protected void fuelConsumed() {
        ItemStack stack;
        ItemStackHandler itemStackHandler = this.currentItem;
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        if (!(stack = itemStackHandler.getStackInSlot(0)).func_190926_b()) {
            Item item2 = stack.func_77973_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"stack.item");
            SecondaryOutput[] secondary = IncineratorRecipes.INSTANCE.getSecondaryOutputs(item2);
            if (secondary != null && ((Object[])secondary).length > 0) {
                for (int i = 0; i < secondary.length; ++i) {
                    ItemStack thing;
                    SecondaryOutput so = secondary[i];
                    float chance = this.func_145831_w().field_73012_v.nextFloat();
                    if (!(chance <= so.getChance()) || (thing = so.getPossibleOutput()).func_190926_b()) continue;
                    ItemStack itemStack = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)this.outputs), (ItemStack)thing.func_77946_l(), (boolean)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemHandlerHelper.insert\u2026uts, thing.copy(), false)");
                    thing = itemStack;
                    if (!thing.func_190926_b()) {
                        BlockPos spawnPos = this.field_174879_c.func_177972_a(super.getFacing());
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), thing));
                    }
                    super.forceSync();
                }
            }
        }
        ItemStackHandler itemStackHandler2 = this.currentItem;
        if (itemStackHandler2 == null) {
            Intrinsics.throwNpe();
        }
        itemStackHandler2.setStackInSlot(0, ItemStack.field_190927_a);
    }

    protected long getEnergyOutputRate() {
        return 40L;
    }

    protected long getEnergyFillRate() {
        return 40L;
    }

    public IncineratorEntity() {
        super(IncineratorEntity.class.getName().hashCode());
    }
}

