/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.incinerator;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.items.AshItem;
import net.ndrei.teslapoweredthingies.machines.incinerator.IncineratorRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u001b\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/incinerator/IncineratorRecipes;", "", "()V", "VANILLA_BURN_TO_POWER_RATE", "", "recipes", "", "Lnet/ndrei/teslapoweredthingies/machines/incinerator/IncineratorRecipe;", "getPower", "input", "Lnet/minecraft/item/ItemStack;", "getRecipes", "", "getSecondaryOutputs", "", "Lnet/ndrei/teslapoweredthingies/common/SecondaryOutput;", "Lnet/minecraft/item/Item;", "(Lnet/minecraft/item/Item;)[Lnet/ndrei/teslapoweredthingies/common/SecondaryOutput;", "isFuel", "", "registerRecipes", "", "registerVanillaRecipe", "block", "Lnet/minecraft/block/Block;", "secondary", "item", "stack", "teslathingies_main"})
public final class IncineratorRecipes {
    private static final long VANILLA_BURN_TO_POWER_RATE = 10L;
    private static final List<IncineratorRecipe> recipes;
    public static final IncineratorRecipes INSTANCE;

    public final void registerRecipes() {
        recipes.clear();
        Item item2 = Items.field_151044_h;
        Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"Items.COAL");
        this.registerVanillaRecipe(item2, new SecondaryOutput(0.02f, (Item)AshItem.INSTANCE));
        Block block = Blocks.field_150402_ci;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.COAL_BLOCK");
        this.registerVanillaRecipe(block, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block2 = Blocks.field_150344_f;
        Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"Blocks.PLANKS");
        this.registerVanillaRecipe(block2, new SecondaryOutput(0.1f, (Item)AshItem.INSTANCE));
        Block block3 = Blocks.field_150364_r;
        Intrinsics.checkExpressionValueIsNotNull((Object)block3, (String)"Blocks.LOG");
        this.registerVanillaRecipe(block3, new SecondaryOutput(0.15f, (Item)AshItem.INSTANCE));
        Block block4 = Blocks.field_150363_s;
        Intrinsics.checkExpressionValueIsNotNull((Object)block4, (String)"Blocks.LOG2");
        this.registerVanillaRecipe(block4, new SecondaryOutput(0.15f, (Item)AshItem.INSTANCE));
        Block block5 = Blocks.field_150325_L;
        Intrinsics.checkExpressionValueIsNotNull((Object)block5, (String)"Blocks.WOOL");
        this.registerVanillaRecipe(block5, new SecondaryOutput(0.01f, (Item)AshItem.INSTANCE));
        Block block6 = Blocks.field_150345_g;
        Intrinsics.checkExpressionValueIsNotNull((Object)block6, (String)"Blocks.SAPLING");
        this.registerVanillaRecipe(block6, new SecondaryOutput(0.15f, (Item)AshItem.INSTANCE));
        Block block7 = Blocks.field_180405_aT;
        Intrinsics.checkExpressionValueIsNotNull((Object)block7, (String)"Blocks.ACACIA_FENCE");
        this.registerVanillaRecipe(block7, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block8 = Blocks.field_180404_aQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)block8, (String)"Blocks.BIRCH_FENCE");
        this.registerVanillaRecipe(block8, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block9 = Blocks.field_180403_aR;
        Intrinsics.checkExpressionValueIsNotNull((Object)block9, (String)"Blocks.JUNGLE_FENCE");
        this.registerVanillaRecipe(block9, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block10 = Blocks.field_180407_aO;
        Intrinsics.checkExpressionValueIsNotNull((Object)block10, (String)"Blocks.OAK_FENCE");
        this.registerVanillaRecipe(block10, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block11 = Blocks.field_180408_aP;
        Intrinsics.checkExpressionValueIsNotNull((Object)block11, (String)"Blocks.SPRUCE_FENCE");
        this.registerVanillaRecipe(block11, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block12 = Blocks.field_180406_aS;
        Intrinsics.checkExpressionValueIsNotNull((Object)block12, (String)"Blocks.DARK_OAK_FENCE");
        this.registerVanillaRecipe(block12, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block13 = Blocks.field_180387_bt;
        Intrinsics.checkExpressionValueIsNotNull((Object)block13, (String)"Blocks.ACACIA_FENCE_GATE");
        this.registerVanillaRecipe(block13, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block14 = Blocks.field_180392_bq;
        Intrinsics.checkExpressionValueIsNotNull((Object)block14, (String)"Blocks.BIRCH_FENCE_GATE");
        this.registerVanillaRecipe(block14, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block15 = Blocks.field_180386_br;
        Intrinsics.checkExpressionValueIsNotNull((Object)block15, (String)"Blocks.JUNGLE_FENCE_GATE");
        this.registerVanillaRecipe(block15, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block16 = Blocks.field_180390_bo;
        Intrinsics.checkExpressionValueIsNotNull((Object)block16, (String)"Blocks.OAK_FENCE_GATE");
        this.registerVanillaRecipe(block16, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block17 = Blocks.field_180391_bp;
        Intrinsics.checkExpressionValueIsNotNull((Object)block17, (String)"Blocks.SPRUCE_FENCE_GATE");
        this.registerVanillaRecipe(block17, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Block block18 = Blocks.field_180385_bs;
        Intrinsics.checkExpressionValueIsNotNull((Object)block18, (String)"Blocks.DARK_OAK_FENCE_GATE");
        this.registerVanillaRecipe(block18, new SecondaryOutput(0.05f, (Item)AshItem.INSTANCE));
        Item item3 = Items.field_151055_y;
        Intrinsics.checkExpressionValueIsNotNull((Object)item3, (String)"Items.STICK");
        this.registerVanillaRecipe(item3, new SecondaryOutput(0.01f, (Item)AshItem.INSTANCE));
        Item item4 = Items.field_151053_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)item4, (String)"Items.WOODEN_AXE");
        this.registerVanillaRecipe(item4, new SecondaryOutput(0.03f, (Item)AshItem.INSTANCE));
        Item item5 = Items.field_151017_I;
        Intrinsics.checkExpressionValueIsNotNull((Object)item5, (String)"Items.WOODEN_HOE");
        this.registerVanillaRecipe(item5, new SecondaryOutput(0.03f, (Item)AshItem.INSTANCE));
        Item item6 = Items.field_151039_o;
        Intrinsics.checkExpressionValueIsNotNull((Object)item6, (String)"Items.WOODEN_PICKAXE");
        this.registerVanillaRecipe(item6, new SecondaryOutput(0.03f, (Item)AshItem.INSTANCE));
        Item item7 = Items.field_151038_n;
        Intrinsics.checkExpressionValueIsNotNull((Object)item7, (String)"Items.WOODEN_SHOVEL");
        this.registerVanillaRecipe(item7, new SecondaryOutput(0.03f, (Item)AshItem.INSTANCE));
        Item item8 = Items.field_151041_m;
        Intrinsics.checkExpressionValueIsNotNull((Object)item8, (String)"Items.WOODEN_SWORD");
        this.registerVanillaRecipe(item8, new SecondaryOutput(0.03f, (Item)AshItem.INSTANCE));
    }

    private final void registerVanillaRecipe(Block block, SecondaryOutput secondary) {
        Item item2 = Item.func_150898_a((Block)block);
        Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"Item.getItemFromBlock(block)");
        INSTANCE.registerVanillaRecipe(item2, secondary);
    }

    private final void registerVanillaRecipe(Item item2, SecondaryOutput secondary) {
        this.registerVanillaRecipe(new ItemStack(item2), secondary);
    }

    private final void registerVanillaRecipe(ItemStack stack, SecondaryOutput secondary) {
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burnTime > 0) {
            long power = (long)burnTime * VANILLA_BURN_TO_POWER_RATE;
            List<IncineratorRecipe> list = recipes;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(new IncineratorRecipe(stack, power, secondary));
        }
    }

    public final boolean isFuel(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        if (TileEntityFurnace.func_145954_b((ItemStack)new ItemStack(input.func_77973_b()))) {
            return true;
        }
        if (recipes != null) {
            List<IncineratorRecipe> list = recipes;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (IncineratorRecipe recipe : list) {
                if (!recipe.getInput().func_185136_b(input)) continue;
                return true;
            }
        }
        return false;
    }

    public final long getPower(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (recipes != null) {
            List<IncineratorRecipe> list = recipes;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (IncineratorRecipe recipe : list) {
                if (!recipe.getInput().func_185136_b(input)) continue;
                return recipe.getPower();
            }
        }
        return this.isFuel(input) ? VANILLA_BURN_TO_POWER_RATE * (long)TileEntityFurnace.func_145952_a((ItemStack)input) : 0L;
    }

    @Nullable
    public final SecondaryOutput[] getSecondaryOutputs(@NotNull Item input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (recipes != null) {
            ItemStack testStack = new ItemStack(input);
            List<IncineratorRecipe> list = recipes;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (IncineratorRecipe recipe : list) {
                if (!recipe.getInput().func_185136_b(testStack)) continue;
                return recipe.getSecondaryOutputs();
            }
        }
        return null;
    }

    @NotNull
    public final List<IncineratorRecipe> getRecipes() {
        return CollectionsKt.toList((Iterable)recipes);
    }

    private IncineratorRecipes() {
        INSTANCE = this;
        VANILLA_BURN_TO_POWER_RATE = 10L;
        recipes = new ArrayList();
    }

    static {
        new IncineratorRecipes();
    }
}

