/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.itemliquefier;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.FluidTankPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.FluidStorage;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.gui.IWorkItemProvider;
import net.ndrei.teslapoweredthingies.gui.ItemStackPiece;
import net.ndrei.teslapoweredthingies.machines.BaseThingyMachine;
import net.ndrei.teslapoweredthingies.machines.itemliquefier.LiquefierRecipe;
import net.ndrei.teslapoweredthingies.machines.itemliquefier.LiquefierRecipes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0019H\u0014J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001bH\u0014J\u0010\u0010%\u001a\u00020#2\u0006\u0010\"\u001a\u00020#H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/itemliquefier/ItemLiquefierEntity;", "Lnet/ndrei/teslapoweredthingies/machines/BaseThingyMachine;", "Lnet/ndrei/teslapoweredthingies/gui/IWorkItemProvider;", "()V", "currentRecipe", "Lnet/ndrei/teslapoweredthingies/machines/itemliquefier/LiquefierRecipe;", "energyForWork", "", "getEnergyForWork", "()I", "fluidOutputs", "Lnet/minecraftforge/items/ItemStackHandler;", "inputs", "lavaTank", "Lnet/minecraftforge/fluids/IFluidTank;", "workItem", "Lnet/minecraft/item/ItemStack;", "getWorkItem", "()Lnet/minecraft/item/ItemStack;", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "initializeInventories", "", "isEmptyFluidContainer", "", "stack", "isValidFluidContainer", "performWork", "", "processImmediateInventories", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "shouldAddFluidItemsInventory", "writeToNBT", "teslathingies_main"})
public final class ItemLiquefierEntity
extends BaseThingyMachine
implements IWorkItemProvider {
    private IFluidTank lavaTank;
    private ItemStackHandler inputs;
    private ItemStackHandler fluidOutputs;
    private LiquefierRecipe currentRecipe;

    protected void initializeInventories() {
        super.initializeInventories();
        super.ensureFluidItems();
        Fluid fluid = FluidRegistry.LAVA;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"FluidRegistry.LAVA");
        this.lavaTank = super.addFluidTank(fluid, 5000, EnumDyeColor.RED, "Fluid Tank", new BoundingRectangle(133, 25, FluidTankPiece.Companion.getWIDTH(), FluidTankPiece.Companion.getHEIGHT()));
        ItemStackHandler itemStackHandler = this.inputs = (ItemStackHandler)new ItemStackHandler(this, 3){
            final /* synthetic */ ItemLiquefierEntity this$0;

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(61, 25, 18, 54)){
            final /* synthetic */ ItemLiquefierEntity this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return !stack.func_190926_b() && LiquefierRecipes.INSTANCE.getRecipe(stack) != null;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        ItemStackHandler itemStackHandler2 = this.inputs;
        if (itemStackHandler2 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler2, "inv_inputs");
        BoundingRectangle box = new BoundingRectangle(151, 25, FluidTankPiece.Companion.getWIDTH(), FluidTankPiece.Companion.getHEIGHT());
        ItemStackHandler itemStackHandler3 = this.fluidOutputs = (ItemStackHandler)new ItemStackHandler(this, 2){
            final /* synthetic */ ItemLiquefierEntity this$0;

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : super.getSlotLimit(slot);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.func_70296_d();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler3 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, box, (IItemHandler)itemStackHandler3, EnumDyeColor.SILVER, "Fluid Output", box){
            final /* synthetic */ ItemLiquefierEntity this$0;
            final /* synthetic */ BoundingRectangle $box;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return slot == 0 && ItemLiquefierEntity.access$isValidFluidContainer(this.this$0, stack);
            }

            public boolean canExtractItem(int slot) {
                return slot != 0;
            }

            @NotNull
            public List<Slot> getSlots(@NotNull BasicTeslaContainer<?> container) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                List slots = new ArrayList<E>();
                BoundingRectangle box = this.getBoundingBox();
                slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 1, box.getLeft() + 1, box.getTop() + 1 + 36));
                return slots;
            }

            @NotNull
            public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                List pieces = new ArrayList<E>();
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), box.getWidth(), box.getHeight(), Textures.MACHINES_TEXTURES.getResource(), 98, 36));
                return pieces;
            }
            {
                this.this$0 = $outer;
                this.$box = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
        ItemStackHandler itemStackHandler4 = this.fluidOutputs;
        if (itemStackHandler4 == null) {
            Intrinsics.throwNpe();
        }
        super.addInventoryToStorage(itemStackHandler4, "inv_fluid_outputs");
    }

    private final boolean isValidFluidContainer(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IFluidTankProperties[] tanks;
            IFluidHandlerItem handler;
            Item item2 = stack.func_77973_b();
            if (item2 == Items.field_151069_bo || item2 == Items.field_151133_ar) {
                return true;
            }
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (tanks = handler.getTankProperties()) != null && ((Object[])tanks).length > 0) {
                for (int i = 0; i < tanks.length; ++i) {
                    FluidStack content;
                    IFluidTankProperties tank = tanks[i];
                    if (!tank.canFill() || (content = tank.getContents()) != null && (content.amount >= tank.getCapacity() || content.getFluid() != FluidRegistry.LAVA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(79, 41, 54, 22, Textures.MACHINES_TEXTURES.getResource(), 24, 4));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(99, 64, 14, 14, Textures.MACHINES_TEXTURES.getResource(), 44, 27));
        pieces.add((IGuiContainerPiece)new ItemStackPiece(96, 42, 20, 20, this, 0.0f, 32, null));
        return pieces;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.currentRecipe = compound.func_74764_b("currentRecipe") ? LiquefierRecipe.Companion.deserializeNBT(compound.func_74775_l("currentRecipe")) : (LiquefierRecipe)null;
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTTagCompound compound2 = compound;
        compound2 = super.func_189515_b(compound2);
        if (this.currentRecipe != null) {
            LiquefierRecipe liquefierRecipe = this.currentRecipe;
            if (liquefierRecipe == null) {
                Intrinsics.throwNpe();
            }
            compound2.func_74782_a("currentRecipe", (NBTBase)liquefierRecipe.serializeNBT());
        }
        return compound2;
    }

    @Override
    @NotNull
    public ItemStack getWorkItem() {
        if (this.currentRecipe != null) {
            LiquefierRecipe liquefierRecipe = this.currentRecipe;
            if (liquefierRecipe == null) {
                Intrinsics.throwNpe();
            }
            ItemStack itemStack = liquefierRecipe.getInput().func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.currentRecipe!!.input.copy()");
            return itemStack;
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    protected int getEnergyForWork() {
        return 6000;
    }

    protected float performWork() {
        float result = 0.0f;
        if (this.currentRecipe != null) {
            LiquefierRecipe liquefierRecipe = this.currentRecipe;
            if (liquefierRecipe == null) {
                Intrinsics.throwNpe();
            }
            FluidStack fluid = liquefierRecipe.getOutput().copy();
            IFluidTank iFluidTank = this.lavaTank;
            if (iFluidTank == null) {
                Intrinsics.throwNpe();
            }
            if (iFluidTank.fill(fluid, false) == fluid.amount) {
                IFluidTank iFluidTank2 = this.lavaTank;
                if (iFluidTank2 == null) {
                    Intrinsics.throwNpe();
                }
                iFluidTank2.fill(fluid, true);
                this.currentRecipe = null;
                result = 1.0f;
            }
        }
        return result;
    }

    protected void processImmediateInventories() {
        super.processImmediateInventories();
        ItemStackHandler itemStackHandler = this.fluidOutputs;
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        ItemStack stack = itemStackHandler.getStackInSlot(0);
        IFluidTank iFluidTank = this.lavaTank;
        if (iFluidTank == null) {
            Intrinsics.throwNpe();
        }
        int maxDrain = iFluidTank.getFluidAmount();
        if (!stack.func_190926_b() && maxDrain > 0 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            int toFill = Math.max(maxDrain, 1000);
            FluidStorage dummy = new FluidStorage();
            IFluidTank iFluidTank2 = this.lavaTank;
            if (iFluidTank2 == null) {
                Intrinsics.throwNpe();
            }
            dummy.addTank(iFluidTank2);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)dummy), (int)toFill, null, (boolean)true);
            if (result.isSuccess()) {
                stack = result.getResult();
                ItemStackHandler itemStackHandler2 = this.fluidOutputs;
                if (itemStackHandler2 == null) {
                    Intrinsics.throwNpe();
                }
                itemStackHandler2.setStackInSlot(0, stack);
            }
            if (!stack.func_190926_b()) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (!this.isEmptyFluidContainer(itemStack)) {
                    ItemStackHandler itemStackHandler3 = this.fluidOutputs;
                    if (itemStackHandler3 == null) {
                        Intrinsics.throwNpe();
                    }
                    ItemStackHandler itemStackHandler4 = this.fluidOutputs;
                    if (itemStackHandler4 == null) {
                        Intrinsics.throwNpe();
                    }
                    itemStackHandler3.setStackInSlot(0, itemStackHandler4.insertItem(1, stack, false));
                }
            }
        }
        if (this.currentRecipe == null) {
            ItemStackHandler itemStackHandler5 = this.inputs;
            if (itemStackHandler5 == null) {
                Intrinsics.throwNpe();
            }
            for (ItemStack input : ItemStackUtil.INSTANCE.getCombinedInventory((IItemHandler)itemStackHandler5)) {
                LiquefierRecipe recipe = LiquefierRecipes.INSTANCE.getRecipe(input);
                if (recipe == null) continue;
                FluidStack fluid = recipe.getOutput().copy();
                IFluidTank iFluidTank3 = this.lavaTank;
                if (iFluidTank3 == null) {
                    Intrinsics.throwNpe();
                }
                if (iFluidTank3.fill(fluid, false) != fluid.amount) continue;
                ItemStackHandler itemStackHandler6 = this.inputs;
                if (itemStackHandler6 == null) {
                    Intrinsics.throwNpe();
                }
                ItemStackUtil.INSTANCE.extractFromCombinedInventory((IItemHandler)itemStackHandler6, input, recipe.getInput().func_190916_E());
                this.currentRecipe = recipe;
                break;
            }
        }
    }

    private final boolean isEmptyFluidContainer(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid == null || fluid.amount == 0;
    }

    public ItemLiquefierEntity() {
        super(ItemLiquefierEntity.class.getName().hashCode());
    }

    public static final /* synthetic */ boolean access$isValidFluidContainer(ItemLiquefierEntity $this, @NotNull ItemStack stack) {
        return $this.isValidFluidContainer(stack);
    }
}

