/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.sewer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslacorelib.utils.BlockPosUtils;
import net.ndrei.teslapoweredthingies.fluids.SewageFluid;
import net.ndrei.teslapoweredthingies.machines.BaseXPCollectingMachine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lnet/ndrei/teslapoweredthingies/machines/sewer/SewerEntity;", "Lnet/ndrei/teslapoweredthingies/machines/BaseXPCollectingMachine;", "()V", "energyForWork", "", "getEnergyForWork", "()I", "energyForWorkRate", "getEnergyForWorkRate", "inputSlots", "getInputSlots", "outputSlots", "getOutputSlots", "sewageTank", "Lnet/minecraftforge/fluids/IFluidTank;", "xpOrbLookupCube", "Lnet/ndrei/teslacorelib/utils/BlockCube;", "getXpOrbLookupCube", "()Lnet/ndrei/teslacorelib/utils/BlockCube;", "acceptsFluidItem", "", "stack", "Lnet/minecraft/item/ItemStack;", "getWorkArea", "getWorkAreaColor", "initializeInventories", "", "performWorkInternal", "", "processFluidItems", "fluidItems", "Lnet/minecraftforge/items/ItemStackHandler;", "teslathingies_main"})
public final class SewerEntity
extends BaseXPCollectingMachine {
    private IFluidTank sewageTank;

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.sewageTank = super.addFluidTank((Fluid)SewageFluid.INSTANCE, 10000, EnumDyeColor.BROWN, "Sewage Tank", new BoundingRectangle(43, 25, 18, 54));
    }

    @Override
    protected int getInputSlots() {
        return 0;
    }

    @Override
    protected int getOutputSlots() {
        return 0;
    }

    @Override
    public int getWorkAreaColor() {
        return 16738816;
    }

    protected boolean acceptsFluidItem(@NotNull ItemStack stack) {
        IFluidHandlerItem handler;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && 1 == handler.fill(new FluidStack((Fluid)SewageFluid.INSTANCE, 1), false)) {
            return true;
        }
        return stack.func_77973_b() == Items.field_151133_ar;
    }

    protected void processFluidItems(@NotNull ItemStackHandler fluidItems) {
        Intrinsics.checkParameterIsNotNull((Object)fluidItems, (String)"fluidItems");
        ItemStack stack = fluidItems.getStackInSlot(0);
        ItemStack outputStack = fluidItems.getStackInSlot(1);
        if (!stack.func_190926_b() && outputStack.func_190926_b()) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            ItemStack input = ItemStackUtil.INSTANCE.copyWithSize(itemStack, 1);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)input, (IFluidHandler)((IFluidHandler)this.getFluidHandler()), (int)1000, null, (boolean)true);
            if (result.isSuccess()) {
                ItemStack itemStack2 = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
                ItemStackUtil.INSTANCE.shrink(itemStack2, 1);
                if (stack.func_190926_b()) {
                    fluidItems.setStackInSlot(0, ItemStack.field_190927_a);
                }
                fluidItems.setStackInSlot(1, result.getResult());
            }
        }
    }

    protected int getEnergyForWork() {
        return 20;
    }

    protected int getEnergyForWorkRate() {
        return 1;
    }

    @Override
    @NotNull
    public BlockCube getWorkArea() {
        return this.getWorkArea(EnumFacing.UP, 2);
    }

    @Override
    protected float performWorkInternal() {
        BlockCube cube = this.getWorkArea();
        int sewage = 0;
        for (EntityAnimal animal : this.func_145831_w().func_72872_a(EntityAnimal.class, cube.getBoundingBox())) {
            sewage += Math.round(animal.func_110138_aP());
        }
        if (sewage > 0) {
            IFluidTank iFluidTank = this.sewageTank;
            if (iFluidTank == null) {
                Intrinsics.throwNpe();
            }
            iFluidTank.fill(new FluidStack((Fluid)SewageFluid.INSTANCE, sewage), true);
        }
        return 1.0f;
    }

    @Override
    @NotNull
    protected BlockCube getXpOrbLookupCube() {
        BlockPos blockPos = this.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"this.getPos()");
        return BlockPosUtils.INSTANCE.getCube(blockPos, EnumFacing.UP, 4, 3);
    }

    public SewerEntity() {
        super(SewerEntity.class.getName().hashCode());
    }
}

