/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.treefarm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeFactory;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeLeafWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeLogWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeSaplingWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaSapling;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaTreeLeaf;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaTreeLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/treefarm/BaseModTreeFactory;", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeFactory;", "modId", "", "(Ljava/lang/String;)V", "leavesOreName", "getLeavesOreName", "()Ljava/lang/String;", "logOreName", "getLogOreName", "getModId", "saplingOreName", "getSaplingOreName", "getHarvestableLeaf", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeLeafWrapper;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "block", "Lnet/minecraft/block/state/IBlockState;", "getHarvestableLog", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeLogWrapper;", "getPlantableSapling", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeSaplingWrapper;", "stack", "Lnet/minecraft/item/ItemStack;", "teslathingies_main"})
public class BaseModTreeFactory
implements ITreeFactory {
    @NotNull
    private final String modId;

    @NotNull
    protected String getLogOreName() {
        return "logWood";
    }

    @NotNull
    protected String getLeavesOreName() {
        return "treeLeaves";
    }

    @NotNull
    protected String getSaplingOreName() {
        return "treeSapling";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ITreeLogWrapper getHarvestableLog(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState block) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            ItemStack stack = new ItemStack(block.func_177230_c());
            if (stack.func_190926_b()) return null;
            CharSequence charSequence = this.modId;
            if (!(charSequence == null || charSequence.length() == 0)) {
                ResourceLocation resourceLocation = block.func_177230_c().getRegistryName();
                if (!Intrinsics.areEqual((Object)(resourceLocation != null ? resourceLocation.func_110624_b() : null), (Object)this.modId)) return null;
            }
            int[] $receiver$iv = OreDictionary.getOreIDs((ItemStack)stack);
            int n = 0;
            while (n < $receiver$iv.length) {
                int element$iv = $receiver$iv[n];
                int it = element$iv;
                if (!Intrinsics.areEqual((Object)OreDictionary.getOreName((int)it), (Object)this.getLogOreName())) {
                    ++n;
                    continue;
                }
                break block3;
            }
            return null;
        }
        boolean bl = true;
        if (!bl) return null;
        ITreeLogWrapper iTreeLogWrapper = new VanillaTreeLog(world, pos);
        return iTreeLogWrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ITreeLeafWrapper getHarvestableLeaf(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState block) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            ItemStack stack = new ItemStack(block.func_177230_c());
            if (stack.func_190926_b()) return null;
            CharSequence charSequence = this.modId;
            if (!(charSequence == null || charSequence.length() == 0)) {
                ResourceLocation resourceLocation = block.func_177230_c().getRegistryName();
                if (!Intrinsics.areEqual((Object)(resourceLocation != null ? resourceLocation.func_110624_b() : null), (Object)this.modId)) return null;
            }
            int[] $receiver$iv = OreDictionary.getOreIDs((ItemStack)stack);
            int n = 0;
            while (n < $receiver$iv.length) {
                int element$iv = $receiver$iv[n];
                int it = element$iv;
                if (!Intrinsics.areEqual((Object)OreDictionary.getOreName((int)it), (Object)this.getLeavesOreName())) {
                    ++n;
                    continue;
                }
                break block3;
            }
            return null;
        }
        boolean bl = true;
        if (!bl) return null;
        ITreeLeafWrapper iTreeLeafWrapper = new VanillaTreeLeaf(world, pos);
        return iTreeLeafWrapper;
    }

    @Override
    @Nullable
    public ITreeSaplingWrapper getPlantableSapling(@NotNull ItemStack stack) {
        block4: {
            boolean bl;
            block3: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                    if (stack.func_190926_b()) break block4;
                    CharSequence charSequence = this.modId;
                    if (charSequence == null || charSequence.length() == 0) break block5;
                    ResourceLocation resourceLocation = stack.func_77973_b().getRegistryName();
                    if (!Intrinsics.areEqual((Object)(resourceLocation != null ? resourceLocation.func_110624_b() : null), (Object)this.modId)) break block4;
                }
                int[] $receiver$iv = OreDictionary.getOreIDs((ItemStack)stack);
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    int element$iv = $receiver$iv[i];
                    int it = element$iv;
                    if (!Intrinsics.areEqual((Object)OreDictionary.getOreName((int)it), (Object)this.getSaplingOreName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return new VanillaSapling(stack);
            }
        }
        return null;
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    public BaseModTreeFactory(@NotNull String modId) {
        Intrinsics.checkParameterIsNotNull((Object)modId, (String)"modId");
        this.modId = modId;
    }
}

