/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.treefarm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.netsync.ITeslaCorePackets;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslapoweredthingies.TeslaThingiesMod;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.common.GuiPieceSide;
import net.ndrei.teslapoweredthingies.machines.ElectricFarmMachine;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeBlockWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeLeafWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeSaplingWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.TreeScanner;
import net.ndrei.teslapoweredthingies.machines.treefarm.TreeWrapperFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001a\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/ndrei/teslapoweredthingies/machines/treefarm/TreeFarmEntity;", "Lnet/ndrei/teslapoweredthingies/machines/ElectricFarmMachine;", "()V", "lastScan", "", "lockableInputLockPosition", "Lnet/ndrei/teslapoweredthingies/common/GuiPieceSide;", "getLockableInputLockPosition", "()Lnet/ndrei/teslapoweredthingies/common/GuiPieceSide;", "pendingBlocks", "scannedBlocks", "scanner", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/TreeScanner;", "acceptsInputStack", "", "slot", "stack", "Lnet/minecraft/item/ItemStack;", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "getWorkAreaColor", "performWork", "", "processClientMessage", "Lnet/ndrei/teslacorelib/netsync/SimpleNBTMessage;", "messageType", "", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "processServerMessage", "Companion", "teslathingies_main"})
public final class TreeFarmEntity
extends ElectricFarmMachine {
    private final TreeScanner scanner = new TreeScanner();
    private int lastScan;
    private int scannedBlocks;
    private int pendingBlocks;
    private static final float SCAN_PERCENT = 0.025f;
    private static final float BREAK_PERCENT = 0.05f;
    private static final float PLANT_PERCENT = 0.1f;
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean acceptsInputStack(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Items.field_151097_aZ)) {
            return true;
        }
        return TreeWrapperFactory.INSTANCE.getSaplingWrapper(stack) != null;
    }

    @Override
    @NotNull
    protected GuiPieceSide getLockableInputLockPosition() {
        return GuiPieceSide.LEFT;
    }

    @Override
    public int getWorkAreaColor() {
        return 5046016;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List<IGuiContainerPiece> list = super.getGuiContainerPieces(container);
        list.add((IGuiContainerPiece)new BasicRenderedGuiPiece(this, 45, 45, 14, 14, Textures.MACHINES_TEXTURES.getResource(), 100, 96){
            final /* synthetic */ TreeFarmEntity this$0;

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (this.isInside(container, mouseX, mouseY)) {
                    container.drawTooltip(TreeFarmEntity.access$getScannedBlocks$p(this.this$0) == 0 && TreeFarmEntity.access$getPendingBlocks$p(this.this$0) == 0 ? CollectionsKt.listOf((Object)(TextFormatting.GRAY + "waiting for a tree")) : CollectionsKt.listOf((Object[])new String[]{TextFormatting.RED + TreeFarmEntity.access$getScannedBlocks$p(this.this$0) + " blocks scanned", TextFormatting.GREEN + TreeFarmEntity.access$getPendingBlocks$p(this.this$0) + " blocks pending", TextFormatting.GRAY + "last scan: " + TreeFarmEntity.access$getLastScan$p(this.this$0)}), this.getLeft() + this.getWidth(), this.getTop());
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        });
        return list;
    }

    @Nullable
    protected SimpleNBTMessage processServerMessage(@NotNull String messageType, @NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)messageType, (String)"messageType");
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        SimpleNBTMessage result = super.processServerMessage(messageType, compound);
        String string = messageType;
        switch (string.hashCode()) {
            case 779746440: {
                if (!string.equals("update_scanner")) break;
                this.scannedBlocks = compound.func_150297_b("blocks", 3) ? compound.func_74762_e("blocks") : 0;
                this.pendingBlocks = compound.func_150297_b("pending", 3) ? compound.func_74762_e("pending") : 0;
                this.lastScan = compound.func_150297_b("last", 3) ? compound.func_74762_e("last") : 0;
            }
        }
        return result;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        return super.processClientMessage(messageType, compound);
    }

    /*
     * WARNING - void declaration
     */
    protected float performWork() {
        ItemStackHandler inputs;
        List saplings;
        Collection $i$a$1$also;
        EnumFacing facing = super.getFacing();
        float result = 0.0f;
        EnumFacing enumFacing = facing.func_176734_d();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing.getOpposite()");
        BlockCube cube = this.getWorkArea(enumFacing, 1);
        World world = this.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"this.getWorld()");
        int scanned = Math.round((result += this.scanner.scan(world, cube, 0.025f, 1.0f)) / 0.025f);
        if (this.scannedBlocks != this.scanner.blockCount() || this.pendingBlocks != this.scanner.pendingCount() || this.lastScan != scanned) {
            SimpleNBTMessage simpleNBTMessage;
            this.scannedBlocks = this.scanner.blockCount();
            this.pendingBlocks = this.scanner.pendingCount();
            this.lastScan = scanned;
            NBTTagCompound nBTTagCompound = this.setupSpecialNBTMessage("update_scanner");
            TileEntity tileEntity = (TileEntity)this;
            SimpleNBTMessage simpleNBTMessage2 = simpleNBTMessage;
            SimpleNBTMessage simpleNBTMessage3 = simpleNBTMessage;
            ITeslaCorePackets iTeslaCorePackets = TeslaCoreLib.INSTANCE.getNetwork();
            NBTTagCompound it = nBTTagCompound;
            it.func_74768_a("blocks", this.scannedBlocks);
            it.func_74768_a("pending", this.pendingBlocks);
            it.func_74768_a("last", this.lastScan);
            NBTTagCompound nBTTagCompound2 = nBTTagCompound;
            simpleNBTMessage2(tileEntity, nBTTagCompound2);
            iTeslaCorePackets.send((IMessage)simpleNBTMessage3);
        }
        ItemStackHandler itemStackHandler = this.getInStackHandler();
        if (itemStackHandler == null) {
            Intrinsics.throwNpe();
        }
        if (!($i$a$1$also = (Collection)(saplings = CollectionsKt.toMutableList((Collection)TreeWrapperFactory.INSTANCE.getSaplingWrappers(ItemStackUtil.INSTANCE.getCombinedInventory((IItemHandler)(inputs = itemStackHandler)))))).isEmpty()) {
            block0: for (BlockPos pos : cube) {
                if (result > 0.9f) break;
                if (!this.func_145831_w().func_175623_d(pos)) continue;
                for (ITreeSaplingWrapper sapling : saplings) {
                    World world2 = this.func_145831_w();
                    Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"this.getWorld()");
                    if (!sapling.canPlant(world2, pos)) continue;
                    World world3 = this.func_145831_w();
                    Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"this.getWorld()");
                    int planted = sapling.plant(world3, pos);
                    if (planted <= 0) continue;
                    ItemStack original = sapling.getStack();
                    int extracted = ItemStackUtil.INSTANCE.extractFromCombinedInventory((IItemHandler)inputs, original, planted);
                    if (original.func_190916_E() <= extracted) {
                        saplings.remove(sapling);
                    } else {
                        ItemStackUtil.INSTANCE.shrink(original, extracted);
                    }
                    result += 0.1f;
                    continue block0;
                }
            }
        }
        boolean hasShears = false;
        int shearsSlot = 0;
        int sapling = 0;
        int n = inputs.getSlots() - 1;
        if (sapling <= n) {
            while (true) {
                void index;
                ItemStack stack;
                if (!(stack = inputs.getStackInSlot((int)index)).func_190926_b() && stack.func_77973_b() == Items.field_151097_aZ) {
                    hasShears = true;
                    shearsSlot = index;
                    break;
                }
                if (index == n) break;
                ++index;
            }
        }
        ArrayList items = Lists.newArrayList();
        while (result <= 0.95f && this.scanner.blockCount() > 0) {
            BlockPos pos = this.scanner.popScannedPos();
            if (pos == null) continue;
            World world4 = this.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull((Object)world4, (String)"this.getWorld()");
            ITreeBlockWrapper wrapper = TreeWrapperFactory.INSTANCE.getBlockWrapper(world4, pos, null);
            if (wrapper instanceof ITreeLeafWrapper) {
                if (hasShears) {
                    items.addAll((Collection)((ITreeLeafWrapper)wrapper).shearBlock());
                    if (shearsSlot >= 0 && inputs.getStackInSlot(shearsSlot).func_96631_a(1, this.func_145831_w().field_73012_v, (EntityPlayerMP)TeslaThingiesMod.INSTANCE.getFakePlayer(this.func_145831_w()))) {
                        inputs.setStackInSlot(shearsSlot, ItemStack.field_190927_a);
                        shearsSlot = -1;
                        hasShears = false;
                    }
                } else {
                    items.addAll((Collection)wrapper.breakBlock(1));
                }
            } else if (wrapper != null) {
                items.addAll((Collection)wrapper.breakBlock(1));
            }
            result += 0.05f;
        }
        if (items.size() > 0) {
            ArrayList arrayList = items;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"items");
            super.outputItems(arrayList);
        }
        return result;
    }

    public TreeFarmEntity() {
        super(TreeFarmEntity.class.getName().hashCode());
    }

    public static final /* synthetic */ int access$getScannedBlocks$p(TreeFarmEntity $this) {
        return $this.scannedBlocks;
    }

    public static final /* synthetic */ void access$setScannedBlocks$p(TreeFarmEntity $this, int n) {
        $this.scannedBlocks = n;
    }

    public static final /* synthetic */ int access$getPendingBlocks$p(TreeFarmEntity $this) {
        return $this.pendingBlocks;
    }

    public static final /* synthetic */ void access$setPendingBlocks$p(TreeFarmEntity $this, int n) {
        $this.pendingBlocks = n;
    }

    public static final /* synthetic */ int access$getLastScan$p(TreeFarmEntity $this) {
        return $this.lastScan;
    }

    public static final /* synthetic */ void access$setLastScan$p(TreeFarmEntity $this, int n) {
        $this.lastScan = n;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/treefarm/TreeFarmEntity$Companion;", "", "()V", "BREAK_PERCENT", "", "PLANT_PERCENT", "SCAN_PERCENT", "teslathingies_main"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

