/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.treefarm;

import com.google.common.collect.Lists;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.ndrei.teslacorelib.utils.BlockCube;
import net.ndrei.teslapoweredthingies.machines.treefarm.TreeWrapperFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u0004\u0018\u00010\u0005J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/treefarm/TreeScanner;", "", "()V", "scanned", "", "Lnet/minecraft/util/math/BlockPos;", "toScan", "blockCount", "", "pendingCount", "popScannedPos", "scan", "", "world", "Lnet/minecraft/world/World;", "base", "Lnet/ndrei/teslacorelib/utils/BlockCube;", "perBlockValue", "maxValue", "teslathingies_main"})
public final class TreeScanner {
    private List<BlockPos> scanned = Lists.newArrayList();
    private List<BlockPos> toScan;

    public final float scan(@NotNull World world, @NotNull BlockCube base, float perBlockValue, float maxValue) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        float result = 0.0f;
        if (this.scanned == null) {
            this.scanned = Lists.newArrayList();
        }
        if (this.toScan == null) {
            this.toScan = Lists.newArrayList();
        }
        for (BlockPos pos : base) {
            List<BlockPos> list = this.scanned;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (list.contains(pos)) continue;
            List<BlockPos> list2 = this.toScan;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            if (list2.contains(pos) || !TreeWrapperFactory.INSTANCE.isHarvestable(world, pos, null)) continue;
            List<BlockPos> list3 = this.toScan;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            list3.add(0, pos);
            if (!((result += perBlockValue) >= maxValue)) continue;
            return result;
        }
        while (true) {
            BlockPos pos;
            List<BlockPos> list = this.toScan;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (list.size() <= 0) break;
            List<BlockPos> list4 = this.toScan;
            if (list4 == null) {
                Intrinsics.throwNpe();
            }
            pos = list4.get(0);
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            for (int i = 0; i < enumFacingArray.length; ++i) {
                EnumFacing facing = enumFacingArray[i];
                BlockPos nb = pos.func_177972_a(facing);
                List<BlockPos> list5 = this.scanned;
                if (list5 == null) {
                    Intrinsics.throwNpe();
                }
                if (list5.contains(nb)) continue;
                List<BlockPos> list6 = this.toScan;
                if (list6 == null) {
                    Intrinsics.throwNpe();
                }
                if (list6.contains(nb)) continue;
                BlockPos blockPos = nb;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"nb");
                if (!TreeWrapperFactory.INSTANCE.isHarvestable(world, blockPos, null)) continue;
                List<BlockPos> list7 = this.toScan;
                if (list7 == null) {
                    Intrinsics.throwNpe();
                }
                BlockPos blockPos2 = nb;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"nb");
                list7.add(blockPos2);
                result += perBlockValue;
                if (!(result >= maxValue)) continue;
                return result;
            }
            List<BlockPos> list8 = this.toScan;
            if (list8 == null) {
                Intrinsics.throwNpe();
            }
            list8.remove(0);
            List<BlockPos> list9 = this.scanned;
            if (list9 == null) {
                Intrinsics.throwNpe();
            }
            list9.add(pos);
        }
        return result;
    }

    public final int blockCount() {
        int n;
        if (this.scanned == null) {
            n = 0;
        } else {
            List<BlockPos> list = this.scanned;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            n = list.size();
        }
        return n;
    }

    public final int pendingCount() {
        int n;
        if (this.toScan == null) {
            n = 0;
        } else {
            List<BlockPos> list = this.toScan;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            n = list.size();
        }
        return n;
    }

    @Nullable
    public final BlockPos popScannedPos() {
        block8: {
            block7: {
                if (this.scanned == null) break block7;
                List<BlockPos> list = this.scanned;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (list.size() != 0) break block8;
            }
            return null;
        }
        List<BlockPos> list = this.scanned;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int index = list.size() - 1;
        List<BlockPos> list2 = this.scanned;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos pos = list2.get(index);
        List<BlockPos> list3 = this.scanned;
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        list3.remove(index);
        return pos;
    }
}

