/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.machines.treefarm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.ndrei.teslapoweredthingies.machines.treefarm.BaseModTreeFactory;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeBlockWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeFactory;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeLeafWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeLogWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.ITreeSaplingWrapper;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaTree;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaTreeLeaf;
import net.ndrei.teslapoweredthingies.machines.treefarm.VanillaTreeLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0013J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ \u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ \u0010\u0018\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/ndrei/teslapoweredthingies/machines/treefarm/TreeWrapperFactory;", "", "()V", "treeWrappers", "", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeFactory;", "getBlockWrapper", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeBlockWrapper;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "block", "Lnet/minecraft/block/state/IBlockState;", "getSaplingWrapper", "Lnet/ndrei/teslapoweredthingies/machines/treefarm/ITreeSaplingWrapper;", "stack", "Lnet/minecraft/item/ItemStack;", "getSaplingWrappers", "", "stacks", "isHarvestable", "", "isHarvestableLeaf", "isHarvestableLog", "teslathingies_main"})
public final class TreeWrapperFactory {
    private static List<ITreeFactory> treeWrappers;
    public static final TreeWrapperFactory INSTANCE;

    public final boolean isHarvestable(@NotNull World world, @NotNull BlockPos pos, @Nullable IBlockState block) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState iBlockState = block;
        if (iBlockState == null) {
            iBlockState = world.func_180495_p(pos);
        }
        IBlockState state = iBlockState;
        return INSTANCE.isHarvestableLog(world, pos, state) || INSTANCE.isHarvestableLeaf(world, pos, state);
    }

    public final boolean isHarvestableLog(@NotNull World world, @NotNull BlockPos pos, @Nullable IBlockState block) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            IBlockState iBlockState = block;
            if (iBlockState == null) {
                iBlockState = world.func_180495_p(pos);
            }
            IBlockState state = iBlockState;
            Iterable $receiver$iv = treeWrappers;
            for (Object element$iv : $receiver$iv) {
                ITreeFactory it = (ITreeFactory)element$iv;
                IBlockState iBlockState2 = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
                if (!(it.getHarvestableLog(world, pos, iBlockState2) != null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean isHarvestableLeaf(@NotNull World world, @NotNull BlockPos pos, @Nullable IBlockState block) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            IBlockState iBlockState = block;
            if (iBlockState == null) {
                iBlockState = world.func_180495_p(pos);
            }
            IBlockState state = iBlockState;
            Iterable $receiver$iv = treeWrappers;
            for (Object element$iv : $receiver$iv) {
                ITreeFactory it = (ITreeFactory)element$iv;
                IBlockState iBlockState2 = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
                if (!(it.getHarvestableLeaf(world, pos, iBlockState2) != null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final ITreeBlockWrapper getBlockWrapper(@NotNull World world, @NotNull BlockPos pos, @Nullable IBlockState block) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState iBlockState = block;
        if (iBlockState == null) {
            iBlockState = world.func_180495_p(pos);
        }
        IBlockState state = iBlockState;
        for (ITreeFactory tree : treeWrappers) {
            IBlockState iBlockState2 = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
            ITreeBlockWrapper wrapper = tree.getHarvestableLog(world, pos, iBlockState2);
            if (wrapper == null) {
                IBlockState iBlockState3 = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"state");
                wrapper = tree.getHarvestableLeaf(world, pos, iBlockState3);
            }
            if (wrapper == null) continue;
            return wrapper;
        }
        return null;
    }

    @Nullable
    public final ITreeSaplingWrapper getSaplingWrapper(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.func_190926_b()) {
            for (ITreeFactory tree : treeWrappers) {
                ITreeSaplingWrapper wrapper = tree.getPlantableSapling(stack);
                if (wrapper == null) continue;
                return wrapper;
            }
        }
        return null;
    }

    @NotNull
    public final List<ITreeSaplingWrapper> getSaplingWrappers(@Nullable List<ItemStack> stacks) {
        List wrappers;
        block1: {
            Iterable $receiver$iv;
            wrappers = new ArrayList();
            List<ItemStack> list = stacks;
            if (list == null) break block1;
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)list;
            for (Object element$iv$iv : $receiver$iv$iv) {
                ITreeSaplingWrapper iTreeSaplingWrapper;
                Object element$iv = element$iv$iv;
                ItemStack it = (ItemStack)element$iv;
                if (INSTANCE.getSaplingWrapper(it) == null) continue;
                ITreeSaplingWrapper it$iv = iTreeSaplingWrapper;
                ((Collection)wrappers).add(it$iv);
            }
            List cfr_ignored_0 = (List)((Collection)wrappers);
        }
        return CollectionsKt.toList((Iterable)wrappers);
    }

    private TreeWrapperFactory() {
        INSTANCE = this;
        treeWrappers = new ArrayList();
        treeWrappers.add(new VanillaTree());
        treeWrappers.add(new BaseModTreeFactory("rustic"){

            @Override
            @Nullable
            public ITreeLeafWrapper getHarvestableLeaf(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState block) {
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                ResourceLocation resourceLocation = block.func_177230_c().getRegistryName();
                if (Intrinsics.areEqual((Object)(resourceLocation != null ? resourceLocation.toString() : null), (Object)"rustic:leaves")) {
                    return new VanillaTreeLeaf(world, pos);
                }
                return null;
            }
        });
        treeWrappers.add(new BaseModTreeFactory("biomesoplenty"){

            @Override
            @Nullable
            public ITreeLogWrapper getHarvestableLog(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState block) {
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                Object object = block.func_177230_c().getRegistryName();
                if (object != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)"biomesoplenty:log_", (boolean)false, (int)2, null) : false) {
                    return new VanillaTreeLog(world, pos);
                }
                return null;
            }

            @Override
            @Nullable
            public ITreeLeafWrapper getHarvestableLeaf(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState block) {
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                Object object = block.func_177230_c().getRegistryName();
                if (object != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)"biomesoplenty:leaves_", (boolean)false, (int)2, null) : false) {
                    return new VanillaTreeLeaf(world, pos);
                }
                return null;
            }
        });
        treeWrappers.add(new BaseModTreeFactory(""));
    }

    static {
        new TreeWrapperFactory();
    }
}

