/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslapoweredthingies.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;
import net.ndrei.teslapoweredthingies.client.Textures;
import net.ndrei.teslapoweredthingies.gui.IMultiTankMachine;
import net.ndrei.teslapoweredthingies.gui.TankInfo;
import net.ndrei.teslapoweredthingies.render.DualTankEntityRenderer$WhenMappings;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J`\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J@\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J@\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0012H\u0016\u00a8\u0006&"}, d2={"Lnet/ndrei/teslapoweredthingies/render/DualTankEntityRenderer;", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lnet/minecraft/tileentity/TileEntity;", "()V", "drawSprite", "", "start", "Lnet/minecraft/util/math/Vec3d;", "end", "sprite", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "drawTank", "tankX", "", "tankY", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "fluidPercent", "", "drawTexture", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "x", "y", "z", "sx", "sy", "sz", "minU", "minV", "maxU", "maxV", "render", "te", "partialTicks", "destroyStage", "", "alpha", "teslathingies_main"})
public final class DualTankEntityRenderer
extends TileEntitySpecialRenderer<TileEntity> {
    public static final DualTankEntityRenderer INSTANCE;

    public void func_192841_a(@NotNull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        TileEntity tileEntity = te;
        if (!(tileEntity instanceof ElectricTileEntity)) {
            tileEntity = null;
        }
        ElectricTileEntity electricTileEntity = (ElectricTileEntity)tileEntity;
        if (electricTileEntity == null) {
            return;
        }
        ElectricTileEntity machine = electricTileEntity;
        TileEntity tileEntity2 = te;
        if (!(tileEntity2 instanceof IMultiTankMachine)) {
            tileEntity2 = null;
        }
        if ((object = (IMultiTankMachine)tileEntity2) == null || (object = object.getTanks()) == null) {
            return;
        }
        Object tanks = object;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        switch (DualTankEntityRenderer$WhenMappings.$EnumSwitchMapping$0[machine.getFacing().ordinal()]) {
            case 1: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.501);
        float magicNumber = 0.03125f;
        GlStateManager.func_179152_a((float)magicNumber, (float)(-magicNumber), (float)magicNumber);
        super.func_190053_a(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        Iterable $receiver$iv = (Iterable)tanks;
        for (Object element$iv : $receiver$iv) {
            TankInfo it = (TankInfo)element$iv;
            float percent = it.getFluid() == null ? 0.0f : Math.min(1.0f, Math.max(0.0f, (float)it.getFluid().amount / (float)it.getCapacity()));
            FluidStack fluidStack = it.getFluid();
            INSTANCE.drawTank(it.getLeft(), it.getTop(), (Fluid)(fluidStack != null ? fluidStack.getFluid() : null), percent);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        super.func_190053_a(false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private final void drawTank(double tankX, double tankY, Fluid fluid, float fluidPercent) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)tankX, (double)tankY, (double)0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double tankHeight = 14.0;
        super.func_147499_a(Textures.INSIDE_TANK.getResource());
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BufferBuilder bufferBuilder = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder, (String)"buffer");
        this.drawTexture(bufferBuilder, 0.0, 0.0, -6.0, 6.0, tankHeight, 0.0, 1.0, 1.0, 7.0, 15.0);
        BufferBuilder bufferBuilder2 = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder2, (String)"buffer");
        this.drawTexture(bufferBuilder2, 0.0, 0.0, 0.0, 6.0, 0.0, -6.0, 9.0, 1.0, 15.0, 7.0);
        BufferBuilder bufferBuilder3 = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder3, (String)"buffer");
        this.drawTexture(bufferBuilder3, 0.0, tankHeight, -6.0, 6.0, 0.0, 6.0, 9.0, 1.0, 15.0, 7.0);
        BufferBuilder bufferBuilder4 = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder4, (String)"buffer");
        this.drawTexture(bufferBuilder4, 0.0, 0.0, 0.0, 0.0, tankHeight, -6.0, 1.0, 1.0, 6.0, 15.0);
        BufferBuilder bufferBuilder5 = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder5, (String)"buffer");
        this.drawTexture(bufferBuilder5, 6.0, 0.0, -6.0, 0.0, tankHeight, 6.0, 1.0, 1.0, 7.0, 15.0);
        Tessellator.func_178181_a().func_78381_a();
        if (fluidPercent > 0.0f && fluid != null && fluidPercent > 0.0f) {
            ResourceLocation flowing = fluid.getFlowing();
            ResourceLocation still = fluid.getStill();
            if (flowing != null || still != null) {
                TextureAtlasSprite stillSprite;
                super.func_147499_a(TextureMap.field_110575_b);
                double height = tankHeight * (double)fluidPercent;
                int color = fluid.getColor();
                GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
                TextureAtlasSprite textureAtlasSprite = stillSprite = still != null ? Minecraft.func_71410_x().func_147117_R().getTextureExtry(still.toString()) : Minecraft.func_71410_x().func_147117_R().func_174944_f();
                if (stillSprite != null) {
                    this.drawSprite(new Vec3d(0.0, tankHeight - height, -0.1), new Vec3d(6.0, tankHeight, -0.1), stillSprite);
                    this.drawSprite(new Vec3d(0.0, tankHeight - height, -6.0), new Vec3d(6.0, tankHeight - height, -0.1), stillSprite);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    private final void drawSprite(Vec3d start, Vec3d end, TextureAtlasSprite sprite) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double width = Math.abs(end.field_72450_a - start.field_72450_a);
        double height = Math.abs(end.field_72448_b == start.field_72448_b ? end.field_72449_c - start.field_72450_a : end.field_72448_b - start.field_72448_b);
        float texW = sprite.func_94212_f() - sprite.func_94209_e();
        float texH = sprite.func_94210_h() - sprite.func_94206_g();
        double finalW = (double)texW * width / 32.0;
        double finalH = (double)texH * height / 32.0;
        BufferBuilder bufferBuilder = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder, (String)"buffer");
        this.drawTexture(bufferBuilder, start, end, sprite.func_94209_e(), sprite.func_94206_g(), (double)sprite.func_94209_e() + finalW, (double)sprite.func_94206_g() + finalH);
        Tessellator.func_178181_a().func_78381_a();
    }

    private final void drawTexture(BufferBuilder buffer, double x, double y, double z, double sx, double sy, double sz, double minU, double minV, double maxU, double maxV) {
        double ofy;
        double ofx;
        double of = 0.02;
        double d = sx == 0.0 ? 0.0 : (ofx = sx > 0.0 ? of : -of);
        double d2 = sy == 0.0 ? 0.0 : (ofy = sy > 0.0 ? of : -of);
        double ofz = sz == 0.0 ? 0.0 : (sz > 0.0 ? of : -of);
        this.drawTexture(buffer, new Vec3d(x - ofx, y - ofy, z - ofz), new Vec3d(x + sx + ofx, y + sy + ofy, z + sz + ofz), minU / 16.0, minV / 16.0, maxU / 16.0, maxV / 16.0);
    }

    private final void drawTexture(BufferBuilder buffer, Vec3d start, Vec3d end, double minU, double minV, double maxU, double maxV) {
        buffer.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_187315_a(minU, minV).func_181675_d();
        buffer.func_181662_b(start.field_72450_a, end.field_72448_b, start.field_72450_a == end.field_72450_a ? start.field_72449_c : end.field_72449_c).func_187315_a(minU, maxV).func_181675_d();
        buffer.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_187315_a(maxU, maxV).func_181675_d();
        buffer.func_181662_b(end.field_72450_a, start.field_72448_b, start.field_72450_a == end.field_72450_a ? end.field_72449_c : start.field_72449_c).func_187315_a(maxU, minV).func_181675_d();
    }

    private DualTankEntityRenderer() {
        INSTANCE = this;
    }

    static {
        new DualTankEntityRenderer();
    }
}

