function make_beam(sound)
  local result =
  {
    type = "beam",
    flags = {"not-on-map"},
    width = 0.5,
    damage_interval = 20,
    random_target_offset = true,
    target_offset = {0, -0.5},
    action_triggered_automatically = false,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = { amount = 10, type = "tesla-zap"}
          }
        }
      }
    }
  }

  if sound then
    result.working_sound =
    {
      sound =
      {
        filename = "__tesla-coil__/sound/tesla-zapp.ogg",
        volume = 0.7
      },
      max_sounds_per_type = 4
    }
    result.name = "electric-beam"
  else
    result.name = "electric-beam-no-sound"
  end

  return append_base_electric_beam_graphics(result, beam_blend_mode, beam_non_light_flags, nil, nil)
end

data:extend(
{
  make_beam(true),
  make_beam(false)
}
)