function tesla_turret_extension(inputs)
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/anims/NR/Teslaidle.png",
    priority = "medium",
    width = 128,
    height = 128,
      frame_count = 10,
      run_mode = inputs.run_mode or "forward",
    axially_symmetrical = false,
    direction_count = 1,
      scale = 0.99,
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/anims/HR/Teslaidle.png",
      priority = "medium",
      width = 256,
      height = 256,
      frame_count = 10,
      run_mode = inputs.run_mode or "forward",
      axially_symmetrical = false,
      direction_count = 1,
      scale = 0.49
    }
  }
end

function tesla_turret_extension_shadow(inputs)
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/anims/NR/Teslaidle_Schatten2.png",
    width = 128,
    height = 128,
    run_mode = inputs.run_mode or "forward",
    axially_symmetrical = false,
    frame_count = 10,
    direction_count = 1,
    draw_as_shadow = true,
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/anims/NR/Teslaidle_Schatten.png",
      width = 256,
      height = 256,
      run_mode = inputs.run_mode or "forward",
      axially_symmetrical = false,
      direction_count = 1,
      frame_count = 10,
      draw_as_shadow = true,
      scale = 0.49
    }
  }
end

function tesla_turret_extension_mask(inputs)
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/anims/zap/NRteslazap.png",
    flags = { "mask" },
    width = 128,
    height = 128,
--    frame_count = inputs.frame_count or 15,
---    line_length = inputs.line_length or 0,
    run_mode = inputs.run_mode or "forward",
    axially_symmetrical = false,
    apply_runtime_tint = true,
    direction_count = 1,
    frame_count = 10,
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/anims/zap/HRteslazap.png",
      flags = { "mask" },
      width = 256,
      height = 256,
      frame_count = 10,
--      frame_count = inputs.frame_count or 15,
--      line_length = inputs.line_length or 0,
      run_mode = inputs.run_mode or "forward",
      axially_symmetrical = false,
      apply_runtime_tint = true,
      direction_count = 1,
  --    shift = util.by_pixel(0, -43),
      scale = 0.49
    }
  }
end

function tesla_turret_shooting()
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/anims/zap/NRteslazap.png",
    width = 128,
    height = 128,
    frame_count = 10,
    direction_count = 1,

    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/anims/zap/HRteslazap.png",
      width = 256,
      height = 256,
      frame_count = 10,
      direction_count = 1,
      light = {intensity = 0.9, size = 40, color = {r=1.0, g=1.0, b=0.75}},
      light_flicker =
      {
        color = {0,0,0},
        minimum_intensity = 0.6,
        maximum_intensity = 0.95
      },
      scale = 0.49
    }
  }
end

function tesla_turret_shooting_glow()
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
    line_length = 10,
    width = 1,
    height = 1,
    frame_count = 10,
    direction_count = 64,
    blend_mode = "additive",
    shift = util.by_pixel(0, -35),
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
      line_length = 8,
      width = 1,
      height = 1,
      frame_count = 10,
      direction_count = 64,
      shift = util.by_pixel(-0.5, -35),
      blend_mode = "additive",
      scale = 1
    }
  }
end

function tesla_turret_shooting_mask()
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
    flags = { "mask" },
    line_length = 10,
    width = 2,
    height = 2,
    frame_count = 10,
    apply_runtime_tint = true,
    direction_count = 1,
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
      flags = { "mask" },
      line_length = 10,
      width = 2,
      height = 2,
      frame_count = 10,
      apply_runtime_tint = true,
      direction_count = 1,
      scale = 1
    }
  }
end

function tesla_turret_shooting_shadow()
  return
  {
    filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
    line_length = 1,
    width = 1,
    height = 1,
    frame_count = 10,
    direction_count = 1,
    draw_as_shadow = true,
    shift = util.by_pixel(51, 2),
    hr_version =
    {
      filename = "__tesla-coil__/graphics/entity/teslacoil/dummy.png",
      line_length = 1,
      width = 1,
      height = 1,
      frame_count = 10,
      direction_count = 1,
      draw_as_shadow = true,
      shift = util.by_pixel(50.5, 2.5),
      scale = 0.5
    }
  }
end


data:extend({
 {
    type = "electric-turret",
    name = "tesla-coil-turret",
    icon = "__tesla-coil__/graphics/icon/tesla_64.png",
    icon_size = 64, icon_mipmaps = 4,
    flags = { "placeable-player", "placeable-enemy", "player-creation"},
    minable = { mining_time = 0.5, result = "tesla-coil-turret" },
    max_health = 1200,
    collision_box = {{ -0.7, -0.7}, {0.7, 0.7}},
    selection_box = {{ -1, -1}, {1, 1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    rotation_speed = 0.01,
    preparing_speed = 0.05,
    preparing_sound = { filename = "__tesla-coil__/sound/tslachg2.ogg",volume = 0.50 },
    folding_sound = { filename = "__tesla-coil__/sound/tslachg3.ogg",volume = 0.50 },
    corpse = "medium-remnants",
    dying_explosion = "laser-turret-explosion",
    folding_speed = 0.005,
    energy_source =
    {
      type = "electric",
      buffer_capacity = "4501kJ",
      input_flow_limit = "9600kW",
      drain = "800kW",
      usage_priority = "primary-input"
    },
    folded_animation =
    {
      layers =
      {
        tesla_turret_extension{frame_count=1, line_length = 1},
        tesla_turret_extension_shadow{frame_count=1, line_length=1},
        tesla_turret_extension_mask{frame_count=1, line_length=1}
      }
    },
    preparing_animation =
    {
      layers =
      {
        tesla_turret_extension{},
        tesla_turret_extension_shadow{},
        tesla_turret_extension_mask{}
      }
    },
    prepared_animation =
    {
      layers =
      {
        tesla_turret_shooting(),
        tesla_turret_shooting_shadow(),
        tesla_turret_shooting_mask()
      }
    },
    energy_glow_animation = laser_turret_shooting_glow(),
    glow_light_intensity = 0.5, -- defaults to 0
    folding_animation =
    {
      layers =
      {
        tesla_turret_extension{run_mode = "backward"},
        tesla_turret_extension_shadow{run_mode = "backward"},
        tesla_turret_extension_mask{run_mode = "backward"}
      }
    },
    base_picture =
    {
      layers =
      {
        {
          filename = "__tesla-coil__/graphics/entity/teslacoil/teslacoil.png",
          priority = "high",
          width = 256,
          height = 256,
          direction_count = 1,
          frame_count = 1,
          shift = util.by_pixel(0, 2),
          hr_version =
          {
            filename = "__tesla-coil__/graphics/entity/teslacoil/teslacoil.png",
            priority = "high",
            width = 256,
            height = 256,
            direction_count = 1,
            frame_count = 1,
            shift = util.by_pixel(-0.5, 2),
            scale = 0.5
          }
        },
        {
          filename = "__tesla-coil__/graphics/entity/teslacoil/teslacoil-shadow.png",
          line_length = 1,
          width = 256,
          height = 256,
          draw_as_shadow = true,
          direction_count = 1,
          frame_count = 1,
          shift = util.by_pixel(6, 3),
          hr_version =
          {
            filename = "__tesla-coil__/graphics/entity/teslacoil/teslacoil-shadow.png",
            line_length = 1,
            width = 132,
            height = 82,
            draw_as_shadow = true,
            direction_count = 1,
            frame_count = 1,
            shift = util.by_pixel(6, 3),
            scale = 0.5
          }
        }
      }
    },
 --   vehicle_impact_sound = "__base__/sound/car-metal-impact.ogg",

	attack_parameters =
	{
		type = "beam",
        flags = {"not-on-map"},
		cooldown = 45,
        damage_interval = 5,
        target_offset = {0, -0.5},
		projectile_creation_distance = 1.6,
		projectile_center = {0.0, 0.4},
        damage_modifier = 3.5,
 		min_range = 15,
		range = 45,
        ammo_type =
        {
          category = "tesla-zap",
          energy_consumption = "1500kJ",
          action =
          {
            type = "direct",
            action_delivery =
            {
              type = "beam",
              beam = "electric-beam",
              max_length = 46,
              duration = 40,
              source_offset = {0, -1.31439 },
		      action_delivery =
				{
					type = "instant",
					target_effects =
					{
						{
							type = "create-explosion",
							entity_name = "electric-beam"
						},
                    },
                },
            }
          }
        }
      },


	call_for_help_radius = 40,
    water_reflection =
    {
      pictures =
      {
        filename = "__base__/graphics/entity/laser-turret/laser-turret-reflection.png",
        priority = "extra-high",
        width = 20,
        height = 32,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5
      },
      rotate = false,
      orientation_to_variation = false
    }
  },
})