// This is an Unreal Script
class X2Item_TechArmor extends X2Item config(GameCore);

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Items;

	Items.AddItem(CreateTechVest());


	return Items;
}

static function X2DataTemplate CreateTechVest()
{
	local X2EquipmentTemplate Template;
	local ArtifactCost Resources;
	local ArtifactCost Artifacts;

	`CREATE_X2TEMPLATE(class'X2EquipmentTemplate', Template, 'TechVest');
	Template.ItemCat = 'defense';
	Template.InventorySlot = eInvSlot_Utility;
	Template.strImage = "img:///UILibrary_TechVest.X2InventoryIcons.Inv_TechArmor";
	Template.EquipSound = "StrategyUI_Vest_Equip";

	Template.Abilities.AddItem('TechArmorAbility');

	Template.CanBeBuilt = False;
	Template.TradingPostValue = 15;
	Template.Tier = 2;


	Template.SetUIStatMarkup(class'XLocalizedData'.default.TechBonusLabel, eStat_Hacking, class'X2Ability_TechArmorAbilitySet'.default.TECH_VEST_HACK_BONUS);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.HealthLabel, eStat_HP, class'X2Ability_TechArmorAbilitySet'.default.TECH_VEST_HP_BONUS);
	// Requirements
	//Template.Requirements.RequiredTechs.AddItem('HybridMaterials');

	// Cost
	//Resources.ItemTemplateName = 'Supplies';
	//Resources.Quantity = 30;
	//Template.Cost.ResourceCosts.AddItem(Resources);

	Template.RewardDecks.AddItem('ExperimentalArmorRewards');

	//Artifacts.ItemTemplateName = 'CorpseAdventTrooper';
	//Artifacts.Quantity = 2;
	//Template.Cost.ArtifactCosts.AddItem(Artifacts);

	return Template;
}

