--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 12.12.2019 - Release Version
V 1.0.1.0 @ 09.02.2020 - Stop specialisation being added to tree planters, straw blowers and base game conveyor belts, fix shovel to stop deleting ground product when level is reached.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


FillLevelLimiter = {}

FillLevelLimiter.GUI_BUILD_ID = 1
FillLevelLimiter.VERSION_STRING = "1.0.0.0"

-- Not needed and need more functions to work correctly.
FillLevelLimiter.IGNORE_SPECIALIZATIONS = {
    ["baler"] = true,
    ["mower"] = true,
    ["leveler"] = true,
    ["combine"] = true,
    ["strawBlower"] = true,
    ["treePlanter"] = true
}

-- No need to add to these vehicle types so I just skip them.
FillLevelLimiter.IGNORE_VEHICLE_TYPES = {
    ["baler"] = true,
    ["pallet"] = true,
    ["tractor"] = true,
    ["leveler"] = true,
    ["woodTruck"] = true,
    ["forwarder"] = true,
    ["locomotive"] = true,
    ["teleHandler"] = true,
    ["buyableBale"] = true,
    ["treePlanter"] = true,
    ["strawBlower"] = true,
    ["conveyorBelt"] = true,
    ["balerWrapper"] = true,
    ["baseDrivable"] = true,
    ["loaderVehicle"] = true,
    ["woodHarvester"] = true,
    ["receivingHopper"] = true,
    ["combineDrivable"] = true,
    ["cottonHarvester"] = true,
    ["attachableCombine"] = true,
    ["pickupConveyorBelt"] = true,
    ["selfPropelledMower"] = true,
    ["tractorCrabSteering"] = true,
    ["tractorReverseDriving"] = true,
    ["combineCutterFruitPreparer"] = true,
    ["attachableCombineCutterFruitPreparer"] = true
}

function FillLevelLimiter.init(name, creator, modDir)
    if (name == "FS19_FillLevelLimiter" or name == "FS19_FillLevelLimiter_update") and creator:len() == 3 then

        FillLevelLimiter.addSpecialization(name, modDir)

        if g_gui ~= nil and g_gui.guis.FillLevelLimiterGui == nil then
            source(Utils.getFilename("scripts/gui/FillLevelLimiterGui.lua", modDir))

            local dialog = FillLevelLimiterGui:new(nil, nil)
            g_gui:loadGui(modDir .. "scripts/gui/FillLevelLimiterGui.xml", "FillLevelLimiterGui", dialog)
        end

        -- I need to overwrite this so the capacity limit can be tricked. Changing 'getFillUnitCapacity' can have undesired results.
        Shovel.onUpdateTick = Utils.overwrittenFunction(Shovel.onUpdateTick, FillLevelLimiter.inj_shovelUpdateTick)
    else
        getfenv(0)["g_fillLevelLimiterError"] = {
            name = name,
            creator = creator,
            startUpdateTime = 2000
        }

        g_fillLevelLimiterError.update = function(g_fillLevelLimiterError, dt)
            if g_fillLevelLimiterError ~= nil then
                if g_fillLevelLimiterError.startUpdateTime > 0 then
                    g_fillLevelLimiterError.startUpdateTime = g_fillLevelLimiterError.startUpdateTime - dt
                else
                    local title = string.format("Fill Level Limiter - Version %s", FillLevelLimiter.VERSION_STRING)
                    local text = string.format(g_i18n:getText("FLL_loadError"), g_fillLevelLimiterError.name, g_fillLevelLimiterError.creator)
                    if g_client ~= nil then
                        if not g_gui:getIsGuiVisible() then
                            g_gui:showYesNoDialog({
                                title = title,
                                text = text,
                                dialogType = DialogElement.TYPE_LOADING,
                                callback = g_fillLevelLimiterError.openModHubLink,
                                target = nil,
                                yesText = g_i18n:getText("button_ok"),
                                noText = g_i18n:getText("button_modHubDownload")
                            })
                        end
                    else
                        print(title .. "  " .. text .. "\n    - https://farming-simulator.com/mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0")
                        g_fillLevelLimiterError:openModHubLink(true)
                    end
                end
            end
        end

        g_fillLevelLimiterError.openModHubLink = function(isYes)
            if isYes == false then
                local language = g_languageShort
                local link = "mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=1"
                if language == "de" or language == "fr" then
                    link = "mods.php?lang=" .. language .. "&country=be&title=fs2019&filter=org&org_id=129652&page=0"
                end

                openWebFile(link, "")
            end

            removeModEventListener(g_fillLevelLimiterError)
            getfenv(0)["g_fillLevelLimiterError"] = nil
        end

        addModEventListener(g_fillLevelLimiterError)
    end

end

function FillLevelLimiter.addSpecialization(name, modDir)
    if g_currentMission ~= nil then
        return false
    end

    local inserted = 0

    source(Utils.getFilename("scripts/events/FillLevelLimiterSpecEvent.lua", modDir))

    g_specializationManager:addSpecialization("fillLevelLimiter", "FillLevelLimiterSpec", modDir .. "scripts/spec/FillLevelLimiterSpec.lua", nil)

    local specEnvName = name .. ".fillLevelLimiter"
    local spec = g_specializationManager:getSpecializationObjectByName(specEnvName)

    if spec ~= nil then
        for typeName, vehicleType in pairs(g_vehicleTypeManager:getVehicleTypes()) do
            if (vehicleType ~= nil and vehicleType.specializationsByName ~= nil) and FillLevelLimiter.getIsValidVehicleType(typeName) then

                local doInsert = spec.prerequisitesPresent(vehicleType.specializations)
                if doInsert then
                    for specName, _ in pairs(vehicleType.specializationsByName) do
                        if FillLevelLimiter.IGNORE_SPECIALIZATIONS[specName] then
                            doInsert = false
                            break
                        end

                        local start, _ = string.find(specName:lower(), "filllevellimiter")
                        if start ~= nil then
                            doInsert = false
                            break
                        end
                    end
                end

                if doInsert then
                    g_vehicleTypeManager:addSpecialization(typeName, specEnvName)
                    inserted = inserted + 1
                end
            end
        end
    end

    if inserted > 0 then
        print(string.format("  Loaded 'Fill Level Limiter' into %d vehicle types.", inserted))

        return true
    else
        return false
    end
end

function FillLevelLimiter.getIsValidVehicleType(typeName)
    if FillLevelLimiter.IGNORE_VEHICLE_TYPES[typeName] ~= nil then
        return FillLevelLimiter.IGNORE_VEHICLE_TYPES[typeName] == false
    end

    return true
end

function FillLevelLimiter:inj_shovelUpdateTick(superFunc, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    -- Always use the original function if the spec 'fillLevelLimiter' is not available.
    if self.spec_fillLevelLimiter == nil then
        return superFunc(self, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    end

    local spec = self.spec_shovel

    if self.isServer then
        local validPickupFillType = FillType.UNKNOWN

        for _,shovelNode in pairs(spec.shovelNodes) do
            if self:getShovelNodeIsActive(shovelNode) then
                local fillLevel = self:getFillUnitFillLevel(shovelNode.fillUnitIndex)
                local capacity = self:getFillUnitCapacity(shovelNode.fillUnitIndex)

                local fillUnitLimit = self:getFillUnitLimit(shovelNode.fillUnitIndex)
                if fillUnitLimit ~= nil and fillUnitLimit < capacity then
                    capacity = fillUnitLimit
                end

                if fillLevel < capacity then
                    local pickupFillType = self:getFillUnitFillType(shovelNode.fillUnitIndex)
                    if fillLevel / capacity < self:getFillTypeChangeThreshold() then
                        pickupFillType = FillType.UNKNOWN
                    end

                    local freeCapacity = math.min(capacity - fillLevel, shovelNode.fillLitersPerSecond * dt)
                    local sx,sy,sz = localToWorld(shovelNode.node, -shovelNode.width, shovelNode.yOffset, shovelNode.zOffset)
                    local ex,ey,ez = localToWorld(shovelNode.node, shovelNode.width, shovelNode.yOffset, shovelNode.zOffset)
                    local innerRadius = shovelNode.length
                    local radius = nil

                    if self:getCanShovelAtPosition(shovelNode) then
                        if pickupFillType == FillType.UNKNOWN or spec.ignoreFillUnitFillType then
                            pickupFillType = DensityMapHeightUtil.getFillTypeAtLine(sx,sy,sz, ex,ey,ez, innerRadius)
                        end
                        if pickupFillType ~= FillType.UNKNOWN and self:getFillUnitSupportsFillType(shovelNode.fillUnitIndex, pickupFillType) then
                            local fillDelta, lineOffset = DensityMapHeightUtil.tipToGroundAroundLine(self, -freeCapacity, pickupFillType, sx,sy,sz, ex,ey,ez, innerRadius, radius, shovelNode.lineOffset, true, nil)
                            shovelNode.lineOffset = lineOffset

                            if fillDelta < 0 then
                                local loadInfo = self:getFillVolumeLoadInfo(shovelNode.loadInfoIndex)
                                self:addFillUnitFillLevel(self:getOwnerFarmId(), shovelNode.fillUnitIndex, -fillDelta, pickupFillType, ToolType.UNDEFINED, loadInfo)
                                validPickupFillType = pickupFillType

                                -- call fill level changed callback to inform bunker silo about change
                                self:notifiyBunkerSilo(fillDelta, pickupFillType)
                            end
                        end
                    end
                end
            end
        end

        if spec.loadingFillType ~= validPickupFillType then
            spec.loadingFillType = validPickupFillType
            self:raiseDirtyFlags(spec.effectDirtyFlag)
        end
    end

    if self.isClient then
        if spec.loadingFillType ~= FillType.UNKNOWN then
            g_effectManager:setFillType(spec.fillEffects, spec.loadingFillType)
            g_effectManager:startEffects(spec.fillEffects)
        else
            g_effectManager:stopEffects(spec.fillEffects)
        end
    end
end

FillLevelLimiter.init(g_currentModName, g_modManager:getModByName(g_currentModName).author, g_currentModDirectory)
