--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 12.12.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


FillLevelLimiterSpecEvent = {}
FillLevelLimiterSpecEvent_mt = Class(FillLevelLimiterSpecEvent, Event)
InitEventClass(FillLevelLimiterSpecEvent, "FillLevelLimiterSpecEvent")

function FillLevelLimiterSpecEvent:emptyNew()
    local self = Event:new(FillLevelLimiterSpecEvent_mt)
    return self
end

function FillLevelLimiterSpecEvent:new(object, limitsTable, showHelpInfo)
    local self = FillLevelLimiterSpecEvent:emptyNew()

    self.object = object
    self.limitsTable = limitsTable
    self.showHelpInfo = showHelpInfo

    return self
end

function FillLevelLimiterSpecEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)

    local numLimits = streamReadInt8(streamId)

    if numLimits > 0 then
        self.limitsTable = {}

        for i = 1, numLimits do
            local fillUnitIndex = streamReadInt8(streamId)
            local limit = streamReadFloat32(streamId)

            self.limitsTable[fillUnitIndex] = limit
        end
    end

    self.showHelpInfo = streamReadBool(streamId)
    self:run(connection)
end

function FillLevelLimiterSpecEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)

    local numLimits = 0

    if self.limitsTable ~= nil then
        for _ in pairs (self.limitsTable) do
            numLimits = numLimits + 1
        end
    end

    streamWriteInt8(streamId, numLimits)

    if numLimits > 0 then
        for fillUnitIndex, limit in pairs (self.limitsTable) do
            streamWriteInt8(streamId, fillUnitIndex)
            streamWriteFloat32(streamId, limit)
        end
    end

    streamWriteBool(streamId, self.showHelpInfo)
end

function FillLevelLimiterSpecEvent:run(connection)
    if self.object ~= nil then
        self.object:updateFillUnitLimits(self.limitsTable, self.showHelpInfo, true)

        if not connection:getIsServer() then
            g_server:broadcastEvent(FillLevelLimiterSpecEvent:new(self.object, self.limitsTable, self.showHelpInfo), nil, connection, self.object)
        end
    end
end

function FillLevelLimiterSpecEvent.sendEvent(vehicle, limitsTable, showHelpInfo, noEventSend)
    if vehicle.spec_fillLevelLimiter ~= nil and limitsTable ~= nil then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(FillLevelLimiterSpecEvent:new(vehicle, limitsTable, showHelpInfo), nil, nil, vehicle)
            else
                g_client:getServerConnection():sendEvent(FillLevelLimiterSpecEvent:new(vehicle, limitsTable, showHelpInfo))
            end
        end
    end
end
