--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 12.12.2019 - Release Version
V 1.0.1.0 @ 09.02.2020 - Minimum limit now updates based on current fill level.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


FillLevelLimiterGui = {}
local FillLevelLimiterGui_mt = Class(FillLevelLimiterGui, YesNoDialog)

FillLevelLimiterGui.GUI_BUILD_ID = 1
FillLevelLimiterGui.NOT_APPLICABLE = "N/A"

FillLevelLimiterGui.UPDATE_COUNTER_INTERVAL = 2000

FillLevelLimiterGui.CONTROLS = {
    FILL_LEVEL_TEXT_INPUT = "fillLevelTextElement",
    FILL_UNIT_INDEX_ELEMENT = "fillUnitIndexElement",
    DIALOG_TEXT_ELEMENT = "dialogTextElement",
    SETTINGS_STATE_ELEMENT = "settingStateElement",
    SETTINGS_TEXT_ELEMENT = "settingsTextElement",
    SETTINGS_TEXT = "settingsText",
    YES_BUTTON = "yesButton",
    NO_BUTTON = "noButton",
    RESET_BUTTON = "resetButton"
}

function FillLevelLimiterGui:new()
    local self = YesNoDialog:new(nil, FillLevelLimiterGui_mt)

    self:registerControls(FillLevelLimiterGui.CONTROLS)
    self.isButtonDisabled = false

    self.showHelpInfo = true
    self.doEnterPress = false

    self.updateCounter = FillLevelLimiterGui.UPDATE_COUNTER_INTERVAL

    return self
end

function FillLevelLimiterGui:setData(vehicle, showHelpInfo)
    if self.target == nil then
        self.target = vehicle
    end

    if g_i18n:hasText("FLL_settingHeader") then
        self.settingsTextElement:setText(g_i18n:getText("FLL_settingHeader"))
    end

    self.fillUnitIndex = nil
    self.lastTextValue = {}
    self.fillLevelLimits = {}

    self.fillUnitSelectorToIndex = {}

    local fillUnitSelectorNames = {}
    local spec = vehicle.spec_fillLevelLimiter

    local index = 0
    local resetDisabled = true
    if spec ~= nil then
        for fillUnitIndex, limit in pairs (spec.fillUnitIndexToLimit) do
            if limit < self.target:getFillUnitCapacity(fillUnitIndex) then
                resetDisabled = false
            end

            index = index + 1

            self.lastTextValue[fillUnitIndex] = tostring(limit)
            self.fillLevelLimits[fillUnitIndex] = limit

            table.insert(self.fillUnitSelectorToIndex, fillUnitIndex)

            local name = spec.fillUnitTitle[fillUnitIndex] or FillLevelLimiterGui.NOT_APPLICABLE
            table.insert(fillUnitSelectorNames, name)
        end
    end

    self.fillUnitIndexElement:setTexts(fillUnitSelectorNames)
    self.fillUnitIndexElement:setState(1, true)
    self.fillUnitIndexElement:setDisabled(index < 2)

    self.showHelpInfo = Utils.getNoNil(showHelpInfo, true)
    self.settingStateElement:setIsChecked(self.showHelpInfo)

    self:setYesButtonDisabled(spec == nil)
    self:setResetButtonDisabled(resetDisabled)
end

function FillLevelLimiterGui:onEnterPressed()
    if self.fillLevelTextElement.text ~= "" then
        local newFillLevelValue = tonumber(self.fillLevelTextElement.text)

        if newFillLevelValue ~= nil then
            local minimum = self.target:getFillUnitFillLevel(self.fillUnitIndex) or 1
            local maximum = self.target:getFillUnitCapacity(self.fillUnitIndex)
            self.fillLevelLimits[self.fillUnitIndex] = MathUtil.clamp(newFillLevelValue, math.max(MathUtil.round(minimum), 1), maximum)
        end
    end

    self.lastTextValue[self.fillUnitIndex] = string.format("%d", self.fillLevelLimits[self.fillUnitIndex])
    self.fillLevelTextElement:setText(self.lastTextValue[self.fillUnitIndex])
    self.doEnterPress = false
end

function FillLevelLimiterGui:onEscPressed()
    self.fillLevelTextElement:setText(self:getCurrentTextValue())
    self.doEnterPress = false
end

function FillLevelLimiterGui:onTextChanged()
    local text = self.fillLevelTextElement.text

    if text ~= self.lastTextValue[self.fillUnitIndex] then
        if text ~= "" then
            if tonumber(text) ~= nil then
                self.lastTextValue[self.fillUnitIndex] = text
            else
                self.fillLevelTextElement:setText(self.lastTextValue[self.fillUnitIndex])
            end
        end

        self.doEnterPress = true
    end
end

function FillLevelLimiterGui:update(dt)
    FillLevelLimiterGui:superClass().update(self, dt)

    if self.target ~= nil and self.fillUnitIndex ~= nil then
        self.updateCounter = self.updateCounter - dt

        if self.updateCounter < 0 then
            local fillLevel = self.target:getFillUnitFillLevel(self.fillUnitIndex)

            if fillLevel ~= nil then
                if fillLevel ~= self.lastFillLevelForUpdate then
                    self.lastFillLevelForUpdate = fillLevel

                    local maximum = self.target:getFillUnitCapacity(self.fillUnitIndex)
                    self.dialogTextElement:setText(string.format(g_i18n:getText("FLL_fillUnitHeader"), math.max(MathUtil.round(fillLevel), 1), maximum, g_i18n:getVolumeUnit(false)))
                end
            end

            self.updateCounter = FillLevelLimiterGui.UPDATE_COUNTER_INTERVAL
        end
    end
end

function FillLevelLimiterGui:getCurrentTextValue()
    if self.fillUnitIndex ~= nil and self.fillLevelLimits[self.fillUnitIndex] ~= nil then
        return string.format("%d", self.fillLevelLimits[self.fillUnitIndex])
    end

    return ""
end

function FillLevelLimiterGui:onClickOk()
    if self.isYesButtonDisabled then
        return
    end

    if self.doEnterPress then
        self:onEnterPressed()
    end

    self:sendCallback(self.fillLevelLimits, self.showHelpInfo)
end

function FillLevelLimiterGui:onClickBack(forceBack, usedMenuButton)
    self:close()
end

function FillLevelLimiterGui:onClickCancel()
    for fillUnitIndex, _ in pairs (self.fillLevelLimits) do
        local capacity = self.target:getFillUnitCapacity(fillUnitIndex)

        self.fillLevelLimits[fillUnitIndex] = capacity
        self.lastTextValue[fillUnitIndex] = tostring(capacity)
    end

    self.fillUnitIndexElement:setState(1, true)
    self:onClickOk()
end

function FillLevelLimiterGui:onClickFillUnitIndex(index)
    local fillUnitIndex = self.fillUnitSelectorToIndex[index]

    if fillUnitIndex ~= nil then
        local minimum = self.target:getFillUnitFillLevel(fillUnitIndex) or 1
        local maximum = self.target:getFillUnitCapacity(fillUnitIndex)
        self.dialogTextElement:setText(string.format(g_i18n:getText("FLL_fillUnitHeader"), math.max(MathUtil.round(minimum), 1), maximum, g_i18n:getVolumeUnit(false)))

        self.fillUnitIndex = fillUnitIndex
        self.fillLevelTextElement:setText(self:getCurrentTextValue())
    end
end

function FillLevelLimiterGui:onClickSettingState(index)
    self.showHelpInfo = index > 1
end

function FillLevelLimiterGui:sendCallback(fillLevelLimits, showHelpInfo)
    if self.inputDelay < self.time then
        self:close()

        if self.callbackFunc ~= nil then
            if self.target ~= nil then
                self.callbackFunc(self.target, fillLevelLimits, showHelpInfo)
            else
                self.callbackFunc(fillLevelLimits)
            end
        end
    end
end

function FillLevelLimiterGui:setYesButtonDisabled(disabled)
    self.isYesButtonDisabled = disabled
    self.yesButton:setDisabled(disabled)
end

function FillLevelLimiterGui:setResetButtonDisabled(disabled)
    self.isResetButtonDisabled = disabled
    self.resetButton:setDisabled(disabled)
end
