--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 12.12.2019 - Release Version

Concept/Idea:
Anil

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


FillLevelLimiterSpec = {}

FillLevelLimiterSpec.DEFAULT_SPLIT_TRAILERS = {
    ["data/vehicles/lodeKing/distinction/distinction.xml"] = true,
    ["data/vehicles/wilsonTrailer/pacesetter/pacesetter.xml"] = true
}

function FillLevelLimiterSpec.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FillUnit, specializations)
end

function FillLevelLimiterSpec.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "addFillUnitFillLevel", FillLevelLimiterSpec.addFillUnitFillLevel)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getFillUnitFreeCapacity", FillLevelLimiterSpec.getFillUnitFreeCapacity)
end

function FillLevelLimiterSpec.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onDraw", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onReadUpdateStream", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteUpdateStream", FillLevelLimiterSpec)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", FillLevelLimiterSpec)
end

function FillLevelLimiterSpec.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "getFillUnitLimit", FillLevelLimiterSpec.getFillUnitLimit)
    SpecializationUtil.registerFunction(vehicleType, "setFillUnitLimit", FillLevelLimiterSpec.setFillUnitLimit)
    SpecializationUtil.registerFunction(vehicleType, "getFillUnitTitle", FillLevelLimiterSpec.getFillUnitTitle)
    SpecializationUtil.registerFunction(vehicleType, "updateFillUnitLimits", FillLevelLimiterSpec.updateFillUnitLimits)
end

function FillLevelLimiterSpec:onLoad(savegame)
    self.spec_fillLevelLimiter = {}
    local spec = self.spec_fillLevelLimiter

    spec.actionEvents = {}
    spec.showHelpInfo = true

    spec.fillUnitIndexToLimit = {}
    spec.numFillUnitLimits = 0

    spec.fillLimitReachedWarning = 0

    spec.fillUnitTitle = {}
    spec.consumerFillUnitIndexs = {}

    spec.fillLimitText = FillLevelLimiterSpec.getValidText("FLL_fillLimit", "%s - Limit: %d l")

    if self.spec_motorized ~= nil then
        for _, consumer in pairs(self.spec_motorized.consumersByFillTypeName) do
            spec.consumerFillUnitIndexs[consumer.fillUnitIndex] = consumer
        end
    end

    for fillUnitIndex, _ in ipairs(self.spec_fillUnit.fillUnits) do
        if spec.consumerFillUnitIndexs[fillUnitIndex] == nil then
            if spec.fillUnitIndexToLimit[fillUnitIndex] == nil then
                local defaultLimit = self:getFillUnitCapacity(fillUnitIndex)

                if defaultLimit ~= nil then
                    spec.fillUnitIndexToLimit[fillUnitIndex] = defaultLimit
                    spec.numFillUnitLimits = spec.numFillUnitLimits + 1
                end
            end
        end
    end

    local index = 1
    for fillUnitIndex, _ in pairs(spec.fillUnitIndexToLimit) do
        spec.fillUnitTitle[fillUnitIndex] = self:getFillUnitTitle(fillUnitIndex, index, spec.numFillUnitLimits)
        index = index + 1
    end

    spec.dirtyFlag = self:getNextDirtyFlag()
end

function FillLevelLimiterSpec:onPostLoad(savegame)
    local spec = self.spec_fillLevelLimiter

    if spec.numFillUnitLimits > 0 then
        if savegame ~= nil then
            local xmlFile = savegame.xmlFile
            local key = savegame.key .. ".FS19_FillLevelLimiter.fillLevelLimiter"

            spec.showHelpInfo = Utils.getNoNil(getXMLBool(xmlFile, key .. "#showHelpInfo"), true)

            local i = 0
            while true do
                local fillUnitKey = string.format("%s.fillUnit(%d)", key, i)
                if not hasXMLProperty(xmlFile, fillUnitKey) then
                    break
                end

                local fillUnitIndex = getXMLInt(xmlFile, fillUnitKey .. "#index")
                if fillUnitIndex ~= nil and spec.fillUnitIndexToLimit[fillUnitIndex] ~= nil then
                    local fillLimit = getXMLFloat(xmlFile, fillUnitKey .. "#limit")
                    if fillLimit ~= nil then
                        self:setFillUnitLimit(fillUnitIndex, fillLimit)
                    end
                end

                i = i + 1
            end
        end
    end
end

function FillLevelLimiterSpec:saveToXMLFile(xmlFile, key, usedModNames)
    local spec = self.spec_fillLevelLimiter

    if spec.numFillUnitLimits > 0 then
        if not spec.showHelpInfo then
            setXMLBool(xmlFile, key .. "#showHelpInfo", spec.showHelpInfo)
        end

        local i = 0
        for fillUnitIndex, fillLimit in pairs(spec.fillUnitIndexToLimit) do
            if fillLimit < self:getFillUnitCapacity(fillUnitIndex) then
                local fillUnitKey = string.format("%s.fillUnit(%d)", key, i)

                setXMLInt(xmlFile, fillUnitKey .. "#index", fillUnitIndex)
                setXMLFloat(xmlFile, fillUnitKey .. "#limit", fillLimit)

                i = i + 1
            end
        end
    end
end

function FillLevelLimiterSpec:onReadStream(streamId, connection)
    if connection:getIsServer() then
        local spec = self.spec_fillLevelLimiter

        local numLimits = streamReadInt8(streamId)

        if numLimits > 0 then
            spec.showHelpInfo = streamReadBool(streamId)

            for i = 1, numLimits do
                local fillUnitIndex = streamReadInt8(streamId)
                local limit = streamReadFloat32(streamId)

                self:setFillUnitLimit(fillUnitIndex, limit)
            end
        end
    end
end

function FillLevelLimiterSpec:onWriteStream(streamId, connection)
    if not connection:getIsServer() then
        local spec = self.spec_fillLevelLimiter

        local numLimits = spec.numFillUnitLimits
        streamWriteInt8(streamId, numLimits)

        if numLimits > 0 then
            streamWriteBool(streamId, spec.showHelpInfo)

            for fillUnitIndex, limit in pairs (spec.fillUnitIndexToLimit) do
                streamWriteInt8(streamId, fillUnitIndex)
                streamWriteFloat32(streamId, limit)
            end
        end
    end
end

function FillLevelLimiterSpec:onReadUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        if streamReadBool(streamId) then
            local fillLimitReachedWarning = streamReadInt8(streamId)

            if self.getIsActiveForInput ~= nil and self:getIsActiveForInput() then
                self.spec_fillLevelLimiter.fillLimitReachedWarning = fillLimitReachedWarning
            else
                self.spec_fillLevelLimiter.fillLimitReachedWarning = 0
            end
        end
    end
end

function FillLevelLimiterSpec:onWriteUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        local spec = self.spec_fillLevelLimiter

        if streamWriteBool(streamId, bitAND(dirtyMask, spec.dirtyFlag) ~= 0) then
            streamWriteInt8(streamId, spec.fillLimitReachedWarning)
        end
    end
end

function FillLevelLimiterSpec:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if isActiveForInput then
        local spec = self.spec_fillLevelLimiter

        if spec.numFillUnitLimits > 0 and spec.showHelpInfo then
            for fillUnitIndex, limit in pairs (spec.fillUnitIndexToLimit) do
                local defaultLevel = self:getFillUnitCapacity(fillUnitIndex)

                if defaultLevel ~= nil and limit < defaultLevel then
                    -- Do this here so it is rendered when two or more trailers are connected.
                    g_currentMission:addExtraPrintText(string.format(spec.fillLimitText, spec.fillUnitTitle[fillUnitIndex], limit, g_i18n:getVolumeUnit(true)))
                end
            end
        end
    end
end

function FillLevelLimiterSpec:onDraw(isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if isActiveForInput then
        local spec = self.spec_fillLevelLimiter

        if spec.fillLimitReachedWarning > 0 then
            local limit = self:getFillUnitLimit(spec.fillLimitReachedWarning)

            if limit ~= nil then
                local text = FillLevelLimiterSpec.getValidText("FLL_fillLimitReached", "Fill Limit: %d %s has been reached!")
                g_currentMission:showBlinkingWarning(string.format(text, limit, g_i18n:getVolumeUnit(false)))
            end

            spec.fillLimitReachedWarning = 0
        end
    end
end

function FillLevelLimiterSpec:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_fillLevelLimiter
        self:clearActionEventsTable(spec.actionEvents)

        if isActiveForInput and spec.numFillUnitLimits > 0 then
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.FLL_SET_FILL_LEVEL, self, FillLevelLimiterSpec.actionEventOpenUI, false, true, false, true, nil)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
        end
    end
end

function FillLevelLimiterSpec.actionEventOpenUI(self, actionName, inputValue, callbackState, isAnalog)
    local dialog = g_gui:showDialog("FillLevelLimiterGui")

    if dialog ~= nil then
        local vehicleName = self:getFullName() or "N/A"
        dialog.target:setTitle(vehicleName)
        dialog.target:setCallback(FillLevelLimiterSpec.updateFillUnitLimits, self)
        dialog.target:setData(self, self.spec_fillLevelLimiter.showHelpInfo)
    end
end

function FillLevelLimiterSpec:addFillUnitFillLevel(superFunc, farmId, fillUnitIndex, fillLevelDelta, fillTypeIndex, toolType, fillPositionData)
    local fillUnitLimit = self:getFillUnitLimit(fillUnitIndex)

    if fillUnitLimit ~= nil and fillUnitLimit < self:getFillUnitCapacity(fillUnitIndex) then
        local fillLevel = self:getFillUnitFillLevel(fillUnitIndex)

        if (fillLevel + fillLevelDelta) >= fillUnitLimit then
            fillLevelDelta = fillUnitLimit - fillLevel

            if self.isServer then
                local spec = self.spec_fillLevelLimiter

                if spec ~= nil then
                    spec.fillLimitReachedWarning = fillUnitIndex
                    self:raiseDirtyFlags(spec.dirtyFlag)
                end
            end
        end
    end

    return superFunc(self, farmId, fillUnitIndex, fillLevelDelta, fillTypeIndex, toolType, fillPositionData)
end

function FillLevelLimiterSpec:getFillUnitFreeCapacity(superFunc, fillUnitIndex, fillTypeIndex, farmId)
    if self.spec_fillLevelLimiter ~= nil then
        local spec = self.spec_fillUnit

        if spec.fillUnits[fillUnitIndex] ~= nil then
            local capacity = spec.fillUnits[fillUnitIndex].capacity
            local fillUnitLimit = self:getFillUnitLimit(fillUnitIndex)

            if fillUnitLimit ~= nil and fillUnitLimit < capacity then
                return fillUnitLimit - spec.fillUnits[fillUnitIndex].fillLevel
            end

            return capacity - spec.fillUnits[fillUnitIndex].fillLevel
        end

        return nil
    else
        return superFunc(self, fillUnitIndex, fillTypeIndex, farmId)
    end
end

function FillLevelLimiterSpec:getFillUnitLimit(fillUnitIndex)
    local spec = self.spec_fillLevelLimiter

    if spec ~= nil and fillUnitIndex ~= nil then
        return spec.fillUnitIndexToLimit[fillUnitIndex]
    end

    return nil
end

function FillLevelLimiterSpec:setFillUnitLimit(fillUnitIndex, limit)
    local spec = self.spec_fillLevelLimiter

    if fillUnitIndex ~= nil and spec.fillUnitIndexToLimit[fillUnitIndex] ~= nil then
        local maxLimit = self:getFillUnitCapacity(fillUnitIndex) or 1

        if limit == nil then
            limit = maxLimit
        end

        spec.fillUnitIndexToLimit[fillUnitIndex] = MathUtil.clamp(limit, 1, maxLimit)
    end
end

function FillLevelLimiterSpec:updateFillUnitLimits(limitsTable, showHelpInfo, noEventSend)
    local spec = self.spec_fillLevelLimiter

    showHelpInfo = Utils.getNoNil(showHelpInfo, spec.showHelpInfo)

    FillLevelLimiterSpecEvent.sendEvent(self, limitsTable, showHelpInfo, noEventSend)

    if limitsTable ~= nil then
        for fillUnitIndex, limit in pairs (limitsTable) do
            if limit ~= self:getFillUnitLimit(fillUnitIndex) then
                self:setFillUnitLimit(fillUnitIndex, limit)
            end
        end
    end

    spec.showHelpInfo = showHelpInfo
end

function FillLevelLimiterSpec:getFillUnitTitle(fillUnitIndex, index, numFillUnitLimits)
    index = Utils.getNoNil(index, 1)
    numFillUnitLimits = Utils.getNoNil(numFillUnitLimits, 1)

    local title = string.format(FillLevelLimiterSpec.getValidText("FLL_fillUnit", "Fill Unit %d"), index)

    if (self.spec_sowingMachine ~= nil and self.spec_sowingMachine.fillUnitIndex == fillUnitIndex)
        or (self.spec_sprayer ~= nil and self.spec_sprayer.fillUnitIndex == fillUnitIndex) then

        local supportedFillTypes = self:getFillUnitSupportedFillTypes(fillUnitIndex)
        if supportedFillTypes ~= nil then
            local concatedTitles = {}

            for fillTypeIndex, _ in pairs (supportedFillTypes) do
                local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
                if fillType ~= nil then
                    table.insert(concatedTitles, fillType.title)
                end
            end

            title = table.concat(concatedTitles, ", ")
        end
    elseif numFillUnitLimits > 1 then
        if FillLevelLimiterSpec.DEFAULT_SPLIT_TRAILERS[self.configFileName] then
            if index == 1 then
                title = string.format(FillLevelLimiterSpec.getValidText("FLL_fillUnitFront", "Fill Unit %d (Front)"), index)
            else
                title = string.format(FillLevelLimiterSpec.getValidText("FLL_fillUnitRear", "Fill Unit %d (Rear)"), index)
            end
        end
    end

    return title
end

function FillLevelLimiterSpec.getValidText(text, backup)
    if g_i18n:hasText(text) then
        return g_i18n:getText(text)
    end

    return backup
end
