/*
 * Decompiled with CFR 0.152.
 */
package ccw.wafflekingdom.tits.tools;

import ccw.wafflekingdom.tits.tits;
import exnihilo.items.hammers.IHammer;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.HarvestTool;
import tconstruct.tools.TinkerTools;

public class SkyHammer
extends HarvestTool
implements IHammer {
    private static ArrayList<Smashable> rewards = new ArrayList();

    public SkyHammer() {
        super(3);
    }

    public String getIconSuffix(int i) {
        switch (i) {
            case 0: {
                return "_skyhammer_head";
            }
            case 1: {
                return "_skyhammer_head_broken";
            }
            case 2: {
                return "_skyhammer_handle";
            }
            case 3: {
                return "_skyhammer_accessory";
            }
        }
        return "";
    }

    public String getEffectSuffix() {
        return "_skyhammer_effect";
    }

    public String getDefaultFolder() {
        return "skyhammer";
    }

    public String getDefaultTexturePath() {
        return "tinker:" + this.getDefaultFolder();
    }

    public Item getHeadItem() {
        return TinkerTools.hammerHead;
    }

    public Item getAccessoryItem() {
        return TinkerTools.binding;
    }

    public Item getHandleItem() {
        return TinkerTools.toolRod;
    }

    public String[] getTraits() {
        return new String[]{"tool", "utility", "melee", "harvest", "weapon"};
    }

    protected Material[] getEffectiveMaterials() {
        return new Material[0];
    }

    protected String getHarvestType() {
        return "";
    }

    public String getModifyType() {
        return "Tool";
    }

    public void prepSmashables() {
        for (Map.Entry itemInfoArrayListEntry : HammerRegistry.getRewards().entrySet()) {
            ArrayList next = (ArrayList)itemInfoArrayListEntry.getValue();
            for (Smashable smashingThrashingDashing : next) {
                tits.logger.info((Object)smashingThrashingDashing);
                rewards.add(smashingThrashingDashing);
            }
        }
    }

    public float getDigSpeed(ItemStack item, Block block, int meta) {
        if (!item.func_77942_o()) {
            return 0.0f;
        }
        NBTTagCompound tags = item.func_77978_p();
        if (tags.func_74775_l("InfiTool").func_74767_n("Broken")) {
            return 0.1f;
        }
        return HammerRegistry.registered((ItemStack)new ItemStack(block, 1, meta)) ? (float)item.func_77978_p().func_74775_l("InfiTool").func_74762_e("MiningSpeed") * 0.0075f : 1.0f;
    }

    public static Block[] getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Smashable reward : rewards) {
            if (blocks.contains(reward.source)) continue;
            blocks.add(reward.source);
        }
        return blocks.toArray(new Block[blocks.size()]);
    }

    public boolean isHammer(ItemStack itemStack) {
        return true;
    }

    public boolean isEffective(Block block, int meta) {
        boolean out = false;
        for (Smashable reward : rewards) {
            if (!reward.source.equals(block)) continue;
            out = true;
        }
        tits.logger.info((Object)out);
        return out || this.isEffective(block.func_149688_o());
    }

    public boolean isEffective(Material material) {
        boolean out = false;
        for (Smashable reward : rewards) {
            if (!reward.source.func_149688_o().equals(material)) continue;
            out = true;
        }
        tits.logger.info((Object)out);
        return out;
    }
}

