local assets=
{ 
   Asset("ANIM", "anim/rtyshenjian.zip"),
   Asset("ANIM", "anim/rtyshenjian_swap.zip"), 
   
   Asset("ATLAS", "images/inventoryimages/rtyshenjian.xml"),
   Asset("IMAGE", "images/inventoryimages/rtyshenjian.tex"),
}

local prefabs = 
{
}
local attackNum
local tempAttackNum
local attackState


-----初始化
local initDamage
local maxDamage
local nowDamage
local riseDamage
local perPlayNumMaxDamage
local perPlayNumRiseDamage
local function init(inst)
	attackNum=0
	tempAttackNum=0
	attackState=0

	initDamage=48
	perPlayNumMaxDamage=100	
	perPlayNumRiseDamage=2
	riseDamage=3
	maxDamage=500
	inst.components.weapon:SetDamage(initDamage)	
	nowDamage=initDamage
end

local function lightningstrike(lightningstriketarget)
        local x, y, z = lightningstriketarget.Transform:GetWorldPosition()
	local lightning = SpawnPrefab("lightning")
	lightning.Transform:SetPosition(x, y, z)
end

local function onattack(inst, attacker, target )
	local playernum=0
	local nowMaxDamage=0
	attackNum=attackNum+1
	local pos = Vector3(attacker.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 6)
		for k,v in pairs(ents) do
			if v:HasTag("player") and not v:HasTag("playerghost") then
			   playernum=playernum+1
		end
	end
	nowMaxDamage=playernum*100
	nowDamage=nowDamage+riseDamage+perPlayNumRiseDamage*playernum
	if nowMaxDamage>maxDamage then
		nowMaxDamage=maxDamage
	end
	if nowDamage > nowMaxDamage then
		nowDamage=nowMaxDamage
		inst.components.weapon:SetDamage(nowDamage)
	else
		inst.components.weapon:SetDamage(nowDamage)
	end
        ----每次攻击掉饥饿
	attacker.components.hunger:DoDelta(-1)
	-- 随机攻击效果
	local attackran=math.random(100)
	-- 0到16
	if attackran < 12 then
		attacker.components.talker:Say("+1s")
		attacker.components.health:DoDelta(9)
		attacker.components.sanity:DoDelta(2)
	end
	if attacker.components.hunger.current < 1 then
		attacker.components.talker:Say("焚吾之命，与敌决死！！！\n健康-30")
		attacker.components.health:DoDelta(-30)
	end	
end

local function canshifa(staff, caster, target, pos)
    if (not target:HasTag("player")) and (not target:HasTag("companion")) then
       return true
    end
    return false
end



local function shifa_func(inst, target)
	local caster = inst.components.inventoryitem.owner
	caster.components.talker:Say("兔子急了也咬人！\n 生命燃烧-99 雷击2500伤害！")	
		lightningstrike(target)
		target.components.health:DoDelta(-2500)
		caster.components.health:DoDelta(-99)
end

local function OnEquip(inst, owner) 
	init(inst)
	if  inst.components.spellcaster == nil then
		inst:AddComponent("spellcaster")	
		inst.components.spellcaster.CanCast = canshifa  
		inst.components.spellcaster:SetSpellFn(shifa_func)
		inst.components.spellcaster.canuseontargets = true
		inst.components.spellcaster.canusefrominventory = false
		inst.components.spellcaster.canonlyuseonlocomotors = true
	end
	
	owner.AnimState:OverrideSymbol("swap_object", "rtyshenjian_swap", "rtyshenjian")
	owner.AnimState:Show("ARM_carry") 
	owner.AnimState:Hide("ARM_normal") 
	inst.task = inst:DoPeriodicTask(1, function (inst)		
		if attackNum ~= tempAttackNum then
			tempAttackNum=attackNum
			attackState=0
		else
			attackState=attackState+1
			if attackState > 8 then
			init(inst)
			end
		end
	end)
end

local function OnUnequip(inst, owner) 	
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal") 
	if inst.components.spellcaster ~= nil then
		inst:RemoveComponent("spellcaster")
	end
	init(inst)
	inst.task:Cancel()
	inst.task = nil
end

	
local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
    inst.entity:AddNetwork ()

    anim:SetBank("rtyshenjian")
    anim:SetBuild("rtyshenjian")
    anim:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
		 return inst
	end	

    inst:AddComponent("inspectable")
    	
    inst.castsound = "dontstarve/common/staffteleport"
    
     
     inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = false
	inst.components.inventoryitem.imagename = "rtyshenjian"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/rtyshenjian.xml"  

    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)
    
    inst:AddComponent("weapon")	
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 1.33)
    inst.components.tool:SetAction(ACTIONS.MINE, 1.33)
    inst.components.tool:SetAction(ACTIONS.DIG)
    inst:AddInherentAction(ACTIONS.DIG)
    inst.components.tool:SetAction(ACTIONS.HAMMER)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
   -----初始化
    init(inst)


    return inst
end

return  Prefab("common/inventory/rtyshenjian", fn, assets, prefabs)