--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
File: armor.lua
Modded Section(s):Header, TakeDamage
*********************************************************************************************************
]]

--[[MODNOTE: Mod Variable Declaration ]]--
local foldername = KnownModIndex:GetModActualName("Tweak Those Tools, Tweaked!")
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY", foldername)
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY", foldername)
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY", foldername)
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY", foldername)
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY", foldername)
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY", foldername)
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY", foldername)
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY", foldername)
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY", foldername)
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY", foldername)
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY", foldername)
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION", foldername)
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION", foldername)
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY", foldername)
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS", foldername)
--[[MODNOTE: End Mod Variables ]]--

--[[MODNOTE: Mod Debug Function ]]--
local function ModDeBug(inst,condition)
	local DebugTag = "N/A"
	local DebugDura = "N/A"
	if DEBUGOPTIONS ~= "Off" then
		if DEBUGOPTIONS == "Weapon" then
			DebugTag = "TweakWeapon"
			DebugDura = WEAPON_DURABILITY
		elseif DEBUGOPTIONS == "Staff" then
			DebugTag = "TweakStaff"
			DebugDura = STAFF_DURABILITY
		elseif DEBUGOPTIONS == "Amulet" then
			DebugTag = "TweakAmulet"
			DebugDura = AMULET_DURABILITY
		elseif DEBUGOPTIONS == "Tool" then
			DebugTag = "TweakTool"
			DebugDura = TOOL_DURABILITY
		elseif DEBUGOPTIONS == "GoldTool" then
			DebugTag = "TweakGold"
			DebugDura = GOLD_DURABILITY
		elseif DEBUGOPTIONS == "Trap" then
			DebugTag = "TweakTrap"
			DebugDura = TRAP_DURABILITY
		elseif DEBUGOPTIONS == "Armor" then
			DebugTag = "TweakArmor"
			DebugDura = ARMOR_DURABILITY
		elseif DEBUGOPTIONS == "Clothing" then
			DebugTag = "TweakClothes"
			DebugDura = CLOTHING_DURABILITY
		elseif DEBUGOPTIONS == "Light" then
			DebugTag = "TweakLight"
			DebugDura = LIGHT_DURABILITY
		elseif DEBUGOPTIONS == "Camping" then
			DebugTag = "TweakCamping"
			DebugDura = CAMPING_DURABILITY
		elseif DEBUGOPTIONS == "Book" then
			DebugTag = "TweakBook"
			DebugDura = BOOK_DURABILITY
		elseif DEBUGOPTIONS == "Food" then
			if FOOD_SELECTION == "Preserved" then 
				DebugTag = "TweakJerky"
			else
				DebugTag = "TweakFood"
			end
			DebugDura = FOOD_PRESERVATION
		elseif DEBUGOPTIONS == "Boat" then
			DebugTag = "TweakBoat"
			DebugDura = BOAT_DURABILITY
		end
	end

	if inst:HasTag(DebugTag) then
		print(inst.name.. " - Tweaked. Durability: " .. DebugDura .. ". " .. condition .. " durability left.")
	end
end

--[[MODNOTE: End Mod Debug Function ]]--

local function PercentChanged(inst, data)
    if inst.components.armor
       and data.percent and data.percent <= 0
       and inst.components.inventoryitem and inst.components.inventoryitem.owner then
        inst.components.inventoryitem.owner:PushEvent("armorbroke", {armor = inst})
        --ProfileStatsSet("armor_broke_" .. inst.prefab, true)
    end
end

local Armor = Class(function(self, inst)
    self.inst = inst
    self.condition = 100
    self.maxcondition = 100
    self.tags = nil
    self.inst:ListenForEvent("percentusedchange", PercentChanged)
end)

function Armor:InitCondition(amount, absorb_percent)
    self.condition = amount
	self.absorb_percent = absorb_percent
    self.maxcondition = amount
end

function Armor:GetPercent(amount)
    return self.condition / self.maxcondition
end


function Armor:SetTags(tags)
    self.tags = tags
end

function Armor:SetAbsorption(absorb_percent)
    self.absorb_percent = absorb_percent
end

function Armor:SetPercent(amount)
    self:SetCondition(self.maxcondition * amount)
end

function Armor:SetCondition(amount)
    self.condition = amount
    self.inst:PushEvent("percentusedchange", {percent = self:GetPercent()})   
    
    if self.condition <= 0 then
        self.condition = 0
        ProfileStatsSet("armor_broke_" .. self.inst.prefab, true)
        ProfileStatsSet("armor", self.inst.prefab)
        
        if METRICS_ENABLED then
			FightStat_BrokenArmor(self.inst.prefab)
		end
		
        if self.onfinished then
            self.onfinished()
        end
        
        self.inst:Remove()
    end
end

function Armor:OnSave()
    if self.condition ~= self.maxcondition then
        return {condition = self.condition}
    end
end

function Armor:OnLoad(data)
    if data.condition then
        self:SetCondition(data.condition)
    end
end

function Armor:CanResist(attacker, weapon)
    if attacker and self.tags then
	    for k,v in pairs(self.tags) do
		    if attacker:HasTag(v) then
			    return true
		    end
		    if weapon and weapon:HasTag(v) then
			    return true
		    end
	    end
	    return false
	else
	    return self.tags == nil
	end
end

function Armor:TakeDamage(damage_amount, attacker, weapon)
    if self:CanResist(attacker, weapon) then
        local leftover = damage_amount
        
        local max_absorbed = damage_amount * self.absorb_percent;
        local absorbed = math.floor(math.min(max_absorbed, self.condition))
        leftover = damage_amount - absorbed
        ProfileStatsAdd("armor_absorb", absorbed)
        
        if METRICS_ENABLED then
			FightStat_Absorb(absorbed)
		end
		
		--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
		--[[self:SetCondition(self.condition - absorbed)]]--  Original Text for this section
	
		--[[Get the tags for the item currently being processed, and change our variable to match]]--
		local DURABILITYSETTING = "Default"
			
		if self.inst:HasTag("TweakClothes") then
			DURABILITYSETTING = CLOTHING_DURABILITY
		elseif self.inst:HasTag("TweakWeapon") then
			DURABILITYSETTING = WEAPON_DURABILITY
		elseif self.inst:HasTag("TweakStaff") then
			DURABILITYSETTING = STAFF_DURABILITY
		elseif self.inst:HasTag("TweakAmulet") then
			DURABILITYSETTING = AMULET_DURABILITY
		elseif self.inst:HasTag("TweakTool") then
			DURABILITYSETTING = TOOL_DURABILITY
		elseif self.inst:HasTag("TweakGold") then
			DURABILITYSETTING = GOLD_DURABILITY
		elseif self.inst:HasTag("TweakTrap") then
			DURABILITYSETTING = TRAP_DURABILITY
		elseif self.inst:HasTag("TweakArmor") then
			DURABILITYSETTING = ARMOR_DURABILITY
		elseif self.inst:HasTag("TweakLight") then
			DURABILITYSETTING = LIGHT_DURABILITY
		elseif self.inst:HasTag("TweakCamping") then
			DURABILITYSETTING = CAMPING_DURABILITY
		elseif self.inst:HasTag("TweakBook") then
			DURABILITYSETTING = BOOK_DURABILITY
		elseif self.inst:HasTag("TweakJerky") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakFood") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakBoat") then
				DURABILITYSETTING = BOAT_DURABILITY
		end
	
		if DURABILITYSETTING ~= "Default" then
			if DURABILITYSETTING == "Infinite" then
				self:SetCondition(self.condition)
			else
				self:SetCondition(self.condition - (absorbed / DURABILITYSETTING))
			end
		else
			self:SetCondition(self.condition - absorbed)
		end
	
		ModDeBug(self.inst,self.condition)  --[[MODNOTE: Send Debug Message as requested by mod]]--
		--[[MODNOTE: End of Modded Section]]--	
		
		if self.ontakedamage then
			self.ontakedamage(self.inst, damage_amount, absorbed, leftover)
		end

        if self.absorb_percent >= 1 then
            return 0
        end

        return leftover
    else
        return damage_amount
    end
   
end



return Armor
