--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
File: boathealth.lua
Modded Section(s): Header, BoatHealth:DoDelta
*********************************************************************************************************
]]

--[[MODNOTE: Mod Variable Declaration ]]--
local foldername = KnownModIndex:GetModActualName("Tweak Those Tools, Tweaked!")
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY", foldername)
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY", foldername)
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY", foldername)
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY", foldername)
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY", foldername)
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY", foldername)
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY", foldername)
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY", foldername)
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY", foldername)
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY", foldername)
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY", foldername)
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION", foldername)
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION", foldername)
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY", foldername)
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS", foldername)
--[[MODNOTE: End Mod Variables ]]--

--[[MODNOTE: Mod Debug Function ]]--
local function ModDeBug(inst,currenthealth,maxhealth)
	local DebugTag = "N/A"
	local DebugDura = "N/A"
	if DEBUGOPTIONS ~= "Off" then
		if DEBUGOPTIONS == "Weapon" then
			DebugTag = "TweakWeapon"
			DebugDura = WEAPON_DURABILITY
		elseif DEBUGOPTIONS == "Staff" then
			DebugTag = "TweakStaff"
			DebugDura = STAFF_DURABILITY
		elseif DEBUGOPTIONS == "Amulet" then
			DebugTag = "TweakAmulet"
			DebugDura = AMULET_DURABILITY
		elseif DEBUGOPTIONS == "Tool" then
			DebugTag = "TweakTool"
			DebugDura = TOOL_DURABILITY
		elseif DEBUGOPTIONS == "GoldTool" then
			DebugTag = "TweakGold"
			DebugDura = GOLD_DURABILITY
		elseif DEBUGOPTIONS == "Trap" then
			DebugTag = "TweakTrap"
			DebugDura = TRAP_DURABILITY
		elseif DEBUGOPTIONS == "Armor" then
			DebugTag = "TweakArmor"
			DebugDura = ARMOR_DURABILITY
		elseif DEBUGOPTIONS == "Clothing" then
			DebugTag = "TweakClothes"
			DebugDura = CLOTHING_DURABILITY
		elseif DEBUGOPTIONS == "Light" then
			DebugTag = "TweakLight"
			DebugDura = LIGHT_DURABILITY
		elseif DEBUGOPTIONS == "Camping" then
			DebugTag = "TweakCamping"
			DebugDura = CAMPING_DURABILITY
		elseif DEBUGOPTIONS == "Book" then
			DebugTag = "TweakBook"
			DebugDura = BOOK_DURABILITY
		elseif DEBUGOPTIONS == "Food" then
			if FOOD_SELECTION == "Preserved" then 
				DebugTag = "TweakJerky"
			else
				DebugTag = "TweakFood"
			end
			DebugDura = FOOD_PRESERVATION
		elseif DEBUGOPTIONS == "Boat" then
			DebugTag = "TweakBoat"
			DebugDura = BOAT_DURABILITY
		end
	end

	if inst:HasTag(DebugTag) then
		print(inst.name.. " - Tweaked. Durability: " .. DebugDura .. ". " .. currenthealth .. "/" .. maxhealth .. " before destruction.")
	end
end

--[[MODNOTE: End Mod Debug Function ]]--

local BoatHealth = Class(function(self, inst)
    self.inst = inst
    self.consuming = false
    
    self.maxhealth = 100
    self.currenthealth = 0
    self.rate = 1

    self.period = 1
    self.bonusmult = 1
    self.depleted = nil
    self.depletionmultiplier = 1

    self.base_damage_scale = 1
    self.wave_damage_scale = 1
    self.attack_damage_scale = 1

    self.leakinghealth = 0

    self.damagesound = nil 

    self.moving = false
    self.invincible = false

    self.inst:ListenForEvent( "boatstartmoving", function() 
        self.moving = true
    end, self.inst)

    self.inst:ListenForEvent( "boatstopmoving", function() 
        self.moving = false 
    end, self.inst)
end)


function BoatHealth:MakeEmpty()
	if self.currenthealth > 0 then
		self:DoDelta(-self.currenthealth)
	end
end

function BoatHealth:OnSave()
    return {health = self.currenthealth, rate = self.rate}
end

function BoatHealth:OnLoad(data)
    self.rate = data.rate
    if data.health then
        self:SetHealth(data.health)
    end
end

function BoatHealth:SetDepletedFn(fn)
    self.depleted = fn
end

function BoatHealth:IsEmpty()
    return self.currenthealth <= 0
end

function BoatHealth:SetUpdateFn(fn)
    self.updatefn = fn
end

function BoatHealth:GetDebugString()
    
    return string.format("%s %2.2f/%2.2f (-%2.2f)", self.consuming and "ON" or "OFF", self.currenthealth, self.maxhealth, self.rate)
end

function BoatHealth:GetPercent()
    if self.maxhealth > 0 then 
        return math.min(1, self.currenthealth / self.maxhealth)
    else
        return 0
    end
end

function BoatHealth:IsInvincible()
    return self.invincible
end

function BoatHealth:SetInvincible(val)
    self.invincible = val
    self.inst:PushEvent("boatinvincibletoggle", {invincible = val})
end

function BoatHealth:SetIsMoving(move)
    self.moving = move
end

function BoatHealth:SetPercent(amount)
    local target = (self.maxhealth * amount)
    self:DoDelta(target - self.currenthealth)
end

function BoatHealth:StartConsuming()
    self.consuming = true
    if self.task == nil then
        self.task = self.inst:DoPeriodicTask(self.period, function() self:DoUpdate(self.period) end)
    end
end

function BoatHealth:IsDead()
    return self.currenthealth <= 0
end

function BoatHealth:SetHealth(hp, perishtime)
    local oldpercent = self:GetPercent()
    if self.maxhealth < hp then
        self.maxhealth = hp
    end
    if perishtime then
        self.rate = hp / perishtime
    end
    self.currenthealth = hp
    self.inst:PushEvent("boathealthchange", {percent = self:GetPercent(), oldpercent = oldpercent, damage = false, hp = hp})
end

function BoatHealth:DoDelta(amount, damageType, source, ignore_invincible)
    if self.invincible and not ignore_invincible then
        return
    end

    if not self.moving and damageType == nil then
        return
    end

    if damageType == "combat" or damageType == "wave" then
        if self.damagesound then
            if self.inst.components.drivable and self.inst.components.drivable.driver then
                self.inst.SoundEmitter:PlaySound(self.damagesound)
            end
        end
    end

    if self.moving and damageType == nil then
        amount = amount * self.depletionmultiplier
    end


    local oldpercent = self:GetPercent()

	--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
	--[[self.currenthealth = math.max(0, math.min(self.maxhealth, self.currenthealth + amount) )]]--  Original Text for this section
	
	--[[Get the tags for the item currently being processed, and change our variable to match]]--
	local DURABILITYSETTING = "Default"
		
	if self.inst:HasTag("TweakClothes") then
		DURABILITYSETTING = CLOTHING_DURABILITY
	elseif self.inst:HasTag("TweakWeapon") then
		DURABILITYSETTING = WEAPON_DURABILITY
	elseif self.inst:HasTag("TweakStaff") then
		DURABILITYSETTING = STAFF_DURABILITY
	elseif self.inst:HasTag("TweakAmulet") then
		DURABILITYSETTING = AMULET_DURABILITY
	elseif self.inst:HasTag("TweakTool") then
		DURABILITYSETTING = TOOL_DURABILITY
	elseif self.inst:HasTag("TweakGold") then
		DURABILITYSETTING = GOLD_DURABILITY
	elseif self.inst:HasTag("TweakTrap") then
		DURABILITYSETTING = TRAP_DURABILITY
	elseif self.inst:HasTag("TweakArmor") then
		DURABILITYSETTING = ARMOR_DURABILITY
	elseif self.inst:HasTag("TweakLight") then
		DURABILITYSETTING = LIGHT_DURABILITY
	elseif self.inst:HasTag("TweakCamping") then
		DURABILITYSETTING = CAMPING_DURABILITY
	elseif self.inst:HasTag("TweakBook") then
		DURABILITYSETTING = BOOK_DURABILITY
	elseif self.inst:HasTag("TweakJerky") then
		DURABILITYSETTING = FOOD_PRESERVATION
	elseif self.inst:HasTag("TweakFood") then
		DURABILITYSETTING = FOOD_PRESERVATION
	elseif self.inst:HasTag("TweakBoat") then
			DURABILITYSETTING = BOAT_DURABILITY
	end
	
	
	if amount >= 1 then  -- Check to see if we're adding fuel to our item, and thus do not need to tweak the value
		self.currenthealth = math.max(0, math.min(self.maxhealth, self.currenthealth + amount) )
	else
		if DURABILITYSETTING ~= "Default" then
			if DURABILITYSETTING == "Infinite" then
				self.currenthealth = self.currenthealth
			else
				self.currenthealth = math.max(0, math.min(self.maxhealth, self.currenthealth + (amount / DURABILITYSETTING)) )
			end
		else
			self.currenthealth = math.max(0, math.min(self.maxhealth, self.currenthealth + amount) )
		end
	end
		
	ModDeBug(self.inst,self.currenthealth,self.maxhealth)  --[[MODNOTE: Send Debug Message as requested by mod]]--
	--[[MODNOTE: End of Modded Section]]--
    
    if self.currenthealth <= 0 and self.depleted then
        --This isn't great but deferring the function call is needed to fix a potential crash when dying from hitting a wave
        --When getting depleted by hitting a wave this function will be called from the waves onCollision callback 
        --The depleted function for boats causes the player to switch collision shapes which will cause a crash when done in the midst of the physics engine processing collisions 
        self.inst:DoTaskInTime(0, self.depleted) 
    end

    local isDamage = damageType == "wave" or damageType == "combat" or damageType == "fire"
    self.inst:PushEvent("boathealthchange", {percent = self:GetPercent(), oldpercent = oldpercent, damage = isDamage, currenthealth = self.currenthealth, maxhealth = self.maxhealth})
end

function BoatHealth:DoUpdate( dt )
    if self.consuming then
        self:DoDelta(-dt*self.rate)
    end
    
    if self:IsEmpty() then
        self:StopConsuming()
    end
    
    if self.updatefn then
        self.updatefn(self.inst)
    end
end

function BoatHealth:StopConsuming()
    self.consuming = false
    if self.task then
        self.task:Cancel()
        self.task = nil
    end
end

function BoatHealth:LongUpdate(dt)
	self:DoUpdate(dt)
end

function BoatHealth:IsLeaking()
    return self.currenthealth <= self.leakinghealth
end

return BoatHealth
