--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
File: perishable.lua
Modded Section(s): Header, Update
*********************************************************************************************************
]]

--[[MODNOTE: Mod Variable Declaration ]]--
local foldername = KnownModIndex:GetModActualName("Tweak Those Tools, Tweaked!")
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY", foldername)
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY", foldername)
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY", foldername)
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY", foldername)
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY", foldername)
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY", foldername)
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY", foldername)
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY", foldername)
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY", foldername)
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY", foldername)
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY", foldername)
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION", foldername)
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION", foldername)
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY", foldername)
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS", foldername)
local SWDLC = ""

if IsDLCEnabled(CAPY_DLC) then
	SWDLC = true
else
	SWDLC = false
end

if IsDLCEnabled(REIGN_OF_GIANTS) then
	ROGDLC = true
else
	ROGDLC = false
end

--[[MODNOTE: End Mod Variables ]]--

--[[MODNOTE: Mod Debug Function ]]--
local function ModDeBug(inst, owner)
	local DebugTag = "N/A"
	local DebugDura = "N/A"
	if DEBUGOPTIONS ~= "Off" then
		if DEBUGOPTIONS == "Weapon" then
			DebugTag = "TweakWeapon"
			DebugDura = WEAPON_DURABILITY
		elseif DEBUGOPTIONS == "Staff" then
			DebugTag = "TweakStaff"
			DebugDura = STAFF_DURABILITY
		elseif DEBUGOPTIONS == "Amulet" then
			DebugTag = "TweakAmulet"
			DebugDura = AMULET_DURABILITY
		elseif DEBUGOPTIONS == "Tool" then
			DebugTag = "TweakTool"
			DebugDura = TOOL_DURABILITY
		elseif DEBUGOPTIONS == "GoldTool" then
			DebugTag = "TweakGold"
			DebugDura = GOLD_DURABILITY
		elseif DEBUGOPTIONS == "Trap" then
			DebugTag = "TweakTrap"
			DebugDura = TRAP_DURABILITY
		elseif DEBUGOPTIONS == "Armor" then
			DebugTag = "TweakArmor"
			DebugDura = ARMOR_DURABILITY
		elseif DEBUGOPTIONS == "Clothing" then
			DebugTag = "TweakClothes"
			DebugDura = CLOTHING_DURABILITY
		elseif DEBUGOPTIONS == "Light" then
			DebugTag = "TweakLight"
			DebugDura = LIGHT_DURABILITY
		elseif DEBUGOPTIONS == "Camping" then
			DebugTag = "TweakCamping"
			DebugDura = CAMPING_DURABILITY
		elseif DEBUGOPTIONS == "Book" then
			DebugTag = "TweakBook"
			DebugDura = BOOK_DURABILITY
		elseif DEBUGOPTIONS == "Food" then
			if FOOD_SELECTION == "Preserved" then 
				DebugTag = "TweakJerky"
			else
				DebugTag = "TweakFood"
			end
			DebugDura = FOOD_PRESERVATION
		elseif DEBUGOPTIONS == "Boat" then
			DebugTag = "TweakBoat"
			DebugDura = BOAT_DURABILITY
		end
	end

	if inst:HasTag(DebugTag) then
		print(inst.name.. " - Tweaked. Durability: " .. DebugDura .. ". " .. inst.components.perishable.perishremainingtime .. " before perish.")
	end
end

--[[MODNOTE: End Mod Debug Function ]]--

local Perishable = Class(function(self, inst)
    self.inst = inst
    self.perishfn = nil
    self.perishtime = nil
	
	if SWDLC == true or ROGDLC == true then
		self.frozenfiremult = false
	end
    
    self.targettime = nil
    self.perishremainingtime = nil
    self.updatetask = nil
    self.dt = nil
    self.onperishreplacement = nil
end)



local function Update(inst, dt)
    if inst.components.perishable then
		
		local modifier = 1
		
		local FoodTweak = 1
		if FOOD_PRESERVATION ~= "Default" then
			if FOOD_PRESERVATION ~= "Infinite" then
				FoodTweak = FOOD_PRESERVATION
			end
		else
			FoodTweak = 1
		end
		
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner or nil
		if owner then
			if owner:HasTag("fridge") then
				if inst:HasTag("frozen") and not owner:HasTag("nocool") and not owner:HasTag("lowcool") then
					modifier = TUNING.PERISH_COLD_FROZEN_MULT
				else
					modifier = TUNING.PERISH_FRIDGE_MULT 
				end
			elseif owner:HasTag("spoiler") then
				modifier = TUNING.PERISH_GROUND_MULT 
			end
		else
			modifier = TUNING.PERISH_GROUND_MULT
		end
		
		local mm = ""
		if SWDLC == true or ROGDLC == true then
			-- Cool off hot foods over time (faster if in a fridge)
			if inst.components.edible and inst.components.edible.temperaturedelta and inst.components.edible.temperaturedelta > 0 then
				if owner and owner:HasTag("fridge") then
					if not owner:HasTag("nocool") then
						inst.components.edible.temperatureduration = inst.components.edible.temperatureduration - 1
					end
				elseif GetSeasonManager() and GetSeasonManager():GetCurrentTemperature() < TUNING.OVERHEAT_TEMP - 5 then
					inst.components.edible.temperatureduration = inst.components.edible.temperatureduration - .25
				end
				if inst.components.edible.temperatureduration < 0 then inst.components.edible.temperatureduration = 0 end
			end
			
			mm = GetWorld().components.moisturemanager
			if mm:IsEntityWet(inst) then
				modifier = modifier * TUNING.PERISH_WET_MULT
			end
		end
		
		if GetSeasonManager() and GetSeasonManager():GetCurrentTemperature() < 0 then
			if SWDLC == true and ROGDLC == true then
				if inst:HasTag("frozen") and not inst.components.perishable.frozenfiremult then
					modifier = TUNING.PERISH_COLD_FROZEN_MULT
				else
					modifier = modifier * TUNING.PERISH_WINTER_MULT
				end
			else
				modifier = modifier * TUNING.PERISH_WINTER_MULT
			end
		end
		
		if SWDLC == true or ROGDLC == true then
			if inst.components.perishable.frozenfiremult then
				modifier = modifier * TUNING.PERISH_FROZEN_FIRE_MULT
			end

			if GetSeasonManager() and GetSeasonManager():GetCurrentTemperature() > TUNING.OVERHEAT_TEMP then
				modifier = modifier * TUNING.PERISH_SUMMER_MULT
			end			
		end
		
		
		modifier = modifier * TUNING.PERISH_GLOBAL_MULT
		
		local old_val = inst.components.perishable.perishremainingtime
		
		local delta = ""
		if SWDLC == true or ROGDLC == true then
			delta = dt or (10 + math.random()*FRAMES*8)
		end
		
		--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
			--[[inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime - dt*modifier]]--  Original Text for this section
			
			local DURABILITYSETTING = "Default"
			
			if inst:HasTag("TweakClothes") then
				DURABILITYSETTING = CLOTHING_DURABILITY
			elseif inst:HasTag("TweakWeapon") then
				DURABILITYSETTING = WEAPON_DURABILITY
			elseif inst:HasTag("TweakStaff") then
				DURABILITYSETTING = STAFF_DURABILITY
			elseif inst:HasTag("TweakAmulet") then
				DURABILITYSETTING = AMULET_DURABILITY
			elseif inst:HasTag("TweakTool") then
				DURABILITYSETTING = TOOL_DURABILITY
			elseif inst:HasTag("TweakGold") then
				DURABILITYSETTING = GOLD_DURABILITY
			elseif inst:HasTag("TweakTrap") then
				DURABILITYSETTING = TRAP_DURABILITY
			elseif inst:HasTag("TweakArmor") then
				DURABILITYSETTING = ARMOR_DURABILITY
			elseif inst:HasTag("TweakLight") then
				DURABILITYSETTING = LIGHT_DURABILITY
			elseif inst:HasTag("TweakCamping") then
				DURABILITYSETTING = CAMPING_DURABILITY
			elseif inst:HasTag("TweakBook") then
				DURABILITYSETTING = BOOK_DURABILITY
			elseif inst:HasTag("TweakJerky") then
				DURABILITYSETTING = FOOD_PRESERVATION
			elseif inst:HasTag("TweakFood") then
				DURABILITYSETTING = FOOD_PRESERVATION
			elseif inst:HasTag("TweakBoat") then
				DURABILITYSETTING = BOAT_DURABILITY
			end
			
			if DURABILITYSETTING ~= "Default" then
				if DURABILITYSETTING == "Infinite" then
					inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime
				else
					if SWDLC == true then
						inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime - ((delta*modifier)/DURABILITYSETTING)
					else
						inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime - ((dt*modifier)/DURABILITYSETTING)
					end
				end
			else
				if SWDLC == true or ROGDLC == true then
					inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime - delta*modifier
				else
					inst.components.perishable.perishremainingtime = inst.components.perishable.perishremainingtime - dt*modifier
				end
			end
			
			ModDeBug(inst, owner)  --[[MODNOTE: Send Debug Message as requested by mod]]--
			
			--[[MODNOTE: End of Modded Section]]--	
		
		if math.floor(old_val*100) ~= math.floor(inst.components.perishable.perishremainingtime*100) then
	        inst:PushEvent("perishchange", {percent = inst.components.perishable:GetPercent()})
	    end
        
        --trigger the next callback
        if inst.components.perishable.perishremainingtime <= 0 then
			inst.components.perishable:Perish()
        end
    end
end


function Perishable:IsFresh()
	return self:GetPercent() >= .5 
end

function Perishable:IsStale()
	return self:GetPercent() < .5 and self:GetPercent() > .2
end


function Perishable:IsSpoiled()
	return self:GetPercent() <= .2 
end

if SWDLC == true or ROGDLC == true then
	function Perishable:GetAdjective()
		if self.inst.components.edible then
			if self:IsStale() then
				if self.inst:HasTag("frozen") then
					return STRINGS.UI.HUD.STALE_FROZEN
				else
					return STRINGS.UI.HUD.STALE
				end
			elseif self:IsSpoiled() then
				if self.inst:HasTag("frozen") then
					return STRINGS.UI.HUD.STALE_FROZEN
				else
					return STRINGS.UI.HUD.SPOILED
				end
			end
		elseif self.inst.components.eater then
			if self:IsStale() then
				return STRINGS.UI.HUD.HUNGRY
			elseif self:IsSpoiled() then
				return STRINGS.UI.HUD.STARVING
			end
		end
	end
else
	function Perishable:GetAdjective()
		if self.inst.components.edible then
			if self:IsStale() then
				return STRINGS.UI.HUD.STALE
			elseif self:IsSpoiled() then
				return STRINGS.UI.HUD.SPOILED
			end
		end
	end
end

function Perishable:Dilute(number, timeleft)
	if self.inst.components.stackable then
		self.perishremainingtime = (self.inst.components.stackable.stacksize * self.perishremainingtime + number * timeleft) / ( number + self.inst.components.stackable.stacksize )
		self.inst:PushEvent("perishchange", {percent = self:GetPercent()})
	end
end

function Perishable:SetPerishTime(time)
	self.perishtime = time
	self.perishremainingtime = time
end

function Perishable:SetOnPerishFn(fn)
	self.perishfn = fn
end

function Perishable:GetPercent()
	if self.perishremainingtime and self.perishtime and self.perishtime > 0 then
		return math.min(1, self.perishremainingtime / self.perishtime)
	else
		return 0
	end
end

function Perishable:SetPercent(percent)
	if percent < 0 then percent = 0 end
	if percent > 1 then percent = 1 end
	self.perishremainingtime = percent*self.perishtime
	if SWDLC == true or ROGDLC == true then
		self.inst:PushEvent("perishchange", {percent = self.inst.components.perishable:GetPercent()})
	end
end

function Perishable:ReducePercent(amount)
	local cur = self:GetPercent()
	self:SetPercent(cur - amount)
end

function Perishable:GetDebugString()
	if self.perishremainingtime and  self.perishremainingtime > 0 then
		return string.format("%s %2.2fs", self.updatetask and "Perishing" or "Paused", self.perishremainingtime)
	else
		return "perished"
	end
end

if SWDLC == true or ROGDLC == true then
	function Perishable:LongUpdate(dt)
		if self.updatetask then
			Update(self.inst, dt or 0)
		end
	end
else
	function Perishable:LongUpdate(dt)
		Update(self.inst, dt)
	end
end

function Perishable:StartPerishing()
    
	if self.updatetask then
		self.updatetask:Cancel()
		self.updatetask = nil
	end

    local dt = 10 + math.random()*FRAMES*8--math.max( 4, math.min( self.perishtime / 100, 10)) + ( math.random()* FRAMES * 8)

    if dt > 0 then
        self.updatetask = self.inst:DoPeriodicTask(dt, Update, math.random()*2, dt)
    else
        Update(self.inst, 0)
    end
end

function Perishable:Perish()
    
	if self.updatetask then
		self.updatetask:Cancel()
		self.updatetask = nil
	end
    
	if SWDLC == true or ROGDLC == true then
		self.inst:PushEvent("perished")
	end
	
    if self.perishfn then
        self.perishfn(self.inst)
    end
    
    if self.onperishreplacement then
		local goop = SpawnPrefab(self.onperishreplacement)
		if goop then
			local owner = self.inst.components.inventoryitem and self.inst.components.inventoryitem.owner or nil
			local pt = Vector3(self.inst.Transform:GetWorldPosition())
			local holder = owner and ( owner.components.inventory or owner.components.container) 
			local slot = holder and holder:GetItemSlot(self.inst)
			local floating = ""
			if SWDLC == true then
				floating = false 
				if self.inst.components.floatable then 
					floating = self.inst.components.floatable.onwater or false 
				end 
			end



			
			self.inst:Remove()
			if holder then
				holder:GiveItem(goop, slot)
			elseif SWDLC == true then
				goop.Transform:SetPosition(pt:Get())
				if floating then
					if goop.components.floatable then 
						goop.components.floatable:OnHitWater(true)
					else 
						local fx = SpawnPrefab("splash_water_sink")
                		fx.Transform:SetPosition(pt:Get())
                		goop:Remove()
					end 
				end 
			else
				goop.Transform:SetPosition(pt:Get())
			end
			
			if goop.components.stackable and self.inst.components.stackable then
				goop.components.stackable:SetStackSize(self.inst.components.stackable.stacksize)
			end
		end
    end
end

function Perishable:StopPerishing()
	if self.updatetask then
		self.updatetask:Cancel()
		self.updatetask = nil
	end
end


function Perishable:OnSave()
    local data = {}

    data.paused = self.updatetask == nil
    data.time = self.perishremainingtime

    return data
end   
      
function Perishable:OnLoad(data)

    if data and data.time then
		self.perishremainingtime = data.time
		if not data.paused then
			self:StartPerishing()
		end
    end
end

return Perishable
