// Copyright 2018 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// See the License for the specific language governing permissions and
// limitations under the License.

package core

import (
	mysql "github.com/pingcap/tidb/errno"
	"github.com/pingcap/tidb/util/dbterror"
)

// error definitions.
var (
	ErrUnsupportedType                 = dbterror.ClassOptimizer.NewStd(mysql.ErrUnsupportedType)
	ErrAnalyzeMissIndex                = dbterror.ClassOptimizer.NewStd(mysql.ErrAnalyzeMissIndex)
	ErrWrongParamCount                 = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongParamCount)
	ErrSchemaChanged                   = dbterror.ClassOptimizer.NewStd(mysql.ErrSchemaChanged)
	ErrTablenameNotAllowedHere         = dbterror.ClassOptimizer.NewStd(mysql.ErrTablenameNotAllowedHere)
	ErrNotSupportedYet                 = dbterror.ClassOptimizer.NewStd(mysql.ErrNotSupportedYet)
	ErrWrongUsage                      = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongUsage)
	ErrUnknown                         = dbterror.ClassOptimizer.NewStd(mysql.ErrUnknown)
	ErrUnknownTable                    = dbterror.ClassOptimizer.NewStd(mysql.ErrUnknownTable)
	ErrNoSuchTable                     = dbterror.ClassOptimizer.NewStd(mysql.ErrNoSuchTable)
	ErrViewRecursive                   = dbterror.ClassOptimizer.NewStd(mysql.ErrViewRecursive)
	ErrWrongArguments                  = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongArguments)
	ErrWrongNumberOfColumnsInSelect    = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongNumberOfColumnsInSelect)
	ErrBadGeneratedColumn              = dbterror.ClassOptimizer.NewStd(mysql.ErrBadGeneratedColumn)
	ErrFieldNotInGroupBy               = dbterror.ClassOptimizer.NewStd(mysql.ErrFieldNotInGroupBy)
	ErrBadTable                        = dbterror.ClassOptimizer.NewStd(mysql.ErrBadTable)
	ErrKeyDoesNotExist                 = dbterror.ClassOptimizer.NewStd(mysql.ErrKeyDoesNotExist)
	ErrOperandColumns                  = dbterror.ClassOptimizer.NewStd(mysql.ErrOperandColumns)
	ErrInvalidGroupFuncUse             = dbterror.ClassOptimizer.NewStd(mysql.ErrInvalidGroupFuncUse)
	ErrIllegalReference                = dbterror.ClassOptimizer.NewStd(mysql.ErrIllegalReference)
	ErrNoDB                            = dbterror.ClassOptimizer.NewStd(mysql.ErrNoDB)
	ErrUnknownExplainFormat            = dbterror.ClassOptimizer.NewStd(mysql.ErrUnknownExplainFormat)
	ErrWrongGroupField                 = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongGroupField)
	ErrDupFieldName                    = dbterror.ClassOptimizer.NewStd(mysql.ErrDupFieldName)
	ErrNonUpdatableTable               = dbterror.ClassOptimizer.NewStd(mysql.ErrNonUpdatableTable)
	ErrMultiUpdateKeyConflict          = dbterror.ClassOptimizer.NewStd(mysql.ErrMultiUpdateKeyConflict)
	ErrInternal                        = dbterror.ClassOptimizer.NewStd(mysql.ErrInternal)
	ErrNonUniqTable                    = dbterror.ClassOptimizer.NewStd(mysql.ErrNonuniqTable)
	ErrWindowInvalidWindowFuncUse      = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowInvalidWindowFuncUse)
	ErrWindowInvalidWindowFuncAliasUse = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowInvalidWindowFuncAliasUse)
	ErrWindowNoSuchWindow              = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowNoSuchWindow)
	ErrWindowCircularityInWindowGraph  = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowCircularityInWindowGraph)
	ErrWindowNoChildPartitioning       = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowNoChildPartitioning)
	ErrWindowNoInherentFrame           = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowNoInherentFrame)
	ErrWindowNoRedefineOrderBy         = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowNoRedefineOrderBy)
	ErrWindowDuplicateName             = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowDuplicateName)
	ErrPartitionClauseOnNonpartitioned = dbterror.ClassOptimizer.NewStd(mysql.ErrPartitionClauseOnNonpartitioned)
	ErrWindowFrameStartIllegal         = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowFrameStartIllegal)
	ErrWindowFrameEndIllegal           = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowFrameEndIllegal)
	ErrWindowFrameIllegal              = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowFrameIllegal)
	ErrWindowRangeFrameOrderType       = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowRangeFrameOrderType)
	ErrWindowRangeFrameTemporalType    = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowRangeFrameTemporalType)
	ErrWindowRangeFrameNumericType     = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowRangeFrameNumericType)
	ErrWindowRangeBoundNotConstant     = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowRangeBoundNotConstant)
	ErrWindowRowsIntervalUse           = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowRowsIntervalUse)
	ErrWindowFunctionIgnoresFrame      = dbterror.ClassOptimizer.NewStd(mysql.ErrWindowFunctionIgnoresFrame)
	ErrUnsupportedOnGeneratedColumn    = dbterror.ClassOptimizer.NewStd(mysql.ErrUnsupportedOnGeneratedColumn)
	ErrPrivilegeCheckFail              = dbterror.ClassOptimizer.NewStd(mysql.ErrPrivilegeCheckFail)
	ErrInvalidWildCard                 = dbterror.ClassOptimizer.NewStd(mysql.ErrInvalidWildCard)
	ErrMixOfGroupFuncAndFields         = dbterror.ClassOptimizer.NewStd(mysql.ErrMixOfGroupFuncAndFieldsIncompatible)
	errTooBigPrecision                 = dbterror.ClassExpression.NewStd(mysql.ErrTooBigPrecision)
	ErrDBaccessDenied                  = dbterror.ClassOptimizer.NewStd(mysql.ErrDBaccessDenied)
	ErrTableaccessDenied               = dbterror.ClassOptimizer.NewStd(mysql.ErrTableaccessDenied)
	ErrSpecificAccessDenied            = dbterror.ClassOptimizer.NewStd(mysql.ErrSpecificAccessDenied)
	ErrViewNoExplain                   = dbterror.ClassOptimizer.NewStd(mysql.ErrViewNoExplain)
	ErrWrongValueCountOnRow            = dbterror.ClassOptimizer.NewStd(mysql.ErrWrongValueCountOnRow)
	ErrViewInvalid                     = dbterror.ClassOptimizer.NewStd(mysql.ErrViewInvalid)
	ErrNoSuchThread                    = dbterror.ClassOptimizer.NewStd(mysql.ErrNoSuchThread)
	ErrUnknownColumn                   = dbterror.ClassOptimizer.NewStd(mysql.ErrBadField)
	ErrCartesianProductUnsupported     = dbterror.ClassOptimizer.NewStd(mysql.ErrCartesianProductUnsupported)
	ErrStmtNotFound                    = dbterror.ClassOptimizer.NewStd(mysql.ErrPreparedStmtNotFound)
	ErrAmbiguous                       = dbterror.ClassOptimizer.NewStd(mysql.ErrNonUniq)
	// Since we cannot know if user logged in with a password, use message of ErrAccessDeniedNoPassword instead
	ErrAccessDenied = dbterror.ClassOptimizer.NewStdErr(mysql.ErrAccessDenied, mysql.MySQLErrName[mysql.ErrAccessDeniedNoPassword])
)
