local x={}
local y={}

function onTick(event)
	if (game.tick % 10) == 0 then
        for i,player in pairs(game.players) do
            if player.character ~= nil then
                if x[i]==player.character.position.x and y[i]==player.character.position.y then
                    --stop
                    player.character.health = player.character.health - 10
                    if player.character.health < 1 then
                        player.character.die()
                    end
                else
                    --run
                    x[i]=player.character.position.x
                    y[i]=player.character.position.y
                end
            end
        end
	end
end

function onPlayerCreated(event)
    local player = game.players[event.player_index]
    game.set_game_state{game_finished=false, player_won=false, can_continue=false}
    player.print({"btsRunOrStop.tips"})
end

function onPlayerRespawned(event)
    local player = game.players[event.player_index]
    player.print({"btsRunOrStop.tips"})
end

script.on_event(defines.events.on_tick, onTick)
script.on_event(defines.events.on_player_created, onPlayerCreated)
script.on_event(defines.events.on_player_respawned, onPlayerRespawned)
