/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.JarDiffCodes;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarDiffPatcher
implements JarDiffCodes {
    protected static final int DEFAULT_READ_SIZE = 2048;
    protected static byte[] newBytes = new byte[2048];
    protected static byte[] oldBytes = new byte[2048];

    public void patchJar(String jarPath, String diffPath, File target, ProgressObserver observer) throws IOException {
        File oldFile = new File(jarPath);
        File diffFile = new File(diffPath);
        try (ZipFile oldJar = new ZipFile(oldFile);
             ZipFile jarDiff = new ZipFile(diffFile);
             ZipOutputStream jos = JarDiffPatcher.makeOutputStream(oldFile, target);){
            HashSet<String> ignoreSet = new HashSet<String>();
            HashMap<String, String> renameMap = new HashMap<String, String>();
            this.determineNameMapping(jarDiff, ignoreSet, renameMap);
            String[] keys = renameMap.keySet().toArray(new String[renameMap.size()]);
            HashSet<String> oldjarNames = new HashSet<String>();
            Enumeration<? extends ZipEntry> oldEntries = oldJar.entries();
            if (oldEntries != null) {
                while (oldEntries.hasMoreElements()) {
                    oldjarNames.add(oldEntries.nextElement().getName());
                }
            }
            double size = oldjarNames.size() + keys.length + jarDiff.size();
            double currentEntry = 0.0;
            oldjarNames.removeAll(ignoreSet);
            size -= (double)ignoreSet.size();
            Enumeration<? extends ZipEntry> entries = jarDiff.entries();
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!"META-INF/INDEX.JD".equals(entry.getName())) {
                        this.updateObserver(observer, currentEntry, size);
                        currentEntry += 1.0;
                        this.writeEntry(jos, entry, jarDiff);
                        int wasInOld = oldjarNames.remove(entry.getName()) ? 1 : 0;
                        if (wasInOld == 0) continue;
                        size -= 1.0;
                        continue;
                    }
                    size -= 1.0;
                }
            }
            for (String newName : keys) {
                String oldName = (String)renameMap.get(newName);
                ZipEntry oldEntry = oldJar.getEntry(oldName);
                if (oldEntry == null) {
                    String moveCmd = "move" + oldName + " " + newName;
                    throw new IOException("error.badmove: " + moveCmd);
                }
                ZipEntry newEntry = new ZipEntry(newName);
                newEntry.setTime(oldEntry.getTime());
                newEntry.setSize(oldEntry.getSize());
                newEntry.setCompressedSize(oldEntry.getCompressedSize());
                newEntry.setCrc(oldEntry.getCrc());
                newEntry.setMethod(oldEntry.getMethod());
                newEntry.setExtra(oldEntry.getExtra());
                newEntry.setComment(oldEntry.getComment());
                this.updateObserver(observer, currentEntry, size);
                currentEntry += 1.0;
                try (InputStream data = oldJar.getInputStream(oldEntry);){
                    this.writeEntry(jos, newEntry, data);
                }
                boolean wasInOld = oldjarNames.remove(oldName);
                if (!wasInOld) continue;
                size -= 1.0;
            }
            for (String name : oldjarNames) {
                ZipEntry entry = oldJar.getEntry(name);
                if (entry == null) {
                    throw new AssertionError((Object)("Archive entry not found: " + name));
                }
                this.updateObserver(observer, currentEntry, size);
                currentEntry += 1.0;
                this.writeEntry(jos, entry, oldJar);
            }
            this.updateObserver(observer, currentEntry, size);
        }
    }

    protected void updateObserver(ProgressObserver observer, double currentSize, double size) {
        if (observer != null) {
            observer.progress((int)(100.0 * currentSize / size));
        }
    }

    protected void determineNameMapping(ZipFile jarDiff, Set<String> ignoreSet, Map<String, String> renameMap) throws IOException {
        InputStream is = jarDiff.getInputStream(jarDiff.getEntry("META-INF/INDEX.JD"));
        if (is == null) {
            throw new IOException("error.noindex");
        }
        LineNumberReader indexReader = new LineNumberReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String line = indexReader.readLine();
        if (line == null || !line.equals("version 1.0")) {
            throw new IOException("jardiff.error.badheader: " + line);
        }
        while ((line = indexReader.readLine()) != null) {
            List<String> sub;
            if (line.startsWith("remove")) {
                sub = this.getSubpaths(line.substring("remove".length()));
                if (sub.size() != 1) {
                    throw new IOException("error.badremove: " + line);
                }
                ignoreSet.add(sub.get(0));
                continue;
            }
            if (line.startsWith("move")) {
                sub = this.getSubpaths(line.substring("move".length()));
                if (sub.size() != 2) {
                    throw new IOException("error.badmove: " + line);
                }
                if (renameMap.put(sub.get(1), sub.get(0)) == null) continue;
                throw new IOException("error.badmove: " + line);
            }
            if (line.length() <= 0) continue;
            throw new IOException("error.badcommand: " + line);
        }
    }

    protected List<String> getSubpaths(String path) {
        int index = 0;
        int length = path.length();
        ArrayList<String> sub = new ArrayList<String>();
        while (index < length) {
            while (index < length && Character.isWhitespace(path.charAt(index))) {
                ++index;
            }
            if (index >= length) continue;
            int last = index;
            StringBuilder subString = null;
            while (index < length) {
                char aChar = path.charAt(index);
                if (aChar == '\\' && index + 1 < length && path.charAt(index + 1) == ' ') {
                    if (subString == null) {
                        subString = new StringBuilder(path.substring(last, index));
                    } else {
                        subString.append(path, last, index);
                    }
                    last = ++index;
                } else if (Character.isWhitespace(aChar)) break;
                ++index;
            }
            if (last != index) {
                if (subString == null) {
                    subString = new StringBuilder(path.substring(last, index));
                } else {
                    subString.append(path, last, index);
                }
            }
            if (subString == null) continue;
            sub.add(subString.toString());
        }
        return sub;
    }

    protected void writeEntry(ZipOutputStream jos, ZipEntry entry, ZipFile file) throws IOException {
        try (InputStream data = file.getInputStream(entry);){
            this.writeEntry(jos, entry, data);
        }
    }

    protected void writeEntry(ZipOutputStream jos, ZipEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(new ZipEntry(entry.getName()));
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
    }

    protected static ZipOutputStream makeOutputStream(File source, File target) throws IOException {
        FileOutputStream out = new FileOutputStream(target);
        if (source.getName().endsWith(".jar")) {
            return new JarOutputStream(out);
        }
        if (source.getName().endsWith(".zip")) {
            return new ZipOutputStream(out);
        }
        throw new AssertionError((Object)("Unsupported source file '" + source + "'. Not a .jar or .zip?"));
    }
}

