/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

import com.uwetrottmann.trakt5.TraktV2;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TraktV2Interceptor
implements Interceptor {
    private final TraktV2 trakt;

    public TraktV2Interceptor(TraktV2 trakt) {
        this.trakt = trakt;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return TraktV2Interceptor.handleIntercept(chain, this.trakt.apiKey(), this.trakt.accessToken());
    }

    public static Response handleIntercept(Interceptor.Chain chain, String apiKey, @Nullable String accessToken) throws IOException {
        String retryHeader;
        Response response;
        Request request = chain.request();
        if (!"api.trakt.tv".equals(request.url().host())) {
            return chain.proceed(request);
        }
        Request.Builder builder = request.newBuilder();
        builder.header("Content-Type", "application/json");
        builder.header("trakt-api-key", apiKey);
        builder.header("trakt-api-version", "2");
        if (TraktV2Interceptor.hasNoAuthorizationHeader(request) && TraktV2Interceptor.accessTokenIsNotEmpty(accessToken)) {
            builder.header("Authorization", "Bearer " + accessToken);
        }
        if ((response = chain.proceed(builder.build())).code() == 429 && (retryHeader = response.header("Retry-After")) != null) {
            try {
                int retry = Integer.parseInt(retryHeader);
                Thread.sleep((int)(((double)retry + 0.5) * 1000.0));
                if (response.body() != null) {
                    response.body().close();
                }
                return TraktV2Interceptor.handleIntercept(chain, apiKey, accessToken);
            }
            catch (InterruptedException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return response;
    }

    private static boolean hasNoAuthorizationHeader(Request request) {
        return request.header("Authorization") == null;
    }

    private static boolean accessTokenIsNotEmpty(@Nullable String accessToken) {
        return accessToken != null && accessToken.length() != 0;
    }
}

