/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.videos;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.AbstractVideoDetails;
import java.util.ArrayList;
import java.util.List;

public class VideoDetails
extends AbstractVideoDetails {
    private List<String> keywords;
    private String shortDescription;
    private long viewCount;
    private int averageRating;
    private boolean isLiveContent;
    private String liveUrl;

    public VideoDetails(String string) {
        this.videoId = string;
    }

    public VideoDetails(JSONObject jSONObject, String string) {
        super(jSONObject);
        this.title = jSONObject.getString("title");
        this.author = jSONObject.getString("author");
        this.isLive = jSONObject.getBooleanValue("isLive");
        this.keywords = jSONObject.containsKey("keywords") ? jSONObject.getJSONArray("keywords").toJavaList(String.class) : new ArrayList<String>();
        this.shortDescription = jSONObject.getString("shortDescription");
        this.averageRating = jSONObject.getIntValue("averageRating");
        this.viewCount = jSONObject.getLongValue("viewCount");
        this.isLiveContent = jSONObject.getBooleanValue("isLiveContent");
        this.liveUrl = string;
    }

    @Override
    public boolean isDownloadable() {
        return !this.isLive() && (!this.isLiveContent || this.lengthSeconds() != 0);
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public String description() {
        return this.shortDescription;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public int averageRating() {
        return this.averageRating;
    }

    public boolean isLiveContent() {
        return this.isLiveContent;
    }

    public String liveUrl() {
        return this.liveUrl;
    }
}

