/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.Config;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.YoutubeCallback;
import com.github.kiulian.downloader.downloader.request.RequestChannelUploads;
import com.github.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import com.github.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import com.github.kiulian.downloader.extractor.Extractor;
import com.github.kiulian.downloader.model.playlist.PlaylistDetails;
import com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import com.github.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.model.videos.VideoDetails;
import com.github.kiulian.downloader.model.videos.VideoInfo;
import com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.formats.Itag;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import com.github.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import com.github.kiulian.downloader.parser.Parser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ParserImpl
implements Parser {
    private static final String ANDROID_APIKEY = "AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w";
    private final Config config;
    private final Downloader downloader;
    private final Extractor extractor;
    private final CipherFactory cipherFactory;

    public ParserImpl(Config config, Downloader downloader, Extractor extractor, CipherFactory cipherFactory) {
        this.config = config;
        this.downloader = downloader;
        this.extractor = extractor;
        this.cipherFactory = cipherFactory;
    }

    @Override
    public Response<VideoInfo> parseVideo(RequestVideoInfo requestVideoInfo) {
        if (requestVideoInfo.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<VideoInfo> future = executorService.submit(() -> this.parseVideo(requestVideoInfo.getVideoId(), requestVideoInfo.getCallback()));
            return ResponseImpl.fromFuture(future);
        }
        try {
            VideoInfo videoInfo = this.parseVideo(requestVideoInfo.getVideoId(), requestVideoInfo.getCallback());
            return ResponseImpl.from(videoInfo);
        }
        catch (YoutubeException youtubeException) {
            return ResponseImpl.error(youtubeException);
        }
    }

    private VideoInfo parseVideo(String string, YoutubeCallback<VideoInfo> youtubeCallback) throws YoutubeException {
        VideoInfo videoInfo = this.parseVideoAndroid(string);
        if (videoInfo == null) {
            videoInfo = this.parseVideoWeb(string, youtubeCallback);
        }
        if (youtubeCallback != null) {
            youtubeCallback.onFinished(videoInfo);
        }
        return videoInfo;
    }

    private VideoInfo parseVideoAndroid(String string) throws YoutubeException {
        JSONObject jSONObject;
        String string2 = "https://www.youtube.com/youtubei/v1/player?key=AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w&prettyPrint=false";
        String string3 = "{  \"videoId\": \"" + string + "\",  \"context\": {    \"client\": {      \"hl\": \"en\",      \"gl\": \"US\",      \"clientName\": \"ANDROID\",      \"clientVersion\": \"16.49\"    }  },  \"playbackContext\": {    \"contentPlaybackContext\": {      \"html5Preference\": \"HTML5_PREF_WANTS\"    }  },  \"contentCheckOk\": true,  \"racyCheckOk\": true}";
        RequestWebpage requestWebpage = (RequestWebpage)((RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(string2, "POST", string3).header("Content-Type", "application/json")).header("X-youtube-client-name", "3")).header("X-youtube-client-version", "16.49")).header("Origin", "https://www.youtube.com");
        Response<String> response = this.downloader.downloadWebpage(requestWebpage);
        if (!response.ok()) {
            return null;
        }
        try {
            jSONObject = JSONObject.parseObject(response.data());
        }
        catch (Exception exception) {
            return null;
        }
        VideoDetails videoDetails = this.parseVideoDetails(string, jSONObject);
        if (videoDetails.isDownloadable()) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("responseContext");
            String string4 = this.extractor.extractClientVersionFromContext(jSONObject2);
            List<Format> list = this.parseFormats(jSONObject, null, string4);
            List<SubtitlesInfo> list2 = this.parseCaptions(jSONObject);
            return new VideoInfo(videoDetails, list, list2);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoInfo parseVideoWeb(String string, YoutubeCallback<VideoInfo> youtubeCallback) throws YoutubeException {
        JSONObject jSONObject;
        String string2 = "https://www.youtube.com/watch?v=" + string;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(string2));
        if (!response.ok()) {
            YoutubeException.DownloadException downloadException = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", string2, response.error().getMessage()));
            if (youtubeCallback != null) {
                youtubeCallback.onError(downloadException);
            }
            throw downloadException;
        }
        String string3 = response.data();
        try {
            jSONObject = this.extractor.extractPlayerConfigFromHtml(string3);
        }
        catch (YoutubeException youtubeException) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(youtubeException);
            }
            throw youtubeException;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("args");
        JSONObject jSONObject3 = jSONObject2.getJSONObject("player_response");
        if (!jSONObject3.containsKey("streamingData") && !jSONObject3.containsKey("videoDetails")) {
            throw new YoutubeException.BadPageException("streamingData and videoDetails not found");
        }
        VideoDetails videoDetails = this.parseVideoDetails(string, jSONObject3);
        if (videoDetails.isDownloadable()) {
            String string4;
            try {
                string4 = this.extractor.extractJsUrlFromConfig(jSONObject, string);
            }
            catch (YoutubeException youtubeException) {
                if (youtubeCallback != null) {
                    youtubeCallback.onError(youtubeException);
                }
                throw youtubeException;
            }
            JSONObject jSONObject4 = jSONObject.getJSONObject("args").getJSONObject("player_response").getJSONObject("responseContext");
            String string5 = this.extractor.extractClientVersionFromContext(jSONObject4);
            List<Format> list = this.parseFormats(jSONObject3, string4, string5);
            List<SubtitlesInfo> list2 = this.parseCaptions(jSONObject3);
            return new VideoInfo(videoDetails, list, list2);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoDetails parseVideoDetails(String string, JSONObject jSONObject) {
        if (!jSONObject.containsKey("videoDetails")) {
            return new VideoDetails(string);
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("videoDetails");
        String string2 = null;
        if (jSONObject2.getBooleanValue("isLive") && jSONObject.containsKey("streamingData")) {
            string2 = jSONObject.getJSONObject("streamingData").getString("hlsManifestUrl");
        }
        return new VideoDetails(jSONObject2, string2);
    }

    private List<Format> parseFormats(JSONObject jSONObject, String string, String string2) throws YoutubeException {
        if (!jSONObject.containsKey("streamingData")) {
            throw new YoutubeException.BadPageException("streamingData not found");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("streamingData");
        JSONArray jSONArray = new JSONArray();
        if (jSONObject2.containsKey("formats")) {
            jSONArray.addAll(jSONObject2.getJSONArray("formats"));
        }
        JSONArray jSONArray2 = new JSONArray();
        if (jSONObject2.containsKey("adaptiveFormats")) {
            jSONArray2.addAll(jSONObject2.getJSONArray("adaptiveFormats"));
        }
        ArrayList<Format> arrayList = new ArrayList<Format>(jSONArray.size() + jSONArray2.size());
        this.populateFormats(arrayList, jSONArray, string, false, string2);
        this.populateFormats(arrayList, jSONArray2, string, true, string2);
        return arrayList;
    }

    private void populateFormats(List<Format> list, JSONArray jSONArray, String string, boolean bl, String string2) throws YoutubeException.CipherException {
        for (int i = 0; i < jSONArray.size(); ++i) {
            Itag itag;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if ("FORMAT_STREAM_TYPE_OTF".equals(jSONObject.getString("type"))) continue;
            int n = jSONObject.getIntValue("itag");
            try {
                itag = Itag.valueOf("i" + n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Error parsing format: unknown itag " + n);
                continue;
            }
            try {
                Format format = this.parseFormat(jSONObject, string, itag, bl, string2);
                list.add(format);
                continue;
            }
            catch (YoutubeException.CipherException cipherException) {
                throw cipherException;
            }
            catch (YoutubeException youtubeException) {
                System.err.println("Error " + youtubeException.getMessage() + " parsing format: " + jSONObject);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Format parseFormat(JSONObject jSONObject, String string, Itag itag, boolean bl, String string2) throws YoutubeException {
        boolean bl2;
        if (jSONObject.containsKey("signatureCipher")) {
            Object object;
            JSONObject jSONObject2 = new JSONObject();
            String[] stringArray = jSONObject.getString("signatureCipher").replace("\\u0026", "&").split("&");
            for (String string3 : stringArray) {
                object = string3.split("=");
                jSONObject2.put(object[0], (Object)object[1]);
            }
            if (!jSONObject2.containsKey("url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            Object object2 = jSONObject2.getString("url");
            try {
                object2 = URLDecoder.decode((String)object2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (!((String)object2).contains("signature") && (jSONObject2.containsKey("s") || !((String)object2).contains("&sig=") && !((String)object2).contains("&lsig="))) {
                if (string != null) {
                    String string3;
                    String string4 = jSONObject2.getString("s");
                    try {
                        string4 = URLDecoder.decode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                    Cipher cipher = this.cipherFactory.createCipher(string);
                    string3 = cipher.getSignature(string4);
                    object = (String)object2 + "&sig=" + string3;
                    jSONObject.put("url", object);
                } else {
                    throw new YoutubeException.BadPageException("deciphering is required but no js url");
                }
            }
        }
        boolean bl3 = itag.isVideo() || jSONObject.containsKey("size") || jSONObject.containsKey("width");
        boolean bl4 = bl2 = itag.isAudio() || jSONObject.containsKey("audioQuality");
        if (bl3 && bl2) {
            return new VideoWithAudioFormat(jSONObject, bl, string2);
        }
        if (bl3) {
            return new VideoFormat(jSONObject, bl, string2);
        }
        return new AudioFormat(jSONObject, bl, string2);
    }

    private List<SubtitlesInfo> parseCaptions(JSONObject jSONObject) {
        if (!jSONObject.containsKey("captions")) {
            return Collections.emptyList();
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("captions");
        JSONObject jSONObject3 = jSONObject2.getJSONObject("playerCaptionsTracklistRenderer");
        if (jSONObject3 == null || jSONObject3.isEmpty()) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = jSONObject3.getJSONArray("captionTracks");
        if (jSONArray == null || jSONArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> arrayList = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject4 = jSONArray.getJSONObject(i);
            String string = jSONObject4.getString("languageCode");
            String string2 = jSONObject4.getString("baseUrl");
            String string3 = jSONObject4.getString("vssId");
            if (string == null || string2 == null || string3 == null) continue;
            boolean bl = string3.startsWith("a.");
            arrayList.add(new SubtitlesInfo(string2, string, bl, true));
        }
        return arrayList;
    }

    @Override
    public Response<PlaylistInfo> parsePlaylist(RequestPlaylistInfo requestPlaylistInfo) {
        if (requestPlaylistInfo.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> future = executorService.submit(() -> this.parsePlaylist(requestPlaylistInfo.getPlaylistId(), requestPlaylistInfo.getCallback()));
            return ResponseImpl.fromFuture(future);
        }
        try {
            PlaylistInfo playlistInfo = this.parsePlaylist(requestPlaylistInfo.getPlaylistId(), requestPlaylistInfo.getCallback());
            return ResponseImpl.from(playlistInfo);
        }
        catch (YoutubeException youtubeException) {
            return ResponseImpl.error(youtubeException);
        }
    }

    private PlaylistInfo parsePlaylist(String string, YoutubeCallback<PlaylistInfo> youtubeCallback) throws YoutubeException {
        List<PlaylistVideoDetails> list;
        JSONObject jSONObject;
        String string2 = "https://www.youtube.com/playlist?list=" + string;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(string2));
        if (!response.ok()) {
            YoutubeException.DownloadException downloadException = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", string2, response.error().getMessage()));
            if (youtubeCallback != null) {
                youtubeCallback.onError(downloadException);
            }
            throw downloadException;
        }
        String string3 = response.data();
        try {
            jSONObject = this.extractor.extractInitialDataFromHtml(string3);
        }
        catch (YoutubeException youtubeException) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(youtubeException);
            }
            throw youtubeException;
        }
        if (!jSONObject.containsKey("metadata")) {
            throw new YoutubeException.BadPageException("Invalid initial data json");
        }
        PlaylistDetails playlistDetails = this.parsePlaylistDetails(string, jSONObject);
        try {
            list = this.parsePlaylistVideos(jSONObject, playlistDetails.videoCount());
        }
        catch (YoutubeException youtubeException) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(youtubeException);
            }
            throw youtubeException;
        }
        return new PlaylistInfo(playlistDetails, list);
    }

    private PlaylistDetails parsePlaylistDetails(String string, JSONObject jSONObject) {
        String string2 = jSONObject.getJSONObject("metadata").getJSONObject("playlistMetadataRenderer").getString("title");
        JSONArray jSONArray = jSONObject.getJSONObject("sidebar").getJSONObject("playlistSidebarRenderer").getJSONArray("items");
        String string3 = null;
        try {
            string3 = jSONArray.getJSONObject(1).getJSONObject("playlistSidebarSecondaryInfoRenderer").getJSONObject("videoOwner").getJSONObject("videoOwnerRenderer").getJSONObject("title").getJSONArray("runs").getJSONObject(0).getString("text");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONArray jSONArray2 = jSONArray.getJSONObject(0).getJSONObject("playlistSidebarPrimaryInfoRenderer").getJSONArray("stats");
        int n = this.extractor.extractIntegerFromText(jSONArray2.getJSONObject(0).getJSONArray("runs").getJSONObject(0).getString("text"));
        int n2 = this.extractor.extractIntegerFromText(jSONArray2.getJSONObject(1).getString("simpleText"));
        return new PlaylistDetails(string, string2, string3, n, n2);
    }

    private List<PlaylistVideoDetails> parsePlaylistVideos(JSONObject jSONObject, int n) throws YoutubeException {
        JSONObject jSONObject2;
        try {
            jSONObject2 = jSONObject.getJSONObject("contents").getJSONObject("twoColumnBrowseResultsRenderer").getJSONArray("tabs").getJSONObject(0).getJSONObject("tabRenderer").getJSONObject("content").getJSONObject("sectionListRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("itemSectionRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("playlistVideoListRenderer");
        }
        catch (NullPointerException nullPointerException) {
            throw new YoutubeException.BadPageException("Playlist initial data not found");
        }
        AbstractList abstractList = n > 0 ? new ArrayList(n) : new LinkedList();
        JSONObject jSONObject3 = jSONObject.getJSONObject("responseContext");
        String string = this.extractor.extractClientVersionFromContext(jSONObject3);
        this.populatePlaylist(jSONObject2, abstractList, string);
        return abstractList;
    }

    private void populatePlaylist(JSONObject jSONObject, List<PlaylistVideoDetails> list, String string) throws YoutubeException {
        JSONArray jSONArray;
        if (jSONObject.containsKey("contents")) {
            jSONArray = jSONObject.getJSONArray("contents");
        } else if (jSONObject.containsKey("continuationItems")) {
            jSONArray = jSONObject.getJSONArray("continuationItems");
        } else {
            if (jSONObject.containsKey("continuations")) {
                JSONObject jSONObject2 = jSONObject.getJSONArray("continuations").getJSONObject(0).getJSONObject("nextContinuationData");
                String string2 = jSONObject2.getString("continuation");
                String string3 = jSONObject2.getString("clickTrackingParams");
                this.loadPlaylistContinuation(string2, string3, list, string);
                return;
            }
            return;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            if (jSONObject3.containsKey("playlistVideoRenderer")) {
                list.add(new PlaylistVideoDetails(jSONObject3.getJSONObject("playlistVideoRenderer")));
                continue;
            }
            if (!jSONObject3.containsKey("continuationItemRenderer")) continue;
            JSONObject jSONObject4 = jSONObject3.getJSONObject("continuationItemRenderer").getJSONObject("continuationEndpoint");
            String string4 = jSONObject4.getJSONObject("continuationCommand").getString("token");
            String string5 = jSONObject4.getString("clickTrackingParams");
            this.loadPlaylistContinuation(string4, string5, list, string);
        }
    }

    private void loadPlaylistContinuation(String string, String string2, List<PlaylistVideoDetails> list, String string3) throws YoutubeException {
        String string4 = "https://www.youtube.com/youtubei/v1/browse?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        JSONObject jSONObject = new JSONObject().fluentPut("context", new JSONObject().fluentPut("client", new JSONObject().fluentPut("clientName", "WEB").fluentPut("clientVersion", "2.20201021.03.00"))).fluentPut("continuation", string).fluentPut("clickTracking", new JSONObject().fluentPut("clickTrackingParams", string2));
        RequestWebpage requestWebpage = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(string4, "POST", jSONObject.toJSONString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", string3)).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(requestWebpage);
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", string4, response.error().getMessage()));
        }
        String string5 = response.data();
        try {
            JSONObject jSONObject2 = JSON.parseObject(string5);
            JSONObject jSONObject3 = jSONObject2.containsKey("continuationContents") ? jSONObject2.getJSONObject("continuationContents").getJSONObject("playlistVideoListContinuation") : jSONObject2.getJSONArray("onResponseReceivedActions").getJSONObject(0).getJSONObject("appendContinuationItemsAction");
            this.populatePlaylist(jSONObject3, list, string3);
        }
        catch (YoutubeException youtubeException) {
            throw youtubeException;
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Could not parse playlist continuation json");
        }
    }

    @Override
    public Response<PlaylistInfo> parseChannelsUploads(RequestChannelUploads requestChannelUploads) {
        if (requestChannelUploads.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> future = executorService.submit(() -> this.parseChannelsUploads(requestChannelUploads.getChannelId(), requestChannelUploads.getCallback()));
            return ResponseImpl.fromFuture(future);
        }
        try {
            PlaylistInfo playlistInfo = this.parseChannelsUploads(requestChannelUploads.getChannelId(), requestChannelUploads.getCallback());
            return ResponseImpl.from(playlistInfo);
        }
        catch (YoutubeException youtubeException) {
            return ResponseImpl.error(youtubeException);
        }
    }

    private PlaylistInfo parseChannelsUploads(String string, YoutubeCallback<PlaylistInfo> youtubeCallback) throws YoutubeException {
        Object object;
        String string2 = null;
        if (string.length() == 24 && string.startsWith("UC")) {
            string2 = "UU" + string.substring(2);
        } else {
            object = "https://www.youtube.com/c/" + string + "/videos?view=57";
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage((String)object));
            if (!response.ok()) {
                YoutubeException.DownloadException downloadException = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", object, response.error().getMessage()));
                if (youtubeCallback != null) {
                    youtubeCallback.onError(downloadException);
                }
                throw downloadException;
            }
            String string3 = response.data();
            Scanner scanner = new Scanner(string3);
            scanner.useDelimiter("list=");
            while (scanner.hasNext()) {
                String string4 = scanner.next();
                if (!string4.startsWith("UU")) continue;
                string2 = string4.substring(0, 24);
                break;
            }
        }
        if (string2 == null) {
            object = new YoutubeException.BadPageException("Upload Playlist not found");
            if (youtubeCallback != null) {
                youtubeCallback.onError((Throwable)object);
            }
            throw object;
        }
        return this.parsePlaylist(string2, youtubeCallback);
    }

    @Override
    public Response<List<SubtitlesInfo>> parseSubtitlesInfo(RequestSubtitlesInfo requestSubtitlesInfo) {
        if (requestSubtitlesInfo.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<List> future = executorService.submit(() -> this.parseSubtitlesInfo(requestSubtitlesInfo.getVideoId(), requestSubtitlesInfo.getCallback()));
            return ResponseImpl.fromFuture(future);
        }
        try {
            List<SubtitlesInfo> list = this.parseSubtitlesInfo(requestSubtitlesInfo.getVideoId(), requestSubtitlesInfo.getCallback());
            return ResponseImpl.from(list);
        }
        catch (YoutubeException youtubeException) {
            return ResponseImpl.error(youtubeException);
        }
    }

    private List<SubtitlesInfo> parseSubtitlesInfo(String string, YoutubeCallback<List<SubtitlesInfo>> youtubeCallback) throws YoutubeException {
        List<String> list;
        String string2 = "https://video.google.com/timedtext?hl=en&type=list&v=" + string;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(string2));
        if (!response.ok()) {
            YoutubeException.DownloadException downloadException = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", string2, response.error().getMessage()));
            if (youtubeCallback != null) {
                youtubeCallback.onError(downloadException);
            }
            throw downloadException;
        }
        String string3 = response.data();
        try {
            list = this.extractor.extractSubtitlesLanguagesFromXml(string3);
        }
        catch (YoutubeException youtubeException) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(youtubeException);
            }
            throw youtubeException;
        }
        ArrayList<SubtitlesInfo> arrayList = new ArrayList<SubtitlesInfo>();
        for (String string4 : list) {
            String string5 = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", string4, string);
            arrayList.add(new SubtitlesInfo(string5, string4, false));
        }
        return arrayList;
    }
}

