/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private \u01b4 digest;
    private \u0247 cipher;
    private \u1e2c algId;

    protected DigestSignatureSpi(\u01b4 \u01b42, \u0247 \u02472) {
        this.digest = \u01b42;
        this.cipher = \u02472;
        this.algId = null;
    }

    protected DigestSignatureSpi(\ua7a7 \ua7a72, \u01b4 \u01b42, \u0247 \u02472) {
        this.digest = \u01b42;
        this.cipher = \u02472;
        this.algId = new \u1e2c(\ua7a72, \u13bd.\ua642);
    }

    @Override
    protected void engineInitVerify(PublicKey object) {
        if (!(object instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPublicKey instance");
        }
        object = \u1f6b.\ua642((RSAPublicKey)object);
        this.digest.\ua642();
        this.cipher.\ua642(false, (\u04fe)object);
    }

    @Override
    protected void engineInitSign(PrivateKey object) {
        if (!(object instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPrivateKey instance");
        }
        object = \u1f6b.\ua642((RSAPrivateKey)object);
        this.digest.\ua642();
        this.cipher.\ua642(true, (\u04fe)object);
    }

    private String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.digest.\ua642(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.\ua642(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() {
        byte[] byArray = new byte[this.digest.\ua642()];
        this.digest.\ua642(byArray, 0);
        try {
            byArray = this.derEncode(byArray);
            return this.cipher.\ua642(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        byte[] byArray2 = new byte[this.digest.\ua642()];
        this.digest.\ua642(byArray2, 0);
        try {
            byArray = this.cipher.\ua642(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            return \u04c9.\ua643(byArray, byArray2);
        }
        if (byArray.length == byArray2.length - 2) {
            int n;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n2 = 4 + byArray2[3];
            int n3 = n2 + 2;
            int n4 = 0;
            for (n = 0; n < byArray2.length - n3; ++n) {
                n4 |= byArray[n2 + n] ^ byArray2[n3 + n];
            }
            for (n = 0; n < n2; ++n) {
                n4 |= byArray[n] ^ byArray2[n];
            }
            return n4 == 0;
        }
        \u04c9.\ua643(byArray2, byArray2);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] byArray) {
        if (this.algId == null) {
            return byArray;
        }
        return new \u01bc(this.algId, byArray).\ua642("DER");
    }
}

