/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends \u1f63 {
    @Override
    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        if (clazz.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            key = (RSAPublicKey)key;
            return new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            key = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(key.getModulus(), key.getPrivateExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            key = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
        }
        if (clazz.isAssignableFrom(\u1e72.class) && key instanceof RSAPublicKey) {
            try {
                return new \u1e72(\ua734.\ua642(new \u2c52(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\u01a5.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \u01a5(\uff3a.\ua642(new \u2c22(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\ua669.class) && key instanceof RSAPublicKey) {
            try {
                return new \ua669(\ua734.\ua642(new \u2c52(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\ua668.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \ua668(\uff3a.\ua642(new \u2c22(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    @Override
    protected Key engineTranslateKey(Key key) {
        if (key instanceof RSAPublicKey) {
            return new \ua646((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new \u2c7f((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new \ua647((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(\ua7a9.\ua642(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                try {
                    return new \u2c7f(\ua68f.\ua642(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception2) {
                    throw new \u1ece("unable to process key spec: " + exception.toString(), exception);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new \u2c7f((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new \ua647((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof \u01a5) {
            \u1eb1 \u1eb12 = \uff3a.\ua642(((\u01a5)keySpec).getEncoded());
            if (\u1eb12 instanceof \u2c22) {
                return new \u2c7f((\u2c22)\u1eb12);
            }
            throw new InvalidKeySpecException("open SSH public key is not RSA private key");
        }
        throw new InvalidKeySpecException("unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec object) {
        if (object instanceof RSAPublicKeySpec) {
            return new \ua646((RSAPublicKeySpec)object);
        }
        if (object instanceof \u1e72) {
            if ((object = \ua734.\ua642(((\u1e72)object).getEncoded())) instanceof \u2c52) {
                return new \ua646((\u2c52)object);
            }
            throw new InvalidKeySpecException("Open SSH public key is not RSA public key");
        }
        return super.engineGeneratePublic((KeySpec)object);
    }

    @Override
    public PrivateKey generatePrivate(\ua7a9 \ua7a92) {
        \u1f8f \u1f872 = \ua7a92.\ua642.\ua642;
        if (\u1f6b.\ua642(\u1f872)) {
            \u1f872 = \ua68f.\ua642(\ua7a92.\ua642());
            if (((\ua68f)\u1f872).\ua64c.intValue() == 0) {
                return new \ua647(\ua7a92.\ua642, (\ua68f)\u1f872);
            }
            return new \u2c7f(\ua7a92);
        }
        throw new IOException("algorithm identifier " + \u1f872 + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(\u0467 \u04672) {
        \ua7a7 \ua7a72 = \u04672.\ua642.\ua642;
        if (\u1f6b.\ua642(\ua7a72)) {
            return new \ua646(\u04672);
        }
        throw new IOException("algorithm identifier " + \ua7a72 + " in key not recognised");
    }
}

