/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.JsonSerializable;

public abstract class AbstractModel
implements JsonSerializable {
    protected static final ObjectMapper OM = new ObjectMapper();
    protected String mType;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static int parseInt(JsonNode jsonNode, String string) {
        return jsonNode.has(string) ? jsonNode.get(string).getIntValue() : -1;
    }

    public static String parseString(JsonNode jsonNode, String string) {
        return jsonNode.has(string) ? jsonNode.get(string).getTextValue() : null;
    }

    public static Boolean parseBoolean(JsonNode jsonNode, String string) {
        boolean bl = jsonNode.has(string);
        if (bl) {
            return jsonNode.get(string).getBooleanValue();
        }
        return null;
    }

    public static Double parseDouble(JsonNode jsonNode, String string) {
        return jsonNode.has(string) ? Double.valueOf(jsonNode.get(string).getDoubleValue()) : null;
    }

    public static ArrayList<String> getStringArray(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
            ArrayList<String> arrayList = new ArrayList<String>(arrayNode.size());
            for (int i = 0; i < arrayNode.size(); ++i) {
                arrayList.add(arrayNode.get(i).getTextValue());
            }
            return arrayList;
        }
        return new ArrayList<String>(0);
    }

    public static ArrayList<Integer> getIntegerArray(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(arrayNode.size());
            for (int i = 0; i < arrayNode.size(); ++i) {
                arrayList.add(arrayNode.get(i).getIntValue());
            }
            return arrayList;
        }
        return new ArrayList<Integer>(0);
    }

    public static HashMap<String, String> getStringMap(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            ObjectNode objectNode = (ObjectNode)jsonNode.get(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = objectNode.getFieldNames();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, objectNode.get(string2).getValueAsText());
            }
            return hashMap;
        }
        return new HashMap<String, String>();
    }
}

